/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.nanoj.util.introspection.BeanGetter;
import org.nanoj.util.introspection.BeanSetter;

public class BeanIntrospector {
    private static final BeanGetter[] VOID_GETTERS_ARRAY = new BeanGetter[0];
    private static final BeanSetter[] VOID_SETTERS_ARRAY = new BeanSetter[0];
    private static final String ERROR_GET_GETTER_METHOD = "Cannot get method for getter ";
    private static final String ERROR_INVOKE_GETTER_METHOD = "Cannot invoke method for getter ";

    public static final Method[] getMethods(Object bean) {
        Class<?> beanClass = bean.getClass();
        Method[] methods = null;
        try {
            methods = beanClass.getMethods();
        }
        catch (SecurityException e) {
            throw new RuntimeException("mapToBean : security violation, class = " + beanClass.getName(), e);
        }
        return methods;
    }

    private static final String getPropertyName(String sMethodName) {
        char c = sMethodName.charAt(3);
        if (c >= 'A' && c <= 'Z') {
            c = Character.toLowerCase(c);
        }
        String propertyName = c + sMethodName.substring(4);
        return propertyName;
    }

    public static final boolean isGetter(Method m) {
        String sMethodName = m.getName();
        Class<?>[] paramTypes = m.getParameterTypes();
        return sMethodName.length() > 3 && sMethodName.startsWith("get") && paramTypes.length == 0 && !"getClass".equals(sMethodName);
    }

    public static final boolean isSetter(Method m) {
        String sMethodName = m.getName();
        Class<?>[] paramTypes = m.getParameterTypes();
        return sMethodName.length() > 3 && sMethodName.startsWith("set") && paramTypes.length == 1;
    }

    public static final BeanGetter[] getGetters(Object bean) {
        Method[] methods = BeanIntrospector.getMethods(bean);
        if (methods != null) {
            Method m = null;
            LinkedList<BeanGetter> getters = new LinkedList<BeanGetter>();
            for (int i = 0; i < methods.length; ++i) {
                m = methods[i];
                if (!BeanIntrospector.isGetter(m)) continue;
                String propertyName = BeanIntrospector.getPropertyName(m.getName());
                getters.add(new BeanGetter(m, propertyName));
            }
            return getters.toArray(VOID_GETTERS_ARRAY);
        }
        return VOID_GETTERS_ARRAY;
    }

    public static final BeanSetter[] getSetters(Object bean) {
        Method[] methods = BeanIntrospector.getMethods(bean);
        if (methods != null) {
            Method m = null;
            LinkedList<BeanSetter> setters = new LinkedList<BeanSetter>();
            for (int i = 0; i < methods.length; ++i) {
                m = methods[i];
                if (!BeanIntrospector.isSetter(m)) continue;
                String propertyName = BeanIntrospector.getPropertyName(m.getName());
                setters.add(new BeanSetter(m, propertyName));
            }
            return setters.toArray(VOID_SETTERS_ARRAY);
        }
        return VOID_SETTERS_ARRAY;
    }

    public static Field getFieldByName(Class<?> c, String fieldName) throws SecurityException, NoSuchFieldException {
        Field f = null;
        try {
            f = c.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> ancestor = c.getSuperclass();
            if (ancestor != null) {
                if (ancestor.getSuperclass() != null) {
                    f = BeanIntrospector.getFieldByName(ancestor, fieldName);
                }
                throw e;
            }
            throw e;
        }
        return f;
    }

    public static Object invokeGetter(Object instance, String getterName) {
        Object o = BeanIntrospector.invokeGetter(instance, getterName, Object.class);
        return o;
    }

    public static <T> T invokeGetter(Object instance, String getterName, Class<T> expectedClass) {
        Method m;
        if (null == instance) {
            throw new IllegalArgumentException("Object instance argument is null");
        }
        if (null == getterName) {
            throw new IllegalArgumentException("Getter name argument is null");
        }
        if (null == expectedClass) {
            throw new IllegalArgumentException("Expected class argument is null");
        }
        Class<?> cl = instance.getClass();
        Object result = null;
        try {
            m = cl.getMethod(getterName, null);
        }
        catch (SecurityException e) {
            throw new RuntimeException(ERROR_GET_GETTER_METHOD + getterName + "(SecurityException)", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(ERROR_GET_GETTER_METHOD + getterName + "(NoSuchMethodException)", e);
        }
        try {
            result = m.invoke(instance, (Object[])null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(ERROR_INVOKE_GETTER_METHOD + getterName + "(IllegalArgumentException)", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(ERROR_INVOKE_GETTER_METHOD + getterName + "(IllegalAccessException)", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(ERROR_INVOKE_GETTER_METHOD + getterName + "(InvocationTargetException)", e);
        }
        if (expectedClass.isInstance(result)) {
            return expectedClass.cast(result);
        }
        return null;
    }
}

