/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.introspection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BeanSetter {
    private static final String ERROR_INVOKE_SETTER = "Cannot invoke setter ";
    String propertyName = "";
    Class<?> propertyType = null;
    Method method = null;

    public BeanSetter(Method method, String propertyName) {
        this.method = method;
        this.propertyName = propertyName;
        this.propertyType = method.getParameterTypes()[0];
    }

    public Method getMethod() {
        return this.method;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public void invoke(Object bean, Object value) {
        String sMethodName = this.method.getName();
        Object[] params = new Object[]{value};
        try {
            this.method.invoke(bean, params);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(ERROR_INVOKE_SETTER + sMethodName, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(ERROR_INVOKE_SETTER + sMethodName, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(ERROR_INVOKE_SETTER + sMethodName, e);
        }
    }
}

