/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.serial;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MemorySerializer {
    private byte[] _lastSerializedObject = null;

    public byte[] write(Object obj) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
        }
        catch (IOException e2) {
            throw new Exception("Cannot create ObjectOutputStream", e2);
        }
        try {
            oos.writeObject(obj);
            this._lastSerializedObject = baos.toByteArray();
            oos.close();
            baos.close();
        }
        catch (IOException e3) {
            throw new Exception("ObjectOutputStream cannot write object ", e3);
        }
        return this._lastSerializedObject;
    }

    public Object read() throws Exception {
        if (this._lastSerializedObject != null) {
            return this.read(this._lastSerializedObject);
        }
        return null;
    }

    public Object read(byte[] serializedObject) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedObject);
        ObjectInputStream ois = null;
        Object obj = null;
        try {
            ois = new ObjectInputStream(bais);
        }
        catch (IOException e2) {
            throw new Exception("Cannot create ObjectInputStream", e2);
        }
        try {
            obj = ois.readObject();
            ois.close();
            bais.close();
        }
        catch (IOException e3) {
            throw new Exception("ObjectOutputStream cannot read object (IOException)", e3);
        }
        catch (ClassNotFoundException e4) {
            throw new Exception("ObjectOutputStream cannot read object (ClassNotFoundException)", e4);
        }
        return obj;
    }
}

