/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.serial;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class RecordSerializer {
    private String _sDataDirectory = null;

    public RecordSerializer(String sDataDirectory) {
        this._sDataDirectory = sDataDirectory.endsWith("/") ? sDataDirectory : sDataDirectory + "/";
        String sDir = this._sDataDirectory.substring(0, this._sDataDirectory.length() - 1);
        File file = new File(sDir);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    private String getFileName(Class<?> cl, String sKey) {
        return this._sDataDirectory + cl.getName() + "-" + sKey;
    }

    public void save(Object obj, String sKey) {
        if (obj == null) {
            throw new RuntimeException("save : Object to save is null");
        }
        if (sKey == null) {
            throw new RuntimeException("load : Key is null");
        }
        if (!(obj instanceof Serializable)) {
            throw new RuntimeException("save : Object to save (class '" + obj.getClass().getName() + "') is not serializable");
        }
        String sFileName = this.getFileName(obj.getClass(), sKey);
        try {
            FileOutputStream fos = new FileOutputStream(sFileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(obj);
            oos.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("save : FileNotFoundException - file ='" + sFileName + "'", e);
        }
        catch (IOException e) {
            throw new RuntimeException("save : IOException - file ='" + sFileName + "'", e);
        }
    }

    public Object load(Class<?> cl, String sKey) {
        FileInputStream fis;
        if (cl == null) {
            throw new RuntimeException("load : Object class is null");
        }
        if (sKey == null) {
            throw new RuntimeException("load : Key is null");
        }
        String sFileName = this.getFileName(cl, sKey);
        try {
            fis = new FileInputStream(sFileName);
        }
        catch (FileNotFoundException e1) {
            return null;
        }
        Object obj = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(fis);
            obj = ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            throw new RuntimeException("load : IOException - file ='" + sFileName + "'", e);
        }
        catch (ClassNotFoundException e) {
            try {
                fis.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw new RuntimeException("load : ClassNotFoundException - file ='" + sFileName + "'", e);
        }
        return obj;
    }

    public int delete(Class<?> cl, String sKey) {
        if (cl == null) {
            throw new RuntimeException("load : Object class is null");
        }
        if (sKey == null) {
            throw new RuntimeException("load : Key is null");
        }
        String sFileName = this.getFileName(cl, sKey);
        File file = new File(sFileName);
        if (file.exists()) {
            file.delete();
            return 1;
        }
        return 0;
    }
}

