/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.tson;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import org.nanoj.util.DateUtil;
import org.nanoj.util.tson.Attribute;
import org.nanoj.util.tson.ParserUtil;

public class Parser {
    private static final String INVALID_SYNTAX = "Invalid syntax";
    private static final String INVALID_VALUE = "Invalid value";
    private static final String UNEXPECTED_END = "Unexpected end of input";
    private byte[] input = null;
    private int pos = 0;
    private HashMap<String, Class<?>> map = null;
    static final int TRUE_SIZE = 4;

    private void log(String msg) {
    }

    public Parser(byte[] input, HashMap<String, Class<?>> map) {
        this.input = input;
        this.map = map;
    }

    public Object parse() {
        this.log("parse()...");
        byte b = 0;
        while ((b = this.nextByte()) > 0) {
            if (b == 123) {
                this.log("parse() : { found => parse ENTITY ");
                Object oEntity = this.parseEntity();
                return oEntity;
            }
            if (b != 91) continue;
            this.log("parse() : [ found => parse LIST ");
            LinkedList<Object> oList = this.parseList();
            return oList;
        }
        return null;
    }

    private byte nextByte() {
        byte b = 0;
        do {
            if (this.pos < this.input.length) continue;
            return 0;
        } while ((b = this.input[this.pos++]) == 32 || b == 8 || b == 12 || b == 10 || b == 13 || b == 9);
        return b;
    }

    private void rewind() {
        if (this.pos > 0) {
            --this.pos;
        }
    }

    private boolean isValidNameChar(byte b) {
        return b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || b == 95;
    }

    private String nextName(byte separator) {
        this.log("nextName(" + (char)separator + ")...");
        byte b = this.nextByte();
        if (b == 125 && separator == 61) {
            return null;
        }
        this.log("nextName : first char = " + (char)b);
        if (!this.isValidNameChar(b)) {
            throw new RuntimeException(INVALID_SYNTAX);
        }
        this.rewind();
        int start = this.pos;
        int length = 0;
        do {
            if (this.pos >= this.input.length) {
                throw new RuntimeException(INVALID_SYNTAX);
            }
            b = this.input[this.pos++];
            ++length;
        } while (this.isValidNameChar(b));
        this.rewind();
        if (--length <= 0) {
            throw new RuntimeException(INVALID_SYNTAX);
        }
        String name = new String(this.input, start, length);
        this.log("nextName : name = '" + name + "'");
        b = this.nextByte();
        if (b == separator) {
            return name;
        }
        throw new RuntimeException("Invalid syntax : separator expected (not '" + (char)b + "' )");
    }

    private Object nextValue(String name) {
        this.log("nextValue( '" + name + "') ");
        byte b = this.nextByte();
        if (b == 0) {
            throw new RuntimeException("Invalid syntax : value expected ");
        }
        if (b == 123) {
            Object oEntity = this.parseEntity();
            return oEntity;
        }
        if (b == 91) {
            LinkedList<Object> oList = this.parseList();
            return oList;
        }
        if (b == 34) {
            return this.readStringValue(name);
        }
        if (b == 39) {
            return this.readDateTimeValue(name);
        }
        this.rewind();
        return this.readLiteralValue(name, b);
    }

    private String readStringValue(String name) {
        this.log("readStringValue( '" + name + "') ");
        StringBuffer sb = new StringBuffer();
        while (this.pos < this.input.length) {
            byte b = this.input[this.pos++];
            int c = 63;
            if (b == 34) {
                String s = sb.toString();
                this.log("readStringValue() : return '" + s + "'");
                return s;
            }
            if (b == 92) {
                b = this.input[this.pos++];
                switch (b) {
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 117: {
                        throw new RuntimeException("Unicode character not yet supported");
                    }
                    default: {
                        c = (char)b;
                        break;
                    }
                }
            } else {
                c = (char)b;
            }
            sb.append((char)c);
        }
        throw new RuntimeException("Invalid syntax : unterminated String value for '" + name + "'");
    }

    private Date readDateTimeValue(String name) {
        this.log("readDateTimeValue( '" + name + "') ");
        StringBuffer sb = new StringBuffer();
        while (this.pos < this.input.length) {
            byte b;
            if ((b = this.input[this.pos++]) == 39) {
                String s = sb.toString();
                this.log("readStringValue() : return '" + s + "'");
                return DateUtil.parse(s);
            }
            sb.append((char)b);
        }
        throw new RuntimeException("Invalid syntax : unterminated Date/Time value for '" + name + "'");
    }

    private byte[] readBytes(int n) {
        if (this.pos + n <= this.input.length) {
            byte[] bytes = new byte[n];
            for (int i = 0; i < n; ++i) {
                bytes[i] = this.input[this.pos++];
            }
            return bytes;
        }
        throw new RuntimeException(UNEXPECTED_END);
    }

    private Object readLiteralValue(String name, byte first) {
        if (first == 116) {
            this.readTrueValue(name);
            return true;
        }
        if (first == 102) {
            this.readFalseValue(name);
            return false;
        }
        if (first == 110) {
            this.readNullValue(name);
            return null;
        }
        String s = this.readNumberValue(name);
        if (s.indexOf(46) >= 0) {
            return new BigDecimal(s);
        }
        return new BigInteger(s);
    }

    private void readTrueValue(String name) {
        byte[] bytes = this.readBytes(4);
        String s = new String(bytes);
        if ("true".equals(s)) {
            return;
        }
        throw new RuntimeException("Invalid value '" + s + "' for attribute '" + name + "'");
    }

    private void readFalseValue(String name) {
        byte[] bytes = this.readBytes(5);
        String s = new String(bytes);
        if ("false".equals(s)) {
            return;
        }
        throw new RuntimeException("Invalid value '" + s + "' for attribute '" + name + "'");
    }

    private void readNullValue(String name) {
        byte[] bytes = this.readBytes(4);
        String s = new String(bytes);
        if ("null".equals(s)) {
            return;
        }
        throw new RuntimeException("Invalid value '" + s + "' for attribute '" + name + "'");
    }

    private String readNumberValue(String name) {
        this.log("readNumberValue( '" + name + "') ");
        StringBuffer sb = new StringBuffer();
        while (this.pos < this.input.length) {
            byte b;
            if ((b = this.input[this.pos++]) >= 48 && b <= 57 || b == 46 || b == 43 || b == 45) {
                sb.append((char)b);
                this.log("readNumberValue( '" + name + "') : append '" + (char)b + "'");
                continue;
            }
            this.rewind();
            String s = sb.toString();
            this.log("readNumberValue( '" + name + "') : return '" + s + "'");
            if (s.length() == 0) {
                throw new RuntimeException("Invalid value for attribute '" + name + "'");
            }
            return s;
        }
        throw new RuntimeException(UNEXPECTED_END);
    }

    private Attribute nextAttribute() {
        String name = this.nextName((byte)61);
        this.log("attribute name = '" + name + "'");
        if (name == null) {
            return null;
        }
        Object value = this.nextValue(name);
        this.log("attribute value = '" + value + "'");
        Attribute attr = new Attribute();
        attr.name = name;
        attr.value = value;
        return attr;
    }

    private Object parseEntity() {
        this.log("parseEntity()...");
        String name = this.nextName((byte)58);
        this.log("name = '" + name + "'");
        Object oEntity = null;
        Class<?> c = this.map.get(name);
        if (c != null) {
            try {
                oEntity = c.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Cannot create instance for class '" + c.getName() + "'", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot create instance for class '" + c.getName() + "'", e);
            }
        } else {
            throw new RuntimeException("Unknown entity '" + name + "' : cannot create object instance");
        }
        Attribute attr = null;
        while ((attr = this.nextAttribute()) != null) {
            ParserUtil.setFieldValue(oEntity, attr.name, attr.value);
        }
        return oEntity;
    }

    private LinkedList<Object> parseList() {
        this.log("parseList()...");
        LinkedList<Object> list = new LinkedList<Object>();
        byte b = 0;
        while ((b = this.nextByte()) > 0) {
            if (b == 123) {
                this.log("parseList() : '{' found => parse ENTITY ");
                Object oEntity = this.parseEntity();
                this.log("parseList() : entity added " + oEntity.getClass().getName());
                list.add(oEntity);
                continue;
            }
            if (b == 93) {
                this.log("parseList() : ']' found => END OF LIST ");
                return list;
            }
            throw new RuntimeException("Syntax error in list : '" + (char)b + " found, '{' expected ");
        }
        return list;
    }
}

