/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.injector.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.nanoj.injector.InjectorException;

public abstract class AbstractInterceptorProvider {
    protected <T extends Annotation> T getAnnotationFromInterface(Class<T> annotationClass, Method interfaceMethod) {
        Class<?> c = interfaceMethod.getDeclaringClass();
        if (c.isInterface()) {
            return interfaceMethod.getAnnotation(annotationClass);
        }
        throw new InjectorException("The class '" + c.getSimpleName() + "' is not an interface");
    }

    protected <T extends Annotation> T getAnnotationFromImplementation(Class<T> annotationClass, Method interfaceMethod, Object implementationInstance) {
        Class<?> implementationClass = implementationInstance.getClass();
        String errMessage = "Cannot get method '" + interfaceMethod.getName() + "' from implementation class '" + implementationClass.getSimpleName() + "'";
        Method implementationMethod = null;
        try {
            implementationMethod = implementationClass.getMethod(interfaceMethod.getName(), interfaceMethod.getParameterTypes());
        }
        catch (SecurityException e) {
            throw new InjectorException(errMessage, e);
        }
        catch (NoSuchMethodException e) {
            throw new InjectorException(errMessage, e);
        }
        return implementationMethod.getAnnotation(annotationClass);
    }

    protected <T extends Annotation> T getAnnotation(Class<T> annotationClass, Method interfaceMethod, Object implementationInstance) {
        T annotation = null;
        annotation = this.getAnnotationFromInterface(annotationClass, interfaceMethod);
        if (annotation != null) {
            return annotation;
        }
        annotation = this.getAnnotationFromImplementation(annotationClass, interfaceMethod, implementationInstance);
        if (annotation != null) {
            return annotation;
        }
        return null;
    }

    protected boolean annotationExistsInInterface(Class<? extends Annotation> annotationClass, Method interfaceMethod) {
        return this.getAnnotationFromInterface(annotationClass, interfaceMethod) != null;
    }

    protected boolean annotationExistsInImplementation(Class<? extends Annotation> annotationClass, Method interfaceMethod, Object implementationInstance) {
        return this.getAnnotationFromImplementation(annotationClass, interfaceMethod, implementationInstance) != null;
    }

    protected boolean annotationExists(Class<? extends Annotation> annotationClass, Method interfaceMethod, Object implementationInstance) {
        if (this.annotationExistsInInterface(annotationClass, interfaceMethod)) {
            return true;
        }
        return this.annotationExistsInImplementation(annotationClass, interfaceMethod, implementationInstance);
    }
}

