/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.injector.dynaproxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nanoj.injector.aop.Interceptor;
import org.nanoj.injector.aop.InterceptorProvider;
import org.nanoj.injector.impl.InjectorImpl;
import org.nanoj.injector.tools.MethodInvoker;
import org.nanoj.util.ConsoleLoggerProvider;

public class GenericInvocationHandler
implements InvocationHandler {
    private static final Logger logger = ConsoleLoggerProvider.getLogger(InjectorImpl.class, (Level)Level.INFO);
    private static final Interceptor[] VOID_INTERCEPTOR_ARRAY = new Interceptor[0];
    private final Object componentInstance;
    private final InterceptorProvider[] interceptorProviders;

    public GenericInvocationHandler(Object componentInstance, InterceptorProvider[] interceptorProviders) {
        if (null == componentInstance) {
            throw new IllegalArgumentException("Component instance is null");
        }
        this.componentInstance = componentInstance;
        this.interceptorProviders = interceptorProviders;
    }

    private Interceptor[] getActiveInterceptorsForMethod(Method method) {
        if (this.interceptorProviders != null) {
            LinkedList<Interceptor> activeInterceptors = new LinkedList<Interceptor>();
            for (int i = 0; i < this.interceptorProviders.length; ++i) {
                InterceptorProvider interceptorProvider = this.interceptorProviders[i];
                Interceptor interceptor = interceptorProvider.getInterceptor(method, this.componentInstance);
                if (interceptor == null) continue;
                activeInterceptors.add(interceptor);
            }
            if (activeInterceptors.size() > 0) {
                return activeInterceptors.toArray(VOID_INTERCEPTOR_ARRAY);
            }
        }
        return null;
    }

    private void notifyInterceptorsBeforeCall(Interceptor[] interceptors, Method method, Object[] args) {
        for (int i = 0; i < interceptors.length; ++i) {
            Interceptor interceptor = interceptors[i];
            if (interceptor == null) continue;
            interceptor.beforeCall(this.componentInstance, method, args);
        }
    }

    private void notifyInterceptorsAfterCall(Interceptor[] interceptors, Method method, Object[] args, Object result) {
        for (int i = interceptors.length - 1; i >= 0; --i) {
            Interceptor interceptor = interceptors[i];
            if (interceptor == null) continue;
            interceptor.afterCall(this.componentInstance, method, args, result);
        }
    }

    private void notifyInterceptorsOnError(Interceptor[] interceptors, Method method, Object[] args, Exception exception) {
        for (int i = interceptors.length - 1; i >= 0; --i) {
            Interceptor interceptor = interceptors[i];
            if (interceptor == null) continue;
            interceptor.onError(this.componentInstance, method, args, exception);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        Interceptor[] interceptors = this.getActiveInterceptorsForMethod(method);
        if (interceptors != null) {
            logger.info("===== [ PROXY ] : Before call / " + this.componentInstance.getClass().getSimpleName() + " " + method.getName());
            this.notifyInterceptorsBeforeCall(interceptors, method, args);
            Exception exception = null;
            Object result = null;
            try {
                result = MethodInvoker.invoke(this.componentInstance, method, args);
            }
            catch (Exception e) {
                exception = e;
            }
            if (exception != null) {
                logger.info("===== [ PROXY ] : Call error / " + this.componentInstance.getClass().getSimpleName() + " " + method.getName());
                this.notifyInterceptorsOnError(interceptors, method, args, exception);
                throw exception;
            }
            logger.info("===== [ PROXY ] : After call / " + this.componentInstance.getClass().getSimpleName() + " " + method.getName());
            this.notifyInterceptorsAfterCall(interceptors, method, args, result);
            return result;
        }
        Object result = MethodInvoker.invoke(this.componentInstance, method, args);
        return result;
    }
}

