/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.injector.impl;

import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Provider;
import org.nanoj.injector.Injector;
import org.nanoj.injector.InjectorException;
import org.nanoj.injector.aop.InterceptorProvider;
import org.nanoj.injector.impl.AnnotationUtil;
import org.nanoj.injector.impl.ComponentDefinition;
import org.nanoj.injector.tools.ClassTools;
import org.nanoj.util.ConsoleLoggerProvider;

public class InjectorImpl
implements Injector {
    private static final Logger logger = ConsoleLoggerProvider.getLogger(InjectorImpl.class, (Level)Level.INFO);
    private final String name;
    private final HashMap<String, ComponentDefinition<?>> componentsMap = new HashMap(128);
    private final HashMap<Class<?>, Class<?>> implementationClasses;
    private final String[] implementationConventions;
    private final HashMap<Class<?>, Provider<?>> implementationProviders;
    private final InterceptorProvider[] interceptorProviders;

    public InjectorImpl(String name, HashMap<Class<?>, Class<?>> implementationClasses, String[] implementationConventions, HashMap<Class<?>, Provider<?>> implementationProviders, InterceptorProvider[] interceptorProviders) {
        this.name = name;
        this.implementationClasses = implementationClasses;
        this.implementationConventions = implementationConventions;
        this.implementationProviders = implementationProviders;
        this.interceptorProviders = interceptorProviders;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InterceptorProvider[] getInterceptorProviders() {
        return this.interceptorProviders;
    }

    @Override
    public <T> T getInstance(Class<T> clazz) {
        T componentInstance = this.getComponentInstance(clazz);
        return componentInstance;
    }

    protected <T> T getComponentInstance(Class<T> componentClass) {
        Provider<T> provider;
        logger.info("getInstance(" + componentClass + ")");
        String sClassName = componentClass.getName();
        ComponentDefinition<Object> componentDefinition = this.componentsMap.get(sClassName);
        if (componentDefinition != null) {
            Object instance = componentDefinition.getInstance();
            return (T)instance;
        }
        Class<?> implementationClass = this.getImplementationClass(componentClass);
        if (implementationClass != null) {
            componentDefinition = new ComponentDefinition<T>(this, componentClass, implementationClass);
        }
        if ((provider = this.getProvider(componentClass)) != null) {
            componentDefinition = new ComponentDefinition<T>(this, componentClass, provider);
        }
        if ((implementationClass = this.getImplementationClassByConvention(componentClass)) != null) {
            componentDefinition = new ComponentDefinition<T>(this, componentClass, implementationClass);
        }
        if (null == componentDefinition) {
            if (ClassTools.isInterfaceOrAbstract(componentClass)) {
                throw new InjectorException("Cannot get implementation or provider for '" + componentClass.getName() + "'");
            }
            componentDefinition = new ComponentDefinition<T>(this, componentClass);
        }
        this.componentsMap.put(sClassName, componentDefinition);
        Object instance = componentDefinition.getInstance();
        return (T)instance;
    }

    protected boolean isMonoInstance(Class<?> cl) {
        boolean b = this.isMonoInstanceByAnnotation(cl);
        logger.info("isMonoInstance ( " + cl.getCanonicalName() + " ) : " + b);
        return b;
    }

    private Class<?> getImplementationClass(Class<?> interfaceClass) {
        return this.implementationClasses.get(interfaceClass);
    }

    private Class<?> getImplementationClassByConvention(Class<?> interfaceClass) {
        for (String pattern : this.implementationConventions) {
            String className = ClassTools.applyClassOnPattern(interfaceClass, pattern);
            ClassLoader classLoader = InjectorImpl.class.getClassLoader();
            Class<?> implementationClass = null;
            try {
                implementationClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                implementationClass = null;
            }
            if (implementationClass == null) continue;
            return implementationClass;
        }
        return null;
    }

    private <T> Provider<T> getProvider(Class<T> interfaceClass) {
        Provider<?> provider;
        Provider<?> typedProvider = provider = this.implementationProviders.get(interfaceClass);
        return typedProvider;
    }

    protected String getClassName(String sFullClassName) {
        if (sFullClassName != null) {
            String s = sFullClassName.trim();
            int i = s.lastIndexOf(46);
            if (i >= 0) {
                return s.substring(i + 1);
            }
            return s;
        }
        return null;
    }

    protected String getPackageName(String sFullClassName) {
        if (sFullClassName != null) {
            String s = sFullClassName.trim();
            int i = s.lastIndexOf(46);
            if (i >= 0) {
                return s.substring(0, i);
            }
            return "";
        }
        return null;
    }

    @Override
    public void printAllComponents(PrintStream out) {
        Collection<ComponentDefinition<?>> collection = this.componentsMap.values();
        for (ComponentDefinition<?> component : collection) {
            out.println(component.toString());
        }
    }

    protected boolean isMonoInstanceByInterface(Class<?> componentClass, Class<?> monoInstanceInterface) {
        if (null == componentClass) {
            throw new IllegalArgumentException("componentClass is null");
        }
        if (null == monoInstanceInterface) {
            throw new IllegalArgumentException("fieldName is null");
        }
        return monoInstanceInterface.isAssignableFrom(componentClass);
    }

    protected boolean isMonoInstanceByBooleanStaticField(Class<?> componentClass, String fieldName) {
        if (null == componentClass) {
            throw new IllegalArgumentException("componentClass is null");
        }
        if (null == fieldName) {
            throw new IllegalArgumentException("fieldName is null");
        }
        Field field = null;
        try {
            field = componentClass.getDeclaredField(fieldName);
        }
        catch (SecurityException e) {
            field = null;
        }
        catch (NoSuchFieldException e) {
            field = null;
        }
        if (field != null) {
            Class<?> type = field.getType();
            logger.info("SINGLETON found : type = " + type);
            if ("boolean".equals(type.getName())) {
                boolean fieldValue = false;
                try {
                    fieldValue = field.getBoolean(null);
                }
                catch (IllegalArgumentException e) {
                    fieldValue = false;
                }
                catch (IllegalAccessException e) {
                    fieldValue = false;
                }
                return fieldValue;
            }
        }
        return false;
    }

    protected boolean isMonoInstanceByAnnotation(Class<?> componentClass, Class<?> annotationClass) {
        Annotation[] annotations;
        if (null == componentClass) {
            throw new IllegalArgumentException("componentClass is null");
        }
        if (null == annotationClass) {
            throw new IllegalArgumentException("annotationClass is null");
        }
        for (Annotation a : annotations = componentClass.getDeclaredAnnotations()) {
            if (!annotationClass.equals(a.annotationType())) continue;
            return true;
        }
        return false;
    }

    protected boolean isMonoInstanceByAnnotation(Class<?> componentClass) {
        Annotation[] annotations;
        if (null == componentClass) {
            throw new IllegalArgumentException("componentClass is null");
        }
        for (Annotation a : annotations = componentClass.getDeclaredAnnotations()) {
            if (!AnnotationUtil.isSingleton(a)) continue;
            return true;
        }
        return false;
    }
}

