/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.injector.tools;

import java.lang.reflect.Modifier;

public class ClassTools {
    public static boolean isInterfaceOrAbstract(Class<?> clazz) {
        if (clazz.isInterface()) {
            return true;
        }
        int modifiers = clazz.getModifiers();
        return Modifier.isAbstract(modifiers);
    }

    public static boolean isAbstract(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return Modifier.isAbstract(modifiers);
    }

    private static String replaceVar(String s, String sVarName, String sVarValue) {
        String sNewString = s;
        int i = s.indexOf(sVarName);
        if (i >= 0) {
            int j = i + sVarName.length();
            String s1 = s.substring(0, i);
            String s2 = s.substring(j, s.length());
            sNewString = s1 + sVarValue + s2;
        }
        return sNewString;
    }

    public static String applyClassOnPattern(Class<?> clazz, String pattern) {
        String packageName = clazz.getPackage().getName();
        String className = clazz.getSimpleName();
        String s1 = pattern;
        if (pattern.contains("${package}")) {
            s1 = ClassTools.replaceVar(pattern, "${package}", packageName);
        } else if (pattern.contains("${package-")) {
            int n = ClassTools.getPackageLevel(pattern);
            String v = ClassTools.getPackageVar(pattern);
            for (int i = 0; i < n; ++i) {
                packageName = ClassTools.cutLastLevel(packageName);
            }
            if (v != null) {
                s1 = ClassTools.replaceVar(pattern, v, packageName);
            }
        }
        String s2 = ClassTools.replaceVar(s1, "${class}", className);
        if (s2.charAt(0) == '.') {
            return s2.substring(1);
        }
        return s2;
    }

    public static int getPackageLevel(String pattern) {
        StringBuffer sb = new StringBuffer();
        int i = pattern.indexOf("${package-");
        if (i >= 0) {
            int index = i + 10;
            char c = pattern.charAt(index);
            while (c >= '0' && c <= '9') {
                sb.append(c);
                c = pattern.charAt(++index);
            }
            int level = Integer.parseInt(sb.toString());
            return level;
        }
        return 0;
    }

    public static String getPackageVar(String pattern) {
        StringBuffer sb = new StringBuffer();
        int i = pattern.indexOf("${package");
        if (i >= 0) {
            int index = i;
            char c = pattern.charAt(index);
            while (c != '}') {
                sb.append(c);
                c = pattern.charAt(++index);
            }
            sb.append('}');
            return sb.toString();
        }
        return null;
    }

    public static String cutLastLevel(String packageName) {
        int i = packageName.length();
        if (i > 0) {
            --i;
            while (i >= 0 && packageName.charAt(i) != '.') {
                --i;
            }
            if (i >= 0 && packageName.charAt(i) == '.') {
                return packageName.substring(0, i);
            }
        }
        return "";
    }
}

