/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.injector.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import javax.inject.Provider;
import org.nanoj.injector.InjectorException;
import org.nanoj.injector.aop.InterceptorProvider;
import org.nanoj.injector.dynaproxy.GenericInvocationHandler;
import org.nanoj.injector.impl.AnnotationUtil;
import org.nanoj.injector.impl.InjectorImpl;
import org.nanoj.injector.tools.ClassTools;

class ComponentDefinition<T> {
    private static final Field[] VOID_FIELD_ARRAY = new Field[0];
    private InjectorImpl _container = null;
    private Class<T> _componentClass = null;
    private Class<? extends T> _implementationClass = null;
    private Provider<T> _implementationProvider = null;
    private boolean _bMonoInstance = false;
    private T _singleInstance = null;
    private Constructor<? extends T> _defaultConstructor = null;
    private Constructor<? extends T> _constructorWithDependencies = null;
    private Field[] _fieldsToBeInjected = null;

    private void init(InjectorImpl container) {
        if (container == null) {
            throw new IllegalArgumentException("Container parameter is null");
        }
        this._container = container;
        if (this._implementationClass != null) {
            Constructor<T> constructorToBeUsed = this.getConstructorToBeUsed(this._implementationClass);
            if (constructorToBeUsed.getParameterTypes().length == 0) {
                this._defaultConstructor = constructorToBeUsed;
            } else {
                this._constructorWithDependencies = constructorToBeUsed;
            }
            this._fieldsToBeInjected = this.getFieldsToBeInjected(this._implementationClass);
            this._bMonoInstance = this._container.isMonoInstance(this._implementationClass);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ComponentDefinition(InjectorImpl container, Class<T> componentClass, Class<? extends T> implementationClass) {
        if (null == componentClass) {
            throw new IllegalArgumentException("Component class parameter is null");
        }
        this._componentClass = componentClass;
        if (ClassTools.isInterfaceOrAbstract(componentClass)) {
            if (implementationClass == null) throw new IllegalArgumentException("Implementation/concrete class parameter is null");
            this._implementationClass = implementationClass;
        } else {
            this._implementationClass = componentClass;
        }
        this._implementationProvider = null;
        this.init(container);
    }

    public ComponentDefinition(InjectorImpl container, Class<T> componentClass, Provider<T> provider) {
        if (null == componentClass) {
            throw new IllegalArgumentException("Component class parameter is null");
        }
        if (null == provider) {
            throw new IllegalArgumentException("Provider parameter is null");
        }
        this._componentClass = componentClass;
        this._implementationClass = null;
        this._implementationProvider = provider;
        this.init(container);
    }

    public ComponentDefinition(InjectorImpl container, Class<T> componentClass) {
        if (null == componentClass) {
            throw new IllegalArgumentException("Component class parameter is null");
        }
        if (ClassTools.isInterfaceOrAbstract(componentClass)) {
            throw new IllegalArgumentException("Cannot create component for interface/abstract class without implementation");
        }
        this._componentClass = componentClass;
        this._implementationClass = componentClass;
        this._implementationProvider = null;
        this.init(container);
    }

    private final Constructor<? extends T> convert(Constructor<?> constructor1) {
        Constructor<?> constructor2 = constructor1;
        return constructor2;
    }

    private final Constructor<? extends T> getConstructorToBeUsed(Class<? extends T> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            throw new IllegalStateException("No accessible constructor for class '" + clazz.getCanonicalName() + "'");
        }
        if (constructors.length == 1) {
            return this.convert(constructors[0]);
        }
        Constructor<T> defaultConstructor = null;
        Constructor<T> lastConstructorWithInject = null;
        int injectCount = 0;
        for (Constructor<?> constructor : constructors) {
            if (AnnotationUtil.hasInjectAnnotation(constructor)) {
                lastConstructorWithInject = this.convert(constructor);
                ++injectCount;
            }
            if (constructor.getParameterTypes().length != 0) continue;
            defaultConstructor = this.convert(constructor);
        }
        if (injectCount == 1) {
            return lastConstructorWithInject;
        }
        if (injectCount == 0) {
            if (defaultConstructor != null) {
                return defaultConstructor;
            }
            throw new IllegalStateException("Class '" + clazz.getCanonicalName() + "' : " + constructors.length + " constructors without default constructor, @Inject is required ");
        }
        if (injectCount > 1) {
            throw new IllegalStateException("Class '" + clazz.getCanonicalName() + "' : " + injectCount + " constructors with @Inject, only one expected");
        }
        throw new IllegalStateException("Unexpected error while serching the constructor for class '" + clazz.getCanonicalName() + "'");
    }

    private Field[] getFieldsToBeInjected(Class<? extends T> clazz) {
        Field[] declaredFields;
        LinkedList<Field> fieldsToBeInjected = new LinkedList<Field>();
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (!AnnotationUtil.hasInjectAnnotation(field)) continue;
            fieldsToBeInjected.add(field);
        }
        if (fieldsToBeInjected.size() > 0) {
            return fieldsToBeInjected.toArray(VOID_FIELD_ARRAY);
        }
        return null;
    }

    public Class<?> getComponentClass() {
        return this._componentClass;
    }

    public Class<?> getImplementationClass() {
        return this._implementationClass;
    }

    public T getInstance() {
        if (this._bMonoInstance) {
            if (this._singleInstance == null) {
                this._singleInstance = this.createInstance();
            }
            return this._singleInstance;
        }
        return this.createInstance();
    }

    private T createInstance() {
        InterceptorProvider[] interceptorProviders;
        T newInstance = this.createBasicInstance();
        if (this._componentClass.isInterface() && (interceptorProviders = this._container.getInterceptorProviders()) != null) {
            Object proxy;
            GenericInvocationHandler invocationHandler = new GenericInvocationHandler(newInstance, interceptorProviders);
            Class[] interfaces = new Class[]{this._componentClass};
            Object proxyInstance = proxy = Proxy.newProxyInstance(this._componentClass.getClassLoader(), interfaces, (InvocationHandler)invocationHandler);
            return (T)proxyInstance;
        }
        return newInstance;
    }

    private T createBasicInstance() {
        Object newInstance = null;
        if (this._implementationProvider != null) {
            newInstance = this._implementationProvider.get();
        } else if (this._defaultConstructor != null) {
            newInstance = this.createWithDefaultConstructor(this._implementationClass);
        } else if (this._constructorWithDependencies != null) {
            newInstance = this.createWithDependencies(this._implementationClass);
        } else {
            throw new InjectorException("Cannot create instance for class " + this._implementationClass + " : no constructor ");
        }
        if (this._fieldsToBeInjected != null) {
            for (Field field : this._fieldsToBeInjected) {
                this.injectField(newInstance, field);
            }
        }
        return (T)newInstance;
    }

    private final T createWithDefaultConstructor(Class<? extends T> componentClass) {
        T obj = null;
        try {
            obj = componentClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new InjectorException("Cannot create instance for class " + componentClass, e);
        }
        catch (IllegalAccessException e) {
            throw new InjectorException("Cannot create instance for class " + componentClass, e);
        }
        return obj;
    }

    private final T createWithDependencies(Class<? extends T> componentClass) {
        Constructor<T> constructor = this._constructorWithDependencies;
        Class<?>[] paramTypes = constructor.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            params[i] = this._container.getComponentInstance(paramTypes[i]);
        }
        T obj = null;
        try {
            obj = constructor.newInstance(params);
        }
        catch (IllegalArgumentException e) {
            throw new InjectorException("Cannot create instance for class " + componentClass, e);
        }
        catch (InstantiationException e) {
            throw new InjectorException("Cannot create instance for class " + componentClass, e);
        }
        catch (IllegalAccessException e) {
            throw new InjectorException("Cannot create instance for class " + componentClass, e);
        }
        catch (InvocationTargetException e) {
            throw new InjectorException("Cannot create instance for class " + componentClass, e);
        }
        return obj;
    }

    private final void injectField(Object componentInstance, Field field) {
        Class<?> fieldType = field.getType();
        Object instanceToBeInjected = this._container.getComponentInstance(fieldType);
        field.setAccessible(true);
        try {
            field.set(componentInstance, instanceToBeInjected);
        }
        catch (IllegalArgumentException e) {
            throw new InjectorException("Cannot inject field '" + field.getName() + "' (IllegalArgumentException)", e);
        }
        catch (IllegalAccessException e) {
            throw new InjectorException("Cannot inject field '" + field.getName() + "' (IllegalAccessException)", e);
        }
    }

    public String toString() {
        String sSingleton = "singleton = " + (this._bMonoInstance ? "true" : "false");
        String sImplem = "";
        if (this._implementationProvider != null) {
            sImplem = "implementation provider = '" + this._implementationProvider.getClass().getCanonicalName() + "'";
        } else if (this._implementationClass != null) {
            sImplem = "implementation class = '" + this._implementationClass.getCanonicalName() + "'";
        }
        return this._componentClass.getCanonicalName() + " : " + sImplem + ", " + sSingleton;
    }
}

