/**
 *  Copyright (C) 2013-2016 Laurent GUERIN - NanoJ project org. ( http://www.nanoj.org/ )
 *
 *  Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *          http://www.gnu.org/licenses/lgpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.nanoj.web.tinymvc ;

/**
 * Exception triggered when the required action is not found
 * 
 * @author Laurent Guerin
 *
 */
public class TinyMvcActionNotFoundException extends Exception {

	private static final long serialVersionUID = 1L;
	
	private final String actionName ;
	
    //-----------------------------------------------------------------------------
    /**
     * Constructor
     * 
     * @param actionName
     */
    public TinyMvcActionNotFoundException(String actionName) {
        super(actionName);
        this.actionName = actionName;
    }

    //-----------------------------------------------------------------------------
    /**
     * Constructor
     * 
     * @param actionName
     * @param cause
     */
    public TinyMvcActionNotFoundException(String actionName, Throwable cause) {
        super(actionName, cause);
        this.actionName = actionName;
    }

    /**
     * Returns the action name
     * @return
     */
    public String getActionName() {
    	return actionName ;
    }
}
