/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.web.tinymvc;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nanoj.util.beanmapper.BeanMapper;
import org.nanoj.web.tinymvc.Action;
import org.nanoj.web.tinymvc.TinyMvcException;
import org.nanoj.web.tinymvc.env.FieldValuesManager;
import org.nanoj.web.tinymvc.env.InputParameter;

public abstract class GenericAction
implements Action {
    @Override
    public void beforeAction(String method, HttpServletRequest request, HttpServletResponse response) {
    }

    @Override
    public void afterAction(String method, HttpServletRequest request, HttpServletResponse response) {
    }

    protected Map<String, String> getParametersMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            String value = request.getParameter(name);
            map.put(name, value);
        }
        return map;
    }

    protected void populateBeanFromParameters(Object bean, HttpServletRequest request) {
        Map<String, String> parameters = this.getParametersMap(request);
        BeanMapper mapper = new BeanMapper();
        mapper.mapToBean(parameters, bean);
    }

    protected <T> InputParameter<T> getInputParameter(HttpServletRequest request, String paramName, Class<T> clazz) {
        String paramValue = request.getParameter(paramName);
        if (paramValue != null) {
            BeanMapper mapper = new BeanMapper();
            Object value = mapper.getTypedValue(clazz, paramValue);
            return new InputParameter<Object>(paramName, value);
        }
        throw new RuntimeException("No '" + paramName + "' parameter in the request");
    }

    protected void setFieldValue(HttpServletRequest request, String fieldName, String fieldValue) {
        FieldValuesManager.getInstance().setFieldValue(request, fieldName, fieldValue);
    }

    protected String getParamAsString(HttpServletRequest request, String paramName) {
        return this.getParamAsString(request, paramName, null);
    }

    protected String getParamAsString(HttpServletRequest request, String paramName, String defaultValue) {
        String paramValue = request.getParameter(paramName);
        if (null == paramValue) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new TinyMvcException("Param '" + paramName + "' required");
        }
        return paramValue;
    }

    protected boolean getParamAsBoolean(HttpServletRequest request, String paramName) {
        return this.getParamAsBoolean(request, paramName, null);
    }

    protected boolean getParamAsBoolean(HttpServletRequest request, String paramName, Boolean defaultValue) {
        String paramValue = request.getParameter(paramName);
        if (null == paramValue) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new TinyMvcException("Param '" + paramName + "' required");
        }
        return paramValue.trim().equalsIgnoreCase("true");
    }

    protected double getParamAsDouble(HttpServletRequest request, String paramName) {
        return this.getParamAsDouble(request, paramName, null);
    }

    protected double getParamAsDouble(HttpServletRequest request, String paramName, Double defaultValue) {
        return (Double)this.getParamAsNumber(request, paramName, Double.TYPE, defaultValue);
    }

    protected float getParamAsFloat(HttpServletRequest request, String paramName) {
        return this.getParamAsFloat(request, paramName, null);
    }

    protected float getParamAsFloat(HttpServletRequest request, String paramName, Float defaultValue) {
        return ((Float)this.getParamAsNumber(request, paramName, Float.TYPE, defaultValue)).floatValue();
    }

    protected int getParamAsInt(HttpServletRequest request, String paramName) {
        return this.getParamAsInt(request, paramName, null);
    }

    protected int getParamAsInt(HttpServletRequest request, String paramName, Integer defaultValue) {
        return (Integer)this.getParamAsNumber(request, paramName, Integer.TYPE, defaultValue);
    }

    private boolean isNullOrVoid(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().length() == 0;
    }

    private Number getParamAsNumber(HttpServletRequest request, String paramName, Class<? extends Number> type, Number defaultValue) {
        String paramValue = request.getParameter(paramName);
        if (this.isNullOrVoid(paramValue)) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new TinyMvcException("Param '" + paramName + "' required (no default value)");
        }
        try {
            if (type.equals(Double.TYPE)) {
                return new Double(Double.parseDouble(paramValue));
            }
            if (type.equals(Float.TYPE)) {
                return new Float(Float.parseFloat(paramValue));
            }
            if (type.equals(Long.TYPE)) {
                return new Long(Long.parseLong(paramValue));
            }
            if (type.equals(Integer.TYPE)) {
                return new Integer(Integer.parseInt(paramValue));
            }
            throw new TinyMvcException("Cannot convert param '" + paramName + "' (invalid type " + type.getSimpleName() + ")");
        }
        catch (NumberFormatException e) {
            throw new TinyMvcException("Param '" + paramName + "' : invalid numeric value '" + paramValue + "' (" + type.getSimpleName() + ")");
        }
    }
}

