/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.web.tinymvc.env;

import javax.servlet.http.HttpServletRequest;
import org.nanoj.util.StrUtil;
import org.nanoj.web.tinymvc.env.ActionView;

public class ActionInfo {
    private final String requestURL;
    private final String requestURI;
    private final String originalName;
    private final String name;
    private final String method;
    private String controllerClass = null;
    private String controllerMethod = null;
    private String controllerResult = null;
    private ActionView actionView = null;

    public ActionInfo(HttpServletRequest request, String originalName, String method) {
        this.requestURL = this.removeEndingMethodName(request.getRequestURL().toString(), method);
        this.requestURI = this.removeEndingMethodName(request.getRequestURI(), method);
        this.originalName = originalName;
        this.name = StrUtil.firstCharLowerCase((String)originalName);
        this.method = method;
    }

    private String removeEndingMethodName(String s, String method) {
        if (!StrUtil.nullOrVoid((String)method)) {
            return StrUtil.removeEnd((String)s, (String)("." + method));
        }
        return s;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getName() {
        return this.name;
    }

    public String getMethod() {
        return this.method;
    }

    public void setProcessingResult(String className, String methodCalled, String result) {
        this.controllerClass = className;
        this.controllerMethod = methodCalled;
        this.controllerResult = result;
    }

    public String getControllerClass() {
        return this.controllerClass;
    }

    public String getControllerMethod() {
        return this.controllerMethod;
    }

    public String getControllerResult() {
        return this.controllerResult;
    }

    public void setActionView(ActionView actionView) {
        this.actionView = actionView;
    }

    public String getViewName() {
        return this.actionView != null ? this.actionView.getViewName() : null;
    }

    public String getViewPath() {
        return this.actionView != null ? this.actionView.getViewPath() : null;
    }

    public String getViewPageName() {
        return this.actionView != null ? this.actionView.getPageName() : null;
    }

    public String getViewPagePath() {
        return this.actionView != null ? this.actionView.getPagePath() : null;
    }

    public String getViewLayoutName() {
        return this.actionView != null ? this.actionView.getLayoutName() : null;
    }

    public String getViewLayoutPath() {
        return this.actionView != null ? this.actionView.getLayoutPath() : null;
    }

    public String toString() {
        return "[  name=" + this.name + ", originalName=" + this.originalName + ", method=" + this.method + ", controllerClass=" + this.controllerClass + ", controllerMethod=" + this.controllerMethod + ", controllerResult=" + this.controllerResult + ", viewLayoutName=" + this.getViewLayoutName() + ", viewPageName=" + this.getViewPageName() + ", viewPageName=" + this.getViewName() + "]";
    }
}

