/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.web.tinymvc.env;

import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.nanoj.web.tinymvc.env.FieldValues;

public class FieldValuesManager {
    private static final String FIELD_VALUE = "fieldvalue";
    private static final FieldValuesManager singleInstance = new FieldValuesManager();

    public static final FieldValuesManager getInstance() {
        return singleInstance;
    }

    private FieldValuesManager() {
    }

    public void setFieldValuesFromParameters(HttpServletRequest request) {
        FieldValues<String, String> fieldValues = this.getFieldValues(request);
        Map parameters = request.getParameterMap();
        Set paramNames = parameters.keySet();
        for (String paramName : paramNames) {
            String[] v = (String[])parameters.get(paramName);
            if (v == null) continue;
            String paramValue = v[0];
            if (null == paramValue) {
                paramValue = "";
            }
            fieldValues.setFieldValue(paramName, paramValue);
        }
    }

    public void setFieldValue(HttpServletRequest request, String fieldName, String fieldValue) {
        FieldValues<String, String> fieldValues = this.getFieldValues(request);
        fieldValues.setFieldValue(fieldName, fieldValue);
    }

    private FieldValues<String, String> getFieldValues(HttpServletRequest request) {
        FieldValues fieldValues = null;
        Object o = null;
        o = request.getAttribute(FIELD_VALUE);
        if (o != null && o instanceof FieldValues) {
            fieldValues = (FieldValues)o;
        }
        if (null == fieldValues) {
            fieldValues = new FieldValues();
            request.setAttribute(FIELD_VALUE, fieldValues);
        }
        return fieldValues;
    }
}

