/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.web.tinymvc.processor;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nanoj.web.tinymvc.TinyMvcActionNotFoundException;
import org.nanoj.web.tinymvc.config.Configuration;
import org.nanoj.web.tinymvc.env.ActionInfo;
import org.nanoj.web.tinymvc.processor.ActionProcessor;
import org.nanoj.web.tinymvc.util.ConsoleLogger;

public class ActionFilter
implements Filter {
    private final Configuration configuration;
    private final ActionProcessor actionProcessor;
    private final ConsoleLogger logger = ConsoleLogger.getLogger(ActionFilter.class);

    public ActionFilter(Configuration configuration) {
        this.logger.trace("constructor()");
        this.configuration = configuration;
        this.actionProcessor = new ActionProcessor(configuration);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.logger.info("NanoJ filer initialization");
        this.logger.info(" . actions package        = '" + this.configuration.getActionsPackage() + "'");
        this.logger.info(" . default action         = '" + this.configuration.getDefaultAction() + "'");
        this.logger.info(" . actions provider class = '" + this.configuration.getActionsProviderClassName() + "'");
        this.logger.info(" . views folder           = '" + this.configuration.getViewsFolder() + "'");
        this.logger.info(" . views suffix           = '" + this.configuration.getViewsSuffix() + "'");
        this.logger.info(" . layouts folder         = '" + this.configuration.getLayoutsFolder() + "'");
        this.logger.info(" . layouts suffix         = '" + this.configuration.getLayoutsSuffix() + "'");
        this.logger.info(" . views type             = '" + (Object)((Object)this.configuration.getViewsType()) + "'");
    }

    public void destroy() {
        this.logger.trace("destroy()");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        this.logger.trace("doFilter() : URI = '" + httpServletRequest.getRequestURI() + "', pathInfo = '" + httpServletRequest.getPathInfo() + "'");
        try {
            ActionInfo actionInfo = this.actionProcessor.processAction(httpServletRequest, httpServletResponse);
            this.logger.trace("action name '" + actionInfo.getName() + "' ");
            this.logger.trace(" controller --> " + actionInfo.getControllerClass() + "." + actionInfo.getControllerMethod() + "() ");
            this.logger.trace(" result     --> '" + actionInfo.getControllerResult() + "' ");
            this.logger.trace(" view name  --> '" + actionInfo.getViewName() + "' ( path = '" + actionInfo.getViewPath() + "' )");
            this.logger.trace(" view page   '" + actionInfo.getViewPageName() + "' ( path = '" + actionInfo.getViewPagePath() + "' )");
            this.logger.trace(" view layout '" + actionInfo.getViewLayoutName() + "' ( path = '" + actionInfo.getViewLayoutPath() + "' )");
        }
        catch (TinyMvcActionNotFoundException e) {
            this.logger.trace("action not found for '" + httpServletRequest.getRequestURI() + "' => chain...");
            chain.doFilter(servletRequest, servletResponse);
        }
    }
}

