/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.web.tinymvc.processor;

import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.nanoj.util.ConsoleLoggerProvider;
import org.nanoj.util.StrUtil;
import org.nanoj.web.tinymvc.TinyMvcException;
import org.nanoj.web.tinymvc.env.ActionInfo;

public class ActionParser {
    private static final Logger LOGGER = ConsoleLoggerProvider.getLogger(ActionParser.class);
    private final String defaultActionName;

    public ActionParser(String defaultActionName) {
        this.defaultActionName = defaultActionName;
    }

    public ActionInfo parseActionURI(HttpServletRequest request) {
        String s;
        String requestURI = request.getRequestURI();
        LOGGER.info("request.getRequestURI() : '" + requestURI + "'");
        String[] parts = StrUtil.split((String)requestURI, (char)'/');
        String actionString = "";
        if (parts.length > 0) {
            actionString = parts[parts.length - 1];
        }
        LOGGER.info("actionString : '" + actionString + "'");
        String actionName = null;
        String methodName = null;
        if (actionString.length() > 0) {
            int pointPosition = actionString.indexOf(46);
            if (pointPosition == 0) {
                throw new TinyMvcException("Invalid action name (starts with '.')");
            }
            if (pointPosition == actionString.length() - 1) {
                throw new TinyMvcException("Invalid action name (ends with '.')");
            }
            if (pointPosition > 0) {
                actionName = actionString.substring(0, pointPosition);
                methodName = actionString.substring(pointPosition + 1, actionString.length());
            } else {
                actionName = actionString;
                methodName = null;
            }
        } else {
            actionName = "";
            methodName = null;
        }
        if (StrUtil.nullOrVoid((String)actionName)) {
            if (this.defaultActionName != null) {
                actionName = this.defaultActionName;
            } else {
                throw new TinyMvcException("No action name and no default action");
            }
        }
        if (methodName == null && (s = request.getParameter("action.method")) != null) {
            methodName = s.trim();
        }
        return new ActionInfo(request, actionName, methodName);
    }
}

