/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.web.tinymvc.processor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nanoj.util.StrUtil;
import org.nanoj.web.tinymvc.Action;
import org.nanoj.web.tinymvc.TinyMvcActionNotFoundException;
import org.nanoj.web.tinymvc.TinyMvcException;
import org.nanoj.web.tinymvc.config.Configuration;
import org.nanoj.web.tinymvc.env.ActionInfo;
import org.nanoj.web.tinymvc.env.FieldValuesManager;
import org.nanoj.web.tinymvc.processor.ActionParser;
import org.nanoj.web.tinymvc.processor.ActionViewRenderer;
import org.nanoj.web.tinymvc.provider.ActionProvider;
import org.nanoj.web.tinymvc.provider.InstanceProvider;
import org.nanoj.web.tinymvc.provider.StandardActionProvider;
import org.nanoj.web.tinymvc.util.ConsoleLogger;

public class ActionProcessor {
    private final ConsoleLogger logger = ConsoleLogger.getLogger(ActionProcessor.class);
    private final ActionParser actionParser;
    private final ActionProvider actionProvider;
    private final ActionViewRenderer actionViewRenderer;
    private final FieldValuesManager fieldValuesManager;

    private void trace(String msg) {
    }

    public ActionProcessor(Configuration configuration) {
        this.actionParser = new ActionParser(configuration.getDefaultAction());
        this.actionViewRenderer = new ActionViewRenderer(configuration);
        this.fieldValuesManager = FieldValuesManager.getInstance();
        String actionProviderClassName = configuration.getActionsProviderClassName();
        String actionsPackage = configuration.getActionsPackage();
        if (actionProviderClassName != null) {
            this.actionProvider = InstanceProvider.createInstance(actionProviderClassName, ActionProvider.class);
            this.trace("action provider initialized ( class = " + actionProviderClassName + " )");
        } else if (actionsPackage != null) {
            this.actionProvider = new StandardActionProvider(actionsPackage);
            this.trace("action provider initialized ( class = " + StandardActionProvider.class.getCanonicalName() + " )");
        } else {
            throw new TinyMvcException("Cannot get action : no action provider class and no actions package ");
        }
    }

    public ActionInfo processAction(HttpServletRequest request, HttpServletResponse response) throws TinyMvcActionNotFoundException {
        ActionInfo actionInfo = this.actionParser.parseActionURI(request);
        this.trace("--- ActionInfo : " + actionInfo);
        String actionResult = this.executeAction(actionInfo, request, response);
        if (actionResult == null) {
            throw new TinyMvcException("Action result is null (action " + actionInfo.getControllerClass() + ")");
        }
        if (actionResult.trim().length() == 0) {
            throw new TinyMvcException("Action result is void (action " + actionInfo.getControllerClass() + ")");
        }
        try {
            this.actionViewRenderer.render(actionResult, actionInfo, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("cannot render action '" + actionInfo.getName() + "' --> " + actionInfo.getControllerClass() + "." + actionInfo.getMethod() + "()" + " --> result = '" + actionResult + "'");
            this.logger.error(" . result      = '" + actionInfo.getControllerResult() + "'");
            this.logger.error(" . view        = '" + actionInfo.getViewName() + "'");
            this.logger.error(" . view layout = '" + actionInfo.getViewLayoutName() + "'");
            this.logger.error(" . view page   = '" + actionInfo.getViewPageName() + "'");
        }
        return actionInfo;
    }

    private String getMethodToCall(ActionInfo actionInfo) {
        if (StrUtil.nullOrVoid((String)actionInfo.getMethod())) {
            return "process";
        }
        return actionInfo.getMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeAction(ActionInfo actionInfo, HttpServletRequest request, HttpServletResponse response) throws TinyMvcActionNotFoundException {
        Action action = this.getAction(actionInfo);
        request.setAttribute("METHOD", (Object)"action.method");
        this.fieldValuesManager.setFieldValuesFromParameters(request);
        String actionResult = null;
        String methodToCall = this.getMethodToCall(actionInfo);
        try {
            action.beforeAction(methodToCall, request, response);
            actionResult = actionInfo.getMethod() != null ? this.executeSpecificMethod(action, methodToCall, request, response) : action.process(request, response);
        }
        finally {
            action.afterAction(methodToCall, request, response);
        }
        actionInfo.setProcessingResult(action.getClass().getSimpleName(), methodToCall, actionResult);
        this.trace("action result = '" + actionResult + "'");
        return actionResult;
    }

    private Action getAction(ActionInfo actionInfo) throws TinyMvcActionNotFoundException {
        Action action;
        this.trace("getAction('" + actionInfo.getName() + "')");
        try {
            action = this.actionProvider.getAction(actionInfo.getName());
        }
        catch (TinyMvcException e) {
            throw new TinyMvcActionNotFoundException(actionInfo.getName(), e);
        }
        if (null == action) {
            throw new TinyMvcActionNotFoundException(actionInfo.getName());
        }
        return action;
    }

    private String executeSpecificMethod(Action action, String methodName, HttpServletRequest request, HttpServletResponse response) {
        Class<?> clazz = action.getClass();
        String actionClassName = clazz.getSimpleName();
        Class[] argTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
        String errorMsg = "Cannot get method '" + methodName + "' in action class '" + actionClassName + "'";
        Method method = null;
        try {
            method = clazz.getMethod(methodName, argTypes);
        }
        catch (SecurityException e) {
            throw new TinyMvcException(errorMsg + " (SecurityException)", e);
        }
        catch (NoSuchMethodException e) {
            throw new TinyMvcException(errorMsg + " (NoSuchMethodException)", e);
        }
        Object[] arguments = new Object[]{request, response};
        String invokeErrorMsg = "Cannot execute method '" + actionClassName + "." + methodName + "'";
        Object result = null;
        try {
            result = method.invoke((Object)action, arguments);
        }
        catch (IllegalArgumentException e) {
            throw new TinyMvcException(invokeErrorMsg + " (IllegalArgumentException)", e);
        }
        catch (IllegalAccessException e) {
            throw new TinyMvcException(invokeErrorMsg + " (IllegalAccessException)", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                throw new TinyMvcException(invokeErrorMsg, cause);
            }
            if (e.getTargetException() != null) {
                throw new TinyMvcException(invokeErrorMsg, e.getTargetException());
            }
            throw new TinyMvcException(invokeErrorMsg, e);
        }
        if (result instanceof String) {
            return (String)result;
        }
        throw new TinyMvcException("The method '" + methodName + "' returned object is not a String");
    }
}

