/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.web.tinymvc.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nanoj.util.StrUtil;
import org.nanoj.web.tinymvc.TinyMvcException;
import org.nanoj.web.tinymvc.config.Configuration;
import org.nanoj.web.tinymvc.config.ViewsType;
import org.nanoj.web.tinymvc.env.ActionInfo;
import org.nanoj.web.tinymvc.env.ActionView;
import org.nanoj.web.tinymvc.processor.ThymeleafUtil;
import org.nanoj.web.tinymvc.util.ConsoleLogger;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.ServletContextTemplateResolver;

public class ActionViewRenderer {
    private final ConsoleLogger logger = ConsoleLogger.getLogger(ActionViewRenderer.class);
    private final Configuration configuration;

    public ActionViewRenderer(Configuration configuration) {
        this.configuration = configuration;
    }

    public ActionView render(String actionResultString, ActionInfo actionInfo, HttpServletRequest request, HttpServletResponse response) {
        ActionView actionView = new ActionView(actionResultString, this.configuration);
        actionInfo.setActionView(actionView);
        request.setAttribute("action", (Object)actionInfo);
        if (this.configuration.getViewsType() == ViewsType.THYMELEAF) {
            this.logger.trace("render with Thymeleaf...");
            this.renderWithThymeleaf(actionInfo, actionView, request, response);
        } else {
            this.logger.trace("render with JSP...");
            this.renderWithJSP(actionInfo, actionView, request, response);
        }
        return actionView;
    }

    private void renderWithJSP(ActionInfo actionInfo, ActionView actionView, HttpServletRequest request, HttpServletResponse response) {
        String targetPage = actionView.getViewPath();
        if (StrUtil.nullOrVoid((String)targetPage)) {
            throw new TinyMvcException("No target page for action '" + actionInfo.getName() + "'");
        }
        ServletContext servletContext = request.getServletContext();
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(targetPage);
        try {
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new TinyMvcException("Cannot render JSP (getRequestDispatcher : ServletException)", e);
        }
        catch (IOException e) {
            throw new TinyMvcException("Cannot render JSP (getRequestDispatcher : IOException)", e);
        }
    }

    private void renderWithThymeleaf(ActionInfo actionInfo, ActionView actionView, HttpServletRequest request, HttpServletResponse response) {
        PrintWriter responseWriter;
        ServletContextTemplateResolver templateResolver = new ServletContextTemplateResolver();
        templateResolver.setTemplateMode("XHTML");
        templateResolver.setCacheTTLMs(Long.valueOf(3600000L));
        templateResolver.setCharacterEncoding("utf-8");
        TemplateEngine templateEngine = new TemplateEngine();
        String thymeleafTemplate = "?";
        if (actionView.hasLayout()) {
            thymeleafTemplate = actionView.getLayoutName();
            this.logger.trace("Thymeleaf : 2 TemplateResolvers ( view + layout ) ");
            HashSet<ServletContextTemplateResolver> templateResolvers = new HashSet<ServletContextTemplateResolver>();
            templateResolvers.add(ThymeleafUtil.getViewTemplateResolver(this.configuration));
            templateResolvers.add(ThymeleafUtil.getLayoutTemplateResolver(this.configuration));
            templateEngine.setTemplateResolvers(templateResolvers);
        } else {
            thymeleafTemplate = actionView.getPageName();
            this.logger.trace("Thymeleaf : only 'view' TemplateResolver ");
            templateEngine.setTemplateResolver((ITemplateResolver)ThymeleafUtil.getViewTemplateResolver(this.configuration));
        }
        this.logger.trace("Thymeleaf template : '" + thymeleafTemplate + "'");
        try {
            responseWriter = response.getWriter();
        }
        catch (IOException e) {
            throw new TinyMvcException("Cannot get response writer (IOException)", e);
        }
        WebContext webContext = new WebContext(request, response, request.getServletContext(), request.getLocale());
        templateEngine.process(thymeleafTemplate, (IContext)webContext, (Writer)responseWriter);
    }
}

