/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.web.tinymvc.processor;

import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.nanoj.util.ConsoleLoggerProvider;
import org.nanoj.web.tinymvc.config.Configuration;
import org.nanoj.web.tinymvc.config.ConfigurationLoader;
import org.nanoj.web.tinymvc.processor.ActionFilter;
import org.nanoj.web.tinymvc.util.ConsoleLogger;

@WebListener
public class WebAppContextListener
implements ServletContextListener {
    private ConsoleLogger logger = ConsoleLogger.getLogger(WebAppContextListener.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.logger.info("NanoJ initialization");
        ConsoleLoggerProvider.setGlobalLevelThreshold((Level)Level.OFF);
        ServletContext servletContext = servletContextEvent.getServletContext();
        Configuration configuration = this.loadConfiguration(servletContext);
        ConsoleLogger.setGlobalLevel(900);
        this.registerActionFilter(servletContext, configuration);
    }

    private Configuration loadConfiguration(ServletContext servletContext) {
        this.logger.trace("loadConfiguration()");
        ConfigurationLoader configurationLoader = new ConfigurationLoader();
        Configuration configuration = configurationLoader.loadConfiguration();
        return configuration;
    }

    private void registerActionFilter(ServletContext servletContext, Configuration configuration) {
        this.logger.trace("registerActionFilter()");
        ActionFilter actionFilter = new ActionFilter(configuration);
        this.logger.trace("ActionFilter created.");
        FilterRegistration.Dynamic dynamicFilterRegistration = servletContext.addFilter("zzzNanoJ", (Filter)actionFilter);
        this.logger.trace("ActionFilter registered.");
        dynamicFilterRegistration.addMappingForUrlPatterns(null, true, new String[]{configuration.getActionsPattern()});
        this.logger.trace("ActionFilter mapping added (pattern = " + configuration.getActionsPattern() + ")");
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.logger.trace("contextDestroyed() : Web application stopped");
    }
}

