/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.web.tinymvc.provider;

import org.nanoj.injector.Injector;
import org.nanoj.injector.InjectorFactory;
import org.nanoj.web.tinymvc.TinyMvcException;

public class InstanceProvider {
    private static final Injector injector = InjectorFactory.createInjector((String)"tiny-mvc-injector");

    private static final Class<?> loadClass(String className) {
        if (className != null) {
            ClassLoader classLoader = InstanceProvider.class.getClassLoader();
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new TinyMvcException("Cannot load class '" + className + "' (class not found)");
            }
            return clazz;
        }
        throw new IllegalArgumentException("Class name is null");
    }

    public static final <T> T createInstance(String className, Class<T> superClass) {
        if (null == superClass) {
            throw new IllegalArgumentException("Super class is null");
        }
        Class<?> clazz = InstanceProvider.loadClass(className);
        return InstanceProvider.createInstance(clazz, superClass);
    }

    private static final <T> T createInstance(Class<?> clazz, Class<T> superClass) {
        if (superClass.isAssignableFrom(clazz)) {
            Object instance = InstanceProvider.createInstance(clazz);
            return (T)instance;
        }
        throw new TinyMvcException("Class '" + clazz.getCanonicalName() + "' doesn't extend/implement '" + superClass.getCanonicalName() + "'");
    }

    public static final <T> T createInstance(Class<T> clazz) {
        return (T)injector.getInstance(clazz);
    }
}

