/**
 *  Copyright (C) 2013-2016 Laurent GUERIN - NanoJ project org. ( http://www.nanoj.org/ )
 *
 *  Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *          http://www.gnu.org/licenses/lgpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.nanoj.web.tinymvc.provider ;

import java.util.Map;

import org.nanoj.web.tinymvc.Action;
import org.nanoj.web.tinymvc.TinyMvcException;

/**
 * Specific action provider based on a 'Map' : <br>
 * Just get the action class from the map using the given action name as the key <br>
 * . key   : action name <br>
 * . value : action implementation <br>
 * <br>
 * This action provider implementation can be used directly by the application <br>
 * 
 * @author Laurent Guerin
 *
 */
public class SpecificActionProvider implements ActionProvider {

	/**
	 * 
	 */
	private final Map<String, Class<? extends Action> > map ;

	/**
	 * Constructor
	 * @param map
	 */
	public SpecificActionProvider( Map<String, Class<? extends Action>> map) {
		super();
		if ( map != null ) {
			this.map = map;
		}
		else {
			throw new IllegalArgumentException("Map argument is null" );
		}
	}


	@Override
	public final Action getAction(String actionConventionalName ) {
		
		if ( null == actionConventionalName ) {
			throw new IllegalArgumentException("Action name is null" );
		}
		
		Class<? extends Action > actionClass = map.get( actionConventionalName ) ;
		if ( actionClass != null ) {
			return InstanceProvider.createInstance(actionClass) ;
		}
		return null ; // No class found for this action
	}
	
}
