/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.web.tinymvc.env;

import org.nanoj.util.StrUtil;
import org.nanoj.web.tinymvc.config.Configuration;

public class ActionView {
    private final String originalResult;
    private final String pageName;
    private final String pagePath;
    private final String layoutName;
    private final String layoutPath;

    public ActionView(String actionResult, Configuration configuration) {
        if (StrUtil.nullOrVoid((String)actionResult)) {
            throw new IllegalArgumentException("Action result is null or void");
        }
        this.originalResult = actionResult;
        int pos = actionResult.indexOf(58);
        if (pos < 0) {
            this.pageName = actionResult.trim();
            this.layoutName = null;
        } else {
            this.pageName = actionResult.substring(0, pos).trim();
            String s = actionResult.substring(pos + 1, actionResult.length()).trim();
            this.layoutName = s.length() == 0 ? null : s;
        }
        if (this.pageName.length() == 0) {
            throw new IllegalArgumentException("Action view is void");
        }
        this.pagePath = this.getPageFullPath(this.pageName, configuration);
        this.layoutPath = this.layoutName != null ? this.getLayoutFullPath(this.layoutName, configuration) : null;
    }

    public String getOriginalResult() {
        return this.originalResult;
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public String getLayoutName() {
        return this.layoutName;
    }

    public String getLayoutPath() {
        return this.layoutPath;
    }

    public boolean hasLayout() {
        return this.layoutName != null;
    }

    public String getViewName() {
        if (this.layoutName != null) {
            return this.layoutName;
        }
        return this.pageName;
    }

    public String getViewPath() {
        if (this.layoutPath != null) {
            return this.layoutPath;
        }
        return this.pagePath;
    }

    private String getPageFullPath(String pageName, Configuration configuration) {
        if (pageName.endsWith(configuration.getViewsSuffix())) {
            return configuration.getViewsFolder() + pageName;
        }
        return configuration.getViewsFolder() + pageName + configuration.getViewsSuffix();
    }

    private String getLayoutFullPath(String layoutName, Configuration configuration) {
        if (layoutName.endsWith(configuration.getViewsSuffix())) {
            return configuration.getLayoutsFolder() + layoutName;
        }
        return configuration.getLayoutsFolder() + layoutName + configuration.getViewsSuffix();
    }
}

