/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.web.tinymvc.util;

public class ConsoleLogger {
    public static final int ALL = 900;
    public static final int DEBUG = 700;
    public static final int TRACE = 600;
    public static final int INFO = 400;
    public static final int WARN = 300;
    public static final int ERROR = 200;
    public static final int OFF = 0;
    private static int globalLevel = 400;
    private final String className;

    public static final void setGlobalLevel(int level) {
        globalLevel = level;
    }

    public static final ConsoleLogger getLogger(Class<?> clazz) {
        return new ConsoleLogger(clazz);
    }

    public ConsoleLogger(Class<?> clazz) {
        this.className = clazz.getSimpleName();
    }

    public void info(String msg) {
        if (globalLevel >= 400) {
            this.print("[INFO] " + this.className + " : " + msg);
        }
    }

    public void error(String msg) {
        if (globalLevel >= 200) {
            this.print("[ERROR] " + this.className + " : " + msg);
        }
    }

    public void trace(String msg) {
        if (globalLevel >= 600) {
            this.print("[TRACE] " + this.className + " : " + msg);
        }
    }

    public void debug(String msg) {
        this.print("[DEBUG] " + this.className + " : " + msg);
    }

    private void print(String msg) {
        System.out.println(msg);
    }
}

