package org.nanoko.coffee.mill.mojos.compile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on coffee-mill-maven-plugin.<br/> Call <pre>  mvn coffee-mill:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Wed Feb 13 18:17:18 CET 2013
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.8)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.nanoko.coffee-mill:coffee-mill-maven-plugin:1.0.0", 0 );
        append( sb, "", 0 );

        append( sb, "OW2 Nanoko -  Coffee Mill Maven Plugin", 0 );
        append( sb, "A Maven Plugin to build Client-Side Web Applications", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 24 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "aggregate-javascript".equals( goal ) )
        {
            append( sb, "coffee-mill:aggregate-javascript", 0 );
            append( sb, "Aggregate JavaScript sources: Aggregation order can be specified in the Maven Configuration It can also include:\n-\tThe Javascript file from the project ((filename.js)\n-\tDependencies files (artifactId.js)\n-\tCompile files (CoffeeScript) (coffee_filename.js)\nIf no file are included, the project js files are aggregated in the alphabetical order.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javascriptAggregation", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "aggregate-stylesheets".equals( goal ) )
        {
            append( sb, "coffee-mill:aggregate-stylesheets", 0 );
            append( sb, "Aggregate stylesheets sources: Aggregation order can be specified in the Maven Configuration It can also include:\n-\tThe CSS file from the project ((filename.js)\n-\tCompiled files (LESS) (less_filename.js)\nIf no file are included, the project CSS files are aggregated in the alphabetical order.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "cssAggregation", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "build-zip".equals( goal ) )
        {
            append( sb, "coffee-mill:build-zip", 0 );
            append( sb, "Build a zip file including the all assets, generated files and dependencies.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "attachArchive (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "skipArchiveCreation (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "compile-coffeescript".equals( goal ) )
        {
            append( sb, "coffee-mill:compile-coffeescript", 0 );
            append( sb, "Compiles CoffeeScript files. CoffeeScript files are generally in the src/main/coffee directory. It can be configured using the coffeeScriptDir parameter. If the directory does not exist, the compilation is skipped.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "skipCoffeeScriptCompilation (Default: false)", 2 );
                append( sb, "Enables / Disables the coffeescript compilation. Be aware that this property disables the compilation on both main sources and test sources.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "compile-css".equals( goal ) )
        {
            append( sb, "coffee-mill:compile-css", 0 );
            append( sb, "Copy CSS to the work directory and check CSS file using CSSLint.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "skipCSSLint (Default: false)", 2 );
                append( sb, "Sets to true to disable CSSLint", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "compile-javascript".equals( goal ) )
        {
            append( sb, "coffee-mill:compile-javascript", 0 );
            append( sb, "Copy JavaScript sources to the work directory and check JavaScript sources with\n-\tCheck the code using JSLint\n-\tCheck the code using JSHint\n-\tCompile dust template (.dust files)\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "skipDustCompilation (Default: false)", 2 );
                append( sb, "Enables / disables dust compilation", 3 );
                append( sb, "", 0 );

                append( sb, "skipJsHint (Default: false)", 2 );
                append( sb, "Enables / disables JSHint", 3 );
                append( sb, "", 0 );

                append( sb, "skipJsLint (Default: false)", 2 );
                append( sb, "Enables / disables JSLint", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "compile-less".equals( goal ) )
        {
            append( sb, "coffee-mill:compile-less", 0 );
            append( sb, "Compiles Less files.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "compress-html".equals( goal ) )
        {
            append( sb, "coffee-mill:compress-html", 0 );
            append( sb, "Compress HTML pages using HtmlCompressor.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionGenerateStatistics (Default: true)", 2 );
                append( sb, "HTML compression statistics", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionPredefinedPreservePatterns", 2 );
                append( sb, "Predefined patterns for most often used custom preservation rules: PHP_TAG_PATTERN and SERVER_SCRIPT_TAG_PATTERN.", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionPreserveLineBreak (Default: true)", 2 );
                append( sb, "If set to false keeps line breaks (default is true)", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionPreservePatterns", 2 );
                append( sb, "Preserve patterns", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionRemoveComments (Default: true)", 2 );
                append( sb, "If set to false keeps HTML comments (default is true)", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionRemoveFormAttributes (Default: false)", 2 );
                append( sb, "Removes optional attributes from form tags", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionRemoveHttpProtocol (Default: false)", 2 );
                append( sb, "Replaces \'http://\' with \'//\' inside tag attributes", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionRemoveHttpsProtocol (Default: false)", 2 );
                append( sb, "Replace \'https://\' with \'//\' inside tag attributes", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionRemoveInputAttributes (Default: false)", 2 );
                append( sb, "Removes optional attributes from input tags", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionRemoveIntertagSpaces (Default: false)", 2 );
                append( sb, "Removes iter-tag whitespace characters", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionRemoveJavaScriptProtocol (Default: false)", 2 );
                append( sb, "Removes \'javascript:\' from inline event handlers", 3 );
                append( sb, "Expression: ${htmlcompressor.removeJavaScriptProtocol}", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionRemoveLinkAttributes (Default: false)", 2 );
                append( sb, "Removes optional attributes from link tags", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionRemoveMultiSpaces (Default: true)", 2 );
                append( sb, "If sets to false keeps multiple whitespace characters (default is true)", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionRemoveQuotes (Default: false)", 2 );
                append( sb, "Removes unnecessary tag attribute quotes", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionRemoveScriptAttributes (Default: false)", 2 );
                append( sb, "Removes optional attributes from script tags", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionRemoveStyleAttributes (Default: false)", 2 );
                append( sb, "Removes optional attributes from style tags", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionSimpleBooleanAttributes (Default: false)", 2 );
                append( sb, "Removes values from boolean tag attributes", 3 );
                append( sb, "", 0 );

                append( sb, "htmlCompressionSimpleDoctype (Default: false)", 2 );
                append( sb, "Simplifies existing doctype", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "skipHtmlCompressor (Default: true)", 2 );
                append( sb, "Enables / disables the HTML Compression The compression is disabled by default. Once enabled, don\'t forget to set up the compression options.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "copy-assets".equals( goal ) )
        {
            append( sb, "coffee-mill:copy-assets", 0 );
            append( sb, "Copy src/main/www and src/main/resources to the www directory", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "csslint-report".equals( goal ) )
        {
            append( sb, "coffee-mill:csslint-report", 0 );
            append( sb, "Builds the CSSLint Report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "coffee-mill:help", 0 );
            append( sb, "Display help information on coffee-mill-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0coffee-mill:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jasmine-it-test".equals( goal ) )
        {
            append( sb, "coffee-mill:jasmine-it-test", 0 );
            append( sb, "(no description available)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptIntegrationTestDir (Default: src/integration-test/js)", 2 );
                append( sb, "Where are JavaScript files implementing integration tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "runJasmineTestOnAggregatedVersion (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "runJasmineTestOnMinifiedVersion (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "skipJasmineITTest (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jasmine-test".equals( goal ) )
        {
            append( sb, "coffee-mill:jasmine-test", 0 );
            append( sb, "(no description available)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javascriptAggregation", 2 );
                append( sb, "The list in order of the javascript file to include. This list is shared with the javascript aggregation.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "skipJasmineTest (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jsdoc".equals( goal ) )
        {
            append( sb, "coffee-mill:jsdoc", 0 );
            append( sb, "Builds the JSDoc API. It uses JSDoc3 but requires to have the jsdoc executable in the path.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "jsdocIncludePrivate", 2 );
                append( sb, "Whether to include symbols tagged as private. Default is false.", 3 );
                append( sb, "Expression: false", 3 );
                append( sb, "", 0 );

                append( sb, "skipJSDOC (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jshint-report".equals( goal ) )
        {
            append( sb, "coffee-mill:jshint-report", 0 );
            append( sb, "Builds the JSHint Report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jslint-report".equals( goal ) )
        {
            append( sb, "coffee-mill:jslint-report", 0 );
            append( sb, "Builds the JSHint Report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "minify-javascript".equals( goal ) )
        {
            append( sb, "coffee-mill:minify-javascript", 0 );
            append( sb, "Minify JavaScript sources. It can use Google Closure or YUI Compressor. The minified file is attached to the project using the min classifier, except if the attachMinifiedJavaScript parameter is set to false", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "attachMinifiedJavaScript (Default: true)", 2 );
                append( sb, "Enables / Disables the attachment of the minified file to the Maven project. Enabled by default.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "minifier (Default: GOOGLE_CLOSURE)", 2 );
                append( sb, "The JavaScript minifier to use among GOOGLE_CLOSURE (default) and YUI_COMPRESSOR.", 3 );
                append( sb, "", 0 );

                append( sb, "minifierGoogleCompilationLevel (Default: SIMPLE_OPTIMIZATIONS)", 2 );
                append( sb, "Selects the compilation level for Google Closure among SIMPLE_OPTIMIZATIONS, WHITESPACE_ONLY and ADVANCED_OPTIMIZATIONS. Be aware that ADVANCED_OPTIMIZATIONS modifies the API. This option is ignored on the YUI minifier.", 3 );
                append( sb, "", 0 );

                append( sb, "minifierYUIDisableOptimizations (Default: false)", 2 );
                append( sb, "YUI Options to disable the optimizations. Disabled by default (so optimizations enabled). This parameter is ignored on the GOOGLE minifier.", 3 );
                append( sb, "", 0 );

                append( sb, "minifierYUIMunge (Default: true)", 2 );
                append( sb, "YUI Options to enable / disable the munge mode. Enabled by default. This parameter is ignored on the GOOGLE minifier.", 3 );
                append( sb, "", 0 );

                append( sb, "minifierYUIPreserveSemiColumn (Default: false)", 2 );
                append( sb, "YUI Option to preserve all semi columns. Disabled by default. This parameter is ignored on the GOOGLE minifier.", 3 );
                append( sb, "", 0 );

                append( sb, "minifierYUIVerbose (Default: false)", 2 );
                append( sb, "YUI Option to enable the verbose mode. Disabled by default. This parameter is ignored on the GOOGLE minifier.", 3 );
                append( sb, "", 0 );

                append( sb, "skipMinification (Default: false)", 2 );
                append( sb, "Enables to skip the minification phase.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "minify-stylesheets".equals( goal ) )
        {
            append( sb, "coffee-mill:minify-stylesheets", 0 );
            append( sb, "Minify CSS sources. It can use the CSS compressor from YUI. The minified file is attached to the project using the min classifier, except if the attachMinifiedCSS parameter is set to false", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "attachMinifiedCSS (Default: true)", 2 );
                append( sb, "Enables / Disables the attachment of the minified file to the Maven project. Enabled by default.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "skipMinification (Default: false)", 2 );
                append( sb, "Enables to skip the minification phase.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "optimize-jpeg".equals( goal ) )
        {
            append( sb, "coffee-mill:optimize-jpeg", 0 );
            append( sb, "Optimizes JPEG files using jpegtran (http://jpegclub.org/jpegtran/). JpegTran must be installed and the executable `jpegtran` available form the system path.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "jpegTranVerbose (Default: true)", 2 );
                append( sb, "Enables the verbose mode of optiPNG.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "skipjpegTran (Default: false)", 2 );
                append( sb, "Skips the JPEG files optimization.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "optimize-png".equals( goal ) )
        {
            append( sb, "coffee-mill:optimize-png", 0 );
            append( sb, "Optimizes PNG files using optiPNG (http://optipng.sourceforge.net/). OptiPNG must be installed and the executable `optipng` available form the system path.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "optiPngOptimizationLevel (Default: 2)", 2 );
                append( sb, "The optiPNG optimization level among 0-7.", 3 );
                append( sb, "", 0 );

                append( sb, "optiPNGVerbose (Default: true)", 2 );
                append( sb, "Enables the verbose mode of optiPNG.", 3 );
                append( sb, "", 0 );

                append( sb, "skipOptiPNG (Default: false)", 2 );
                append( sb, "Skips the PNG files optimization.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "resolve-dependencies".equals( goal ) )
        {
            append( sb, "coffee-mill:resolve-dependencies", 0 );
            append( sb, "Copy `js` project dependencies to the target/libs folder. Copy `css` project dependencies to the target/web folder. The location can be changed using the webDir and libsDir option", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test-compile-coffeescript".equals( goal ) )
        {
            append( sb, "coffee-mill:test-compile-coffeescript", 0 );
            append( sb, "Compiles CoffeeScript files. CoffeeScript files are generally in the src/test/coffee directory. It can be configured using the coffeeScriptTestDir parameter. If the directory does not exist, the compilation is skipped.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "skipCoffeeScriptCompilation (Default: false)", 2 );
                append( sb, "Enables / Disables the coffeescript compilation. Be aware that this property disables the compilation on both main sources and test sources.", 3 );
                append( sb, "", 0 );

                append( sb, "skipCoffeeScriptTestCompilation (Default: false)", 2 );
                append( sb, "Enables / Disables the coffeescript test compilation. Be aware that this property disables the compilation of test sources only.", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test-compile-javascript".equals( goal ) )
        {
            append( sb, "coffee-mill:test-compile-javascript", 0 );
            append( sb, "Copy JavaScript sources to the work directory and check JavaScript sources with\n-\tCheck the code using JSLint\n-\tCheck the code using JSHint\nTODO Exclude strict mode.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "skipJsHint (Default: true)", 2 );
                append( sb, "Sets to true to disable JSHint", 3 );
                append( sb, "", 0 );

                append( sb, "skipJsLint (Default: true)", 2 );
                append( sb, "Sets to true to disable JSLint", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "watch".equals( goal ) )
        {
            append( sb, "coffee-mill:watch", 0 );
            append( sb, "This mojo watches the file change in the source directories and process them automatically. To work correctly, launch mvn clean test first. This will resolve and prepare all required file. Then mvn org.nanoko.coffee-mill:coffee-mill-maven-plugin:watch will starts the watch mode. This mojo supports reactor mode, i.e. is able to watch several modules and updates files. To enable this mode, launch the watch mode with -Dwatched.project=artifactId of the final project. This will watch all resources of all the modules of the reactor and copy the resulting artifact on the other module in the specified project. You can configure the watched port with the -Dwatch.port=8234 option. By default the used port is 8234.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assetsDir (Default: src/main/www)", 2 );
                append( sb, "Where are the assets.", 3 );
                append( sb, "", 0 );

                append( sb, "baseDirectory", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "Directory containing the build files.", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptDir (Default: src/main/coffee)", 2 );
                append( sb, "Where are CoffeeScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "coffeeScriptTestDir (Default: src/test/coffee)", 2 );
                append( sb, "Where are CoffeeScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "cssAggregation", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "javascriptAggregation", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptDir (Default: src/main/js)", 2 );
                append( sb, "Where are JavaScript files.", 3 );
                append( sb, "", 0 );

                append( sb, "javaScriptTestDir (Default: src/test/js)", 2 );
                append( sb, "Where are JavaScript files implementing tests.", 3 );
                append( sb, "", 0 );

                append( sb, "libDir (Default: target/libs)", 2 );
                append( sb, "Where are the dependencies copies.", 3 );
                append( sb, "", 0 );

                append( sb, "optiPngOptimizationLevel (Default: 2)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetsDir (Default: src/main/stylesheets)", 2 );
                append( sb, "Where are LESS, CSS and SASS/SCSS files.", 3 );
                append( sb, "", 0 );

                append( sb, "watchCoffeeScript (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "watchDoAggregate (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "watchDust (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "watchedProject (Default: ${project.artifactId})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${watched.project}", 3 );
                append( sb, "", 0 );

                append( sb, "watchJettyServerPort (Default: 8234)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${watch.port}", 3 );
                append( sb, "", 0 );

                append( sb, "watchLess (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "watchOptimizeAssets (Default: true)", 2 );
                append( sb, "Enables the PNG and JPEG optimization", 3 );
                append( sb, "", 0 );

                append( sb, "watchRunServer (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "watchValidateCSS (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "watchValidateJS (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "workDir (Default: target/www)", 2 );
                append( sb, "Where are the output files written.", 3 );
                append( sb, "", 0 );

                append( sb, "workTestDir (Default: target/www-test)", 2 );
                append( sb, "Where are the output test files written.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
