/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core;

import berlin.yuna.typemap.model.FunctionOrNull;
import berlin.yuna.typemap.model.TypeMap;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.nanonative.nano.core.NanoServices;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.core.model.Service;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.event.EventChannelRegister;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.helper.logger.logic.LogQueue;
import org.nanonative.nano.helper.logger.logic.NanoLogger;
import org.nanonative.nano.services.metric.logic.MetricService;
import org.nanonative.nano.services.metric.model.MetricType;
import org.nanonative.nano.services.metric.model.MetricUpdate;

public class Nano
extends NanoServices<Nano> {
    public Nano(Service ... startupServices) {
        this((String[])null, startupServices);
    }

    public Nano(String[] args, Service ... startupServices) {
        this((FunctionOrNull<Context, List<Service>>)((FunctionOrNull)context -> Arrays.asList(startupServices)), null, args);
    }

    public Nano(Map<Object, Object> config, Service ... startupServices) {
        this((FunctionOrNull<Context, List<Service>>)((FunctionOrNull)ctx -> List.of(startupServices)), config, new String[0]);
    }

    public Nano(Map<Object, Object> config, FunctionOrNull<Context, List<Service>> startupServices) {
        this(startupServices, config, new String[0]);
    }

    public Nano(String[] args, FunctionOrNull<Context, List<Service>> startupServices) {
        this(startupServices, null, args);
    }

    public Nano(FunctionOrNull<Context, List<Service>> startupServices, Map<Object, Object> config, String ... args) {
        super(config, args);
        this.context.put("app_core_context_nano", this);
        this.context.put("app_core_context_class", this.getClass());
        long initTime = System.currentTimeMillis() - this.createdAtMs;
        this.logger.trace(() -> "Init [{}] in [{}]", this.getClass().getSimpleName(), NanoUtils.formatDuration(initTime));
        this.printParameters();
        long service_startUpTime = System.currentTimeMillis();
        this.logger.debug(() -> "Start {}", this.getClass().getSimpleName());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdown(this.context(this.getClass()))));
        this.startServices(startupServices);
        this.run(() -> this.context, () -> this.sendEvent(Context.EVENT_APP_HEARTBEAT, this.context, (Object)this, result -> {}, true), 256L, 256L, TimeUnit.MILLISECONDS, () -> false);
        this.run(() -> this.context, System::gc, 5L, 5L, TimeUnit.SECONDS, () -> false);
        long readyTime = System.currentTimeMillis() - service_startUpTime;
        this.printActiveProfiles();
        this.logger.info(() -> "Started [{}] in [{}]", NanoUtils.generateNanoName("%s%.0s%.0s%.0s"), NanoUtils.formatDuration(readyTime));
        this.printSystemInfo();
        this.sendEvent(MetricService.EVENT_METRIC_UPDATE, this.context, (Object)new MetricUpdate(MetricType.GAUGE, "application.started.time", initTime, null), result -> {}, false);
        this.sendEvent(MetricService.EVENT_METRIC_UPDATE, this.context, (Object)new MetricUpdate(MetricType.GAUGE, "application.ready.time", readyTime, null), result -> {}, false);
        this.subscribeEvent(Context.EVENT_APP_SHUTDOWN, event -> event.acknowledge(() -> CompletableFuture.runAsync(() -> this.shutdown(event.context()))));
        this.subscribeEvent(Context.EVENT_APP_HEARTBEAT, this::cleanUps);
        this.sendEvent(Context.EVENT_APP_START, this.context, (Object)this, result -> {}, true);
    }

    public Context context() {
        return this.context;
    }

    @Override
    public Context context(Class<?> clazz) {
        return this.context.newContext(clazz);
    }

    public Context contextEmpty(Class<?> clazz) {
        return this.context.newEmptyContext(clazz);
    }

    @Override
    public Nano stop(Class<?> clazz) {
        return this.stop(clazz != null ? this.context(clazz) : null);
    }

    @Override
    public Nano stop(Context context) {
        this.sendEvent(Context.EVENT_APP_SHUTDOWN, context != null ? context : this.context(this.getClass()), (Object)null, result -> {}, true);
        return this;
    }

    public Nano waitForStop() {
        NanoUtils.waitForCondition(() -> !this.isReady(), 10000L);
        return this;
    }

    public void printParameters() {
        if (this.context.getOpt(Boolean.class, new Object[]{Context.APP_PARAMS}).filter(printCalled -> printCalled).isPresent()) {
            List<String> secrets = List.of("secret", "token", "pass", "pwd", "bearer", "auth", "private", "ssn");
            int keyLength = this.context.keySet().stream().map(String::valueOf).mapToInt(String::length).max().orElse(0);
            this.logger.info(() -> "Configs: " + System.lineSeparator() + this.context.entrySet().stream().sorted().map(config -> String.format("%-" + keyLength + "s  %s", config.getKey(), secrets.stream().anyMatch(s -> String.valueOf(config.getKey()).toLowerCase().contains((CharSequence)s)) ? "****" : config.getValue())).collect(Collectors.joining(System.lineSeparator())), new Object[0]);
        }
    }

    @Override
    public Nano sendEvent(int channelId, Context context, Object payload, Consumer<Object> responseListener, boolean broadcast) {
        this.sendEventReturn(channelId, context, payload, responseListener, broadcast);
        return this;
    }

    @Override
    public Event sendEventReturn(int channelId, Context context, Object payload, Consumer<Object> responseListener, boolean broadCast) {
        Object object;
        if (channelId == Context.EVENT_CONFIG_CHANGE && payload instanceof Map) {
            Map map = (Map)payload;
            object = new TypeMap(map);
        } else {
            object = payload;
        }
        Event event = new Event(channelId, context, object, responseListener);
        if (responseListener == null) {
            this.sendEventSameThread(event, broadCast);
        } else {
            context.run(() -> this.sendEventSameThread(event, broadCast));
        }
        return event;
    }

    public Nano sendEventSameThread(Event event, boolean broadcast) {
        this.eventCount.incrementAndGet();
        event.context().tryExecute(() -> {
            boolean match = this.listeners.getOrDefault(event.channelId(), Collections.emptySet()).stream().anyMatch(listener -> {
                event.context().tryExecute(() -> listener.accept(event), throwable -> event.context().sendEventError(event, (Throwable)throwable));
                return !broadcast && event.isAcknowledged();
            });
            if (!match) {
                this.services.stream().filter(Service::isReady).anyMatch(service -> {
                    event.context().tryExecute(() -> service.onEvent(event), throwable -> event.context().sendEventError(event, (Service)service, (Throwable)throwable));
                    return !broadcast && event.isAcknowledged();
                });
            }
        });
        this.eventCount.decrementAndGet();
        return this;
    }

    protected Nano shutdown(Class<?> clazz) {
        this.shutdown(this.context(clazz));
        return this;
    }

    protected void cleanUps(Event event) {
        double usage = this.heapMemoryUsage();
        int threshold = this.context.getOpt(Integer.class, new Object[]{Context.CONFIG_OOM_SHUTDOWN_THRESHOLD}).orElse(98);
        if (threshold > 0 && usage > (double)threshold / 100.0 && !this.context.sendEventReturn(Context.EVENT_APP_OOM, usage).isAcknowledged()) {
            this.logger.warn(() -> "Out of mana aka memory [{}] threshold [{}] event [{}] shutting down", usage, threshold, EventChannelRegister.eventNameOf(Context.EVENT_APP_OOM));
            this.context.put("_app_exit_code", 127);
            this.shutdown(this.context);
        }
        new HashSet(this.schedulers).stream().filter(scheduler -> scheduler.isShutdown() || scheduler.isTerminated()).forEach(this.schedulers::remove);
    }

    protected void printActiveProfiles() {
        List list = this.context.asList(String.class, new Object[]{"_scanned_profiles"});
        if (!list.isEmpty()) {
            this.logger.debug(() -> "Profiles [{}] Services [{}]", list.stream().sorted().collect(Collectors.joining(", ")), this.services().stream().collect(Collectors.groupingBy(Service::name, Collectors.counting())).entrySet().stream().map(entry -> (Long)entry.getValue() > 1L ? "(" + String.valueOf(entry.getValue()) + ") " + (String)entry.getKey() : (String)entry.getKey()).collect(Collectors.joining(", ")));
        }
    }

    protected void startServices(FunctionOrNull<Context, List<Service>> startupServices) {
        List services;
        if (startupServices != null && (services = (List)startupServices.apply((Object)this.context)) != null) {
            this.logger.debug(() -> "StartupServices [{}] services [{}]", services.size(), services.stream().map(Service::name).distinct().collect(Collectors.joining(", ")));
            Map<Boolean, List<Service>> partitionedServices = services.stream().collect(Collectors.partitioningBy(LogQueue.class::isInstance));
            partitionedServices.getOrDefault(true, Collections.emptyList()).stream().findFirst().ifPresent(service -> {
                this.context.put("app_core_context_log_queue", service);
                this.context.run((Service)service);
            });
            this.context.runAwait((Service[])partitionedServices.getOrDefault(false, Collections.emptyList()).toArray(Service[]::new));
        }
    }

    protected Nano shutdown(Context context) {
        this.isReady.set(true, false, run -> {
            NanoLogger logger = context.logger();
            int exitCode = context.getOpt(Integer.class, new Object[]{"_app_exit_code"}).orElse(0);
            boolean exitCodeAllowed = context.getOpt(Boolean.class, new Object[]{Context.CONFIG_ENV_PROD}).orElse(false);
            this.gracefulShutdown(logger);
            if (exitCodeAllowed) {
                this.exit(logger, exitCode);
            }
        });
        return this;
    }

    public String hostname() {
        return String.valueOf(this.context.computeIfAbsent("app_hostname", value -> {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                return "Localhost";
            }
        }));
    }

    public Nano printSystemInfo() {
        long activeThreads = NanoThread.activeCarrierThreads();
        this.logger.debug(() -> "pid [{}] schedulers [{}] services [{}] listeners [{}] cores [{}] usedMemory [{}mb] threadsNano [{}], threadsActive [{}] threadsOther [{}] java [{}] arch [{}] os [{}] host [{}]", this.pid(), this.schedulers.size(), this.services.size(), this.listeners.values().stream().mapToLong(Collection::size).sum(), Runtime.getRuntime().availableProcessors(), this.usedMemoryMB(), NanoThread.activeNanoThreads(), activeThreads, (long)ManagementFactory.getThreadMXBean().getThreadCount() - activeThreads, System.getProperty("java.version"), System.getProperty("os.arch"), System.getProperty("os.name") + " - " + System.getProperty("os.version"), this.hostname());
        return this;
    }

    protected void gracefulShutdown(NanoLogger logger) {
        try {
            Thread sequence = new Thread(() -> {
                long startTimeMs = System.currentTimeMillis();
                logger.logQueue(null).info(() -> "Stop {} ...", this.getClass().getSimpleName());
                this.printSystemInfo();
                logger.debug(() -> "Shutdown Services count [{}] services [{}]", this.services.size(), this.services.stream().map(Object::getClass).map(Class::getSimpleName).distinct().collect(Collectors.joining(", ")));
                this.shutdownServices(this.context);
                this.shutdownThreads();
                this.listeners.clear();
                this.printSystemInfo();
                logger.info(() -> "Stopped [{}] in [{}] with uptime [{}]", NanoUtils.generateNanoName("%s%.0s%.0s%.0s"), NanoUtils.formatDuration(System.currentTimeMillis() - startTimeMs), NanoUtils.formatDuration(System.currentTimeMillis() - this.createdAtMs));
                this.threadPool.shutdown();
                this.schedulers.clear();
            }, Nano.class.getSimpleName() + " Shutdown-Hook");
            sequence.start();
            sequence.join();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    protected void exit(NanoLogger logger, int exitCode) {
        try {
            Thread thread = new Thread(() -> {
                try {
                    Runtime.getRuntime().halt(exitCode);
                }
                catch (SecurityException e) {
                    logger.error(e, () -> "Failed to set exit code. The dark side is strong.", new Object[0]);
                }
            }, Nano.class.getSimpleName() + " Shutdown-Thread");
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error(e, () -> "Shutdown was interrupted. The empire strikes back.", new Object[0]);
        }
    }

    public String toString() {
        long activeThreads = NanoThread.activeCarrierThreads();
        return "Nano{pid=" + this.pid() + ", schedulers=" + this.schedulers.size() + ", services=" + this.services.size() + ", listeners=" + this.listeners.values().stream().mapToLong(Collection::size).sum() + ", cores=" + Runtime.getRuntime().availableProcessors() + ", usedMemory=" + this.usedMemoryMB() + "mb, threadsActive=" + NanoThread.activeNanoThreads() + ", threadsNano=" + activeThreads + ", threadsOther=" + ((long)ManagementFactory.getThreadMXBean().getThreadCount() - activeThreads) + ", java=" + System.getProperty("java.version") + ", arch=" + System.getProperty("os.arch") + ", os=" + System.getProperty("os.name") + " - " + System.getProperty("os.version") + ", host=" + this.hostname() + "}";
    }
}

