/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core.model;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.helper.ExRunnable;
import org.nanonative.nano.helper.LockedBoolean;
import org.nanonative.nano.helper.NanoUtils;

public class NanoThread {
    protected final List<BiConsumer<NanoThread, Throwable>> onCompleteCallbacks = new CopyOnWriteArrayList<BiConsumer<NanoThread, Throwable>>();
    protected final Context context;
    protected final LockedBoolean isComplete = new LockedBoolean();
    public static final ExecutorService VIRTUAL_THREAD_POOL = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("nano-thread-", 0L).factory());
    protected static final AtomicLong activeNanoThreadCount = new AtomicLong(0L);

    public NanoThread() {
        this.context = null;
    }

    public NanoThread(Context context) {
        this.context = context;
    }

    public Context context() {
        return this.context;
    }

    public boolean isComplete() {
        return this.isComplete.get();
    }

    public NanoThread onComplete(BiConsumer<NanoThread, Throwable> onComplete) {
        this.isComplete.run(state -> {
            if (Boolean.TRUE.equals(state)) {
                onComplete.accept(this, null);
            } else {
                this.onCompleteCallbacks.add(onComplete);
            }
        });
        return this;
    }

    public NanoThread await() {
        return this.await(null);
    }

    public NanoThread await(Runnable onDone) {
        return NanoThread.waitFor(onDone, this)[0];
    }

    public NanoThread run(ExecutorService executor, Supplier<Context> context, ExRunnable task) {
        (executor != null ? executor : VIRTUAL_THREAD_POOL).submit(() -> {
            try {
                activeNanoThreadCount.incrementAndGet();
                task.run();
                this.isComplete.set(true, state -> this.onCompleteCallbacks.forEach(onComplete -> onComplete.accept(this, null)));
            }
            catch (Throwable error) {
                NanoUtils.handleJavaError(context, error);
                this.isComplete.set(true, arg_0 -> this.lambda$run$5(error, (Supplier)context, task, arg_0));
            }
            finally {
                activeNanoThreadCount.decrementAndGet();
            }
        });
        return this;
    }

    public static long activeNanoThreads() {
        return activeNanoThreadCount.get();
    }

    public static long activeCarrierThreads() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] threadIds = threadMXBean.getAllThreadIds();
        return Arrays.stream(threadMXBean.getThreadInfo(threadIds)).filter(Objects::nonNull).filter(info -> info.getThreadName() != null && info.getThreadName().startsWith("CarrierThread") || info.getLockName() != null && info.getLockName().startsWith("java.lang.VirtualThread") || info.getLockOwnerName() != null && info.getLockName().startsWith("nano-thread-")).count();
    }

    public static NanoThread[] waitFor(NanoThread ... threads) {
        return NanoThread.waitFor(null, threads);
    }

    public static NanoThread[] waitFor(Runnable onComplete, NanoThread ... threads) {
        CountDownLatch latch = new CountDownLatch(threads.length);
        for (NanoThread thread : threads) {
            thread.onComplete((nt, error) -> {
                latch.countDown();
                if (!(error instanceof Error) && latch.getCount() <= 0L && onComplete != null) {
                    onComplete.run();
                }
            });
        }
        if (onComplete == null) {
            try {
                boolean completed = latch.await(10L, TimeUnit.SECONDS);
                if (!completed) {
                    System.err.println(String.valueOf(new Date()) + " [FATAL] Threads did no complete");
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        return threads;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{onCompleteCallbacks=" + this.onCompleteCallbacks.size() + ", context=" + (this.context != null) + ", isComplete=" + this.isComplete() + "}";
    }

    private /* synthetic */ void lambda$run$5(Throwable error, Supplier context, ExRunnable task, Boolean state) {
        if (!this.onCompleteCallbacks.isEmpty()) {
            this.onCompleteCallbacks.forEach(onComplete -> onComplete.accept(this, error));
        } else {
            Optional.ofNullable(context).map(Supplier::get).ifPresent(ctx -> ctx.sendEventError(task, error));
        }
    }
}

