/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.helper.logger.logic;

import berlin.yuna.typemap.model.Pair;
import berlin.yuna.typemap.model.TypeMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.Service;
import org.nanonative.nano.helper.event.model.Event;

public class LogQueue
extends Service {
    protected BlockingQueue<Pair<Logger, LogRecord>> queue;
    protected int queueCapacity;

    public LogQueue() {
        super(null, false);
    }

    public boolean log(Logger logger, LogRecord logRecord) {
        if (this.isReady() && this.queue != null) {
            try {
                this.queue.put((Pair<Logger, LogRecord>)new Pair((Object)logger, (Object)logRecord));
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    @Override
    public void start(Supplier<Context> contextSub) {
        this.isReady.set(false, true, state -> {
            Context context = (Context)((Object)((Object)contextSub.get()));
            this.queueCapacity = context.getOpt(Integer.class, new Object[]{Context.CONFIG_LOG_QUEUE_SIZE}).orElse(1000);
            this.queue = new LinkedBlockingQueue<Pair<Logger, LogRecord>>(this.queueCapacity);
            context.run(this::process).run(this::checkQueueSizeAndWarn, 5L, 5L, TimeUnit.MINUTES, () -> !this.isReady()).broadcastEvent(Context.EVENT_CONFIG_CHANGE, Map.of("app_core_context_log_queue", this));
        });
    }

    @Override
    public void stop(Supplier<Context> contextSub) {
        this.isReady.set(true, false, state -> {
            try {
                ((Context)((Object)((Object)contextSub.get()))).broadcastEvent(Context.EVENT_CONFIG_CHANGE, Map.of("app_core_context_log_queue", this));
                this.logger.debug(() -> "Shutdown initiated - process last messages [{}]", this.queue.size());
                this.queue.put((Pair<Logger, LogRecord>)new Pair((Object)this.logger.javaLogger(), (Object)new LogRecord(Level.INFO, "Shutdown Hook")));
                this.queue = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    @Override
    public void onEvent(Event event) {
        event.ifPresent(Context.EVENT_CONFIG_CHANGE, TypeMap.class, map -> {
            map.remove((Object)"app_core_context_log_queue");
            this.logger.configure((TypeMap)map);
        });
    }

    @Override
    public Object onFailure(Event error) {
        return null;
    }

    protected void process() {
        while (this.isReady() || this.queue != null && !this.queue.isEmpty()) {
            try {
                Pair<Logger, LogRecord> pair = this.queue.take();
                if (pair.key() == this.logger.javaLogger()) continue;
                ((Logger)pair.key()).log((LogRecord)pair.value());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void checkQueueSizeAndWarn() {
        this.isReady.run(true, state -> {
            if (this.queue != null) {
                int percentage;
                int size = this.queue.size();
                int n = percentage = size > 0 ? (int)((double)size / (double)this.queueCapacity) * 100 : 0;
                if (percentage > 80) {
                    this.logger.warn(() -> "Warning: Log queue is " + percentage + "% full.", new Object[0]);
                }
            }
        });
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{size=" + this.queue.size() + ", max=" + this.queueCapacity + "}";
    }
}

