/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.helper.logger.logic;

import berlin.yuna.typemap.model.TypeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.helper.logger.logic.LogFormatterJson;
import org.nanonative.nano.helper.logger.logic.LogQueue;
import org.nanonative.nano.helper.logger.model.LogErrorHandler;
import org.nanonative.nano.helper.logger.model.LogInfoHandler;
import org.nanonative.nano.helper.logger.model.LogLevel;

public class NanoLogger {
    public static final Formatter DEFAULT_LOG_FORMATTER = new LogFormatterJson();
    public static final LogInfoHandler DEFAULT_LOG_INFO_HANDLER = new LogInfoHandler(DEFAULT_LOG_FORMATTER);
    public static final LogErrorHandler DEFAULT_LOG_ERROR_HANDLER = new LogErrorHandler(DEFAULT_LOG_FORMATTER);
    protected final Logger javaLogger;
    protected final AtomicReference<LogLevel> level = new AtomicReference<LogLevel>(LogLevel.DEBUG);
    protected LogQueue logQueue;
    public static final AtomicInteger MAX_LOG_NAME_LENGTH = new AtomicInteger(10);

    public NanoLogger(Object object) {
        this(object.getClass());
    }

    public NanoLogger(Class<?> clazz) {
        this.javaLogger = Logger.getLogger(clazz.getName());
        this.javaLogger.setUseParentHandlers(false);
        this.javaLogger.setLevel(Level.ALL);
        this.addHandlerIfAbsent(DEFAULT_LOG_INFO_HANDLER);
        this.addHandlerIfAbsent(DEFAULT_LOG_ERROR_HANDLER);
        MAX_LOG_NAME_LENGTH.updateAndGet(length -> Math.max(length, clazz.getSimpleName().length()));
    }

    public Logger javaLogger() {
        return this.javaLogger;
    }

    public LogQueue logQueue() {
        return this.logQueue;
    }

    public NanoLogger logQueue(LogQueue logQueue) {
        this.logQueue = logQueue;
        return this;
    }

    public Formatter formatter() {
        return this.javaLogger.getHandlers().length > 0 ? this.javaLogger.getHandlers()[0].getFormatter() : null;
    }

    public NanoLogger formatter(Formatter formatter) {
        for (Handler handler : this.javaLogger.getHandlers()) {
            handler.setFormatter(formatter);
        }
        return this;
    }

    public NanoLogger level(LogLevel level) {
        this.level.set(level);
        return this;
    }

    public LogLevel level() {
        return this.level.get();
    }

    public NanoLogger fatal(Supplier<String> message, Object ... params) {
        return this.log(LogLevel.FATAL, null, message, params);
    }

    public NanoLogger fatal(Throwable thrown, Supplier<String> message, Object ... params) {
        return this.log(LogLevel.FATAL, thrown, message, params);
    }

    public NanoLogger error(Supplier<String> message, Object ... params) {
        return this.log(LogLevel.ERROR, null, message, params);
    }

    public NanoLogger error(Throwable thrown, Supplier<String> message, Object ... params) {
        return this.log(LogLevel.ERROR, thrown, message, params);
    }

    public NanoLogger warn(Supplier<String> message, Object ... params) {
        return this.log(LogLevel.WARN, null, message, params);
    }

    public NanoLogger warn(Throwable thrown, Supplier<String> message, Object ... params) {
        return this.log(LogLevel.WARN, thrown, message, params);
    }

    public NanoLogger info(Supplier<String> message, Object ... params) {
        return this.log(LogLevel.INFO, null, message, params);
    }

    public NanoLogger info(Throwable thrown, Supplier<String> message, Object ... params) {
        return this.log(LogLevel.INFO, thrown, message, params);
    }

    public NanoLogger debug(Supplier<String> message, Object ... params) {
        return this.log(LogLevel.DEBUG, null, message, params);
    }

    public NanoLogger debug(Throwable thrown, Supplier<String> message, Object ... params) {
        return this.log(LogLevel.DEBUG, thrown, message, params);
    }

    public NanoLogger trace(Supplier<String> message, Object ... params) {
        return this.log(LogLevel.TRACE, null, message, params);
    }

    public NanoLogger trace(Throwable thrown, Supplier<String> message, Object ... params) {
        return this.log(LogLevel.TRACE, thrown, message, params);
    }

    public NanoLogger log(LogLevel level, Supplier<String> message, Object ... params) {
        return this.log(level, null, message, params);
    }

    public NanoLogger log(LogLevel level, Throwable thrown, Supplier<String> message, Object ... params) {
        if (level != null && message != null && this.isLoggable(level)) {
            LogRecord logRecord = new LogRecord(level.toJavaLogLevel(), message.get());
            logRecord.setParameters(params);
            logRecord.setThrown(thrown);
            logRecord.setLoggerName(this.javaLogger.getName());
            if (this.logQueue == null || !this.logQueue.log(this.javaLogger, logRecord)) {
                this.javaLogger.log(logRecord);
            }
        }
        return this;
    }

    public NanoLogger configure(TypeMap config) {
        config.getOpt(LogLevel.class, new Object[]{Context.CONFIG_LOG_LEVEL}).ifPresent(this::level);
        config.getOpt(LogQueue.class, new Object[]{"app_core_context_log_queue"}).ifPresent(this::logQueue);
        config.getOpt(Formatter.class, new Object[]{Context.CONFIG_LOG_FORMATTER}).ifPresent(this::formatter);
        return this;
    }

    protected boolean isLoggable(LogLevel level) {
        int levelValue = this.level.get().ordinal();
        return level.ordinal() <= levelValue;
    }

    protected void addHandlerIfAbsent(Handler newHandler) {
        for (Handler existingHandler : this.javaLogger.getHandlers()) {
            if (!existingHandler.getClass().equals(newHandler.getClass())) continue;
            return;
        }
        this.javaLogger.addHandler(newHandler);
    }
}

