/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.services.http;

import berlin.yuna.typemap.logic.TypeConverter;
import berlin.yuna.typemap.model.LinkedTypeMap;
import berlin.yuna.typemap.model.TypeInfo;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.http.HttpRequest;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.Service;
import org.nanonative.nano.core.model.Unhandled;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.config.ConfigRegister;
import org.nanonative.nano.helper.event.EventChannelRegister;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.services.http.logic.HttpClient;
import org.nanonative.nano.services.http.model.ContentType;
import org.nanonative.nano.services.http.model.HttpObject;

public class HttpService
extends Service {
    protected HttpServer server;
    protected Context context;
    public static final String CONFIG_SERVICE_HTTP_PORT = ConfigRegister.registerConfig("app_service_http_port", "Default port for the HTTP service (see " + HttpService.class.getSimpleName() + ")");
    public static final String CONFIG_HTTP_CLIENT_VERSION = ConfigRegister.registerConfig("app_service_http_version", "HTTP client version 1 or 2 (see " + HttpClient.class.getSimpleName() + ")");
    public static final String CONFIG_HTTP_CLIENT_MAX_RETRIES = ConfigRegister.registerConfig("app_service_http_max_retries", "Maximum number of retries for the HTTP client (see " + HttpClient.class.getSimpleName() + ")");
    public static final String CONFIG_HTTP_CLIENT_CON_TIMEOUT_MS = ConfigRegister.registerConfig("app_service_http_con_timeoutMs", "Connection timeout in milliseconds for the HTTP client (see " + HttpClient.class.getSimpleName() + ")");
    public static final String CONFIG_HTTP_CLIENT_READ_TIMEOUT_MS = ConfigRegister.registerConfig("app_service_http_read_timeoutMs", "Read timeout in milliseconds for the HTTP client (see " + HttpClient.class.getSimpleName() + ")");
    public static final String CONFIG_HTTP_CLIENT_FOLLOW_REDIRECTS = ConfigRegister.registerConfig("app_service_http_follow_redirects", "Follow redirects for the HTTP client (see " + HttpClient.class.getSimpleName() + ")");
    public static final int EVENT_HTTP_REQUEST = EventChannelRegister.registerChannelId("HTTP_REQUEST");
    public static final int EVENT_HTTP_REQUEST_UNHANDLED = EventChannelRegister.registerChannelId("HTTP_REQUEST_UNHANDLED");
    protected static final Lock STARTUP_LOCK = new ReentrantLock();

    public HttpService() {
        super(null, false);
    }

    public InetSocketAddress address() {
        return this.server == null ? null : this.server.getAddress();
    }

    public int port() {
        return this.server == null ? -1 : this.server.getAddress().getPort();
    }

    public HttpServer server() {
        return this.server;
    }

    @Override
    public void stop(Supplier<Context> contextSub) {
        this.isReady.set(true, false, state -> {
            this.server.stop(0);
            this.logger.info(() -> "[{}] port [{}] stopped", this.name(), this.server == null ? null : Integer.valueOf(this.server.getAddress().getPort()));
            this.server = null;
        });
    }

    @Override
    public void start(Supplier<Context> contextSub) {
        this.isReady.set(false, true, state -> {
            this.context = ((Context)((Object)((Object)contextSub.get()))).newContext(HttpService.class);
            STARTUP_LOCK.lock();
            int port = this.context.getOpt(Integer.class, new Object[]{CONFIG_SERVICE_HTTP_PORT}).filter(p -> p > 0).orElseGet(() -> HttpService.nextFreePort(8080));
            this.context.put(CONFIG_SERVICE_HTTP_PORT, port);
            HttpService.handleHttps(this.context);
            try {
                this.server = HttpServer.create(new InetSocketAddress(port), 0);
                this.server.setExecutor(this.context.nano().threadPool());
                this.server.createContext("/", exchange -> {
                    HttpObject request = new HttpObject(exchange);
                    try {
                        AtomicBoolean internalError = new AtomicBoolean(false);
                        this.context.sendEventReturn(EVENT_HTTP_REQUEST, request).peek(HttpService.setError(internalError)).responseOpt(HttpObject.class).ifPresentOrElse(response -> this.sendResponse(exchange, request, (HttpObject)response), () -> this.context.sendEventReturn(EVENT_HTTP_REQUEST_UNHANDLED, request).responseOpt(HttpObject.class).ifPresentOrElse(response -> this.sendResponse(exchange, request, (HttpObject)response), () -> this.sendResponse(exchange, request, new HttpObject().statusCode(internalError.get() ? 500 : 404).bodyT((TypeInfo<?>)((LinkedTypeMap)new LinkedTypeMap().putReturn((Object)"message", (Object)(internalError.get() ? "Internal Server Error" : "Not Found"))).putReturn((Object)"timestamp", (Object)System.currentTimeMillis())).contentType(ContentType.APPLICATION_PROBLEM_JSON))));
                    }
                    catch (Exception e) {
                        this.context.sendEventReturn(Context.EVENT_APP_UNHANDLED, new Unhandled(this.context, request, e)).responseOpt(HttpObject.class).ifPresentOrElse(response -> this.sendResponse(exchange, request, (HttpObject)response), () -> new HttpObject().statusCode(500).body("Internal Server Error".getBytes()).contentType(ContentType.APPLICATION_PROBLEM_JSON));
                    }
                });
                this.server.start();
                this.logger.info(() -> "[{}] starting on port [{}]", this.name(), port);
            }
            catch (IOException e) {
                this.logger.error(e, () -> "[{}] failed to start with port [{}]", this.name(), port);
            }
            finally {
                STARTUP_LOCK.unlock();
            }
        });
    }

    @Override
    public void onEvent(Event event) {
        event.ifPresent(EVENT_HTTP_REQUEST, HttpRequest.class, request -> {
            HttpObject httpObject;
            if (request instanceof HttpObject && (httpObject = (HttpObject)request).exchange() != null) {
                return;
            }
            event.response(((HttpClient)this.context.computeIfAbsent("app_core_context_http_client", value -> new HttpClient())).send((HttpRequest)request));
        });
        super.onEvent(event);
    }

    private static void handleHttps(Context context) {
        Optional crt = context.getOpt(String.class, new Object[]{"app.https.crt.path"});
        Optional key = context.getOpt(String.class, new Object[]{"app.https.key.path"});
        if (!crt.isPresent() || key.isPresent()) {
            // empty if block
        }
    }

    @Override
    public Object onFailure(Event error) {
        return null;
    }

    protected void sendResponse(HttpExchange exchange, HttpObject request, HttpObject response) {
        try {
            byte[] body = response.body();
            int statusCode = response.statusCode() > -1 && response.statusCode() < 600 ? response.statusCode() : 200;
            Optional<String> encoding = request.acceptEncodings().stream().filter(s -> s.equals("gzip") || s.equals("deflate")).findFirst();
            response.headerMap().asMap(String.class, value -> TypeConverter.collectionOf((Object)value, String.class), new Object[0]).forEach((key, value) -> exchange.getResponseHeaders().put((String)key, (List<String>)value));
            response.computedHeaders(false).forEach((key, value) -> exchange.getResponseHeaders().put((String)key, (List<String>)value));
            if (encoding.isPresent()) {
                body = this.encodeBody(body, encoding.get());
            }
            exchange.getResponseHeaders().put("content-encoding", List.of(encoding.orElse("identity")));
            exchange.sendResponseHeaders(statusCode, body.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(body);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected byte[] encodeBody(byte[] body, String contentEncoding) {
        if ("gzip".equalsIgnoreCase(contentEncoding)) {
            return NanoUtils.encodeGzip(body);
        }
        if ("deflate".equalsIgnoreCase(contentEncoding)) {
            return NanoUtils.encodeDeflate(body);
        }
        return body;
    }

    public static int nextFreePort(int startPort) {
        for (int i = 0; i < 1024; ++i) {
            int port = i + Math.max(startPort, 1);
            if (HttpService.isPortInUse(port)) continue;
            return port;
        }
        throw new IllegalStateException("Could not find any free port");
    }

    public static boolean isPortInUse(int portNumber) {
        try {
            new Socket("localhost", portNumber).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Consumer<Event> setError(AtomicBoolean internalError) {
        return event -> {
            if (event.error() != null) {
                internalError.set(true);
            }
        };
    }
}

