/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core.model;

import berlin.yuna.typemap.config.TypeConversionRegister;
import berlin.yuna.typemap.model.ConcurrentTypeMap;
import berlin.yuna.typemap.model.TypeMap;
import java.net.http.HttpClient;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.logging.Formatter;
import java.util.stream.Stream;
import org.nanonative.nano.core.Nano;
import org.nanonative.nano.core.NanoServices;
import org.nanonative.nano.core.NanoThreads;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.core.model.Service;
import org.nanonative.nano.core.model.Unhandled;
import org.nanonative.nano.helper.ExRunnable;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.config.ConfigRegister;
import org.nanonative.nano.helper.event.EventChannelRegister;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.helper.logger.LogFormatRegister;
import org.nanonative.nano.helper.logger.logic.LogQueue;
import org.nanonative.nano.helper.logger.logic.NanoLogger;
import org.nanonative.nano.helper.logger.model.LogLevel;
import org.nanonative.nano.services.http.model.ContentType;
import org.nanonative.nano.services.http.model.HttpMethod;

public class Context
extends ConcurrentTypeMap {
    public static final String CONTEXT_TRACE_ID_KEY = "app_core_context_trace_id";
    public static final String CONTEXT_LOGGER_KEY = "app_core_context_logger";
    public static final String CONTEXT_PARENT_KEY = "app_core_context_parent";
    public static final String CONTEXT_CLASS_KEY = "app_core_context_class";
    public static final String CONTEXT_NANO_KEY = "app_core_context_nano";
    public static final String CONTEXT_LOG_QUEUE_KEY = "app_core_context_log_queue";
    public static final String APP_HELP = ConfigRegister.registerConfig("help", "Lists available config keys");
    public static final String APP_PARAMS = ConfigRegister.registerConfig("app_params_print", "Pints all config values");
    public static final String CONFIG_PROFILES = ConfigRegister.registerConfig("app_profiles", "Active config profiles for the application");
    public static final String CONFIG_LOG_LEVEL = ConfigRegister.registerConfig("app_log_level", "Log level for the application (see " + LogLevel.class.getSimpleName() + ")");
    public static final String CONFIG_LOG_FORMATTER = ConfigRegister.registerConfig("app_log_formatter", "Log formatter (see " + LogFormatRegister.class.getSimpleName() + ")");
    public static final String CONFIG_LOG_QUEUE_SIZE = ConfigRegister.registerConfig("app_log_queue_size", "Log queue size. A full queue means that log messages will start to wait to be executed (see " + LogQueue.class.getSimpleName() + ")");
    public static final String CONFIG_THREAD_POOL_TIMEOUT_MS = ConfigRegister.registerConfig("app_thread_pool_shutdown_timeout_ms", "Timeout for thread pool shutdown in milliseconds (see " + NanoThreads.class.getSimpleName() + ")");
    public static final String CONFIG_PARALLEL_SHUTDOWN = ConfigRegister.registerConfig("app_service_shutdown_parallel", "Enable or disable parallel service shutdown (see " + NanoServices.class.getSimpleName() + "). Enabled = Can increase the shutdown performance on`true`");
    public static final String CONFIG_OOM_SHUTDOWN_THRESHOLD = ConfigRegister.registerConfig("app_oom_shutdown_threshold", "Sets the threshold for heap in percentage to send an `EVENT_APP_OOM`. default = `98`, disabled = `-1`. If the event is unhandled, tha pp will try to shutdown with last resources");
    public static final String CONFIG_ENV_PROD = ConfigRegister.registerConfig("app_env_prod", "Enable or disable behaviour e.g. exit codes. This is useful in prod environments specially on error cases. default = `false`");
    public static final int EVENT_APP_START = EventChannelRegister.registerChannelId("APP_START");
    public static final int EVENT_APP_SHUTDOWN = EventChannelRegister.registerChannelId("APP_SHUTDOWN");
    public static final int EVENT_APP_SERVICE_REGISTER = EventChannelRegister.registerChannelId("APP_SERVICE_REGISTER");
    public static final int EVENT_APP_SERVICE_UNREGISTER = EventChannelRegister.registerChannelId("APP_SERVICE_UNREGISTER");
    public static final int EVENT_APP_SCHEDULER_REGISTER = EventChannelRegister.registerChannelId("APP_SCHEDULER_REGISTER");
    public static final int EVENT_APP_SCHEDULER_UNREGISTER = EventChannelRegister.registerChannelId("APP_SCHEDULER_UNREGISTER");
    public static final int EVENT_APP_UNHANDLED = EventChannelRegister.registerChannelId("EVENT_APP_UNHANDLED");
    public static final int EVENT_APP_ERROR = EventChannelRegister.registerChannelId("EVENT_APP_ERROR");
    public static final int EVENT_APP_OOM = EventChannelRegister.registerChannelId("EVENT_APP_OOM");
    public static final int EVENT_APP_HEARTBEAT = EventChannelRegister.registerChannelId("EVENT_HEARTBEAT");
    public static final int EVENT_CONFIG_CHANGE = EventChannelRegister.registerChannelId("EVENT_CONFIG_CHANGE");
    protected transient Nano nano;

    public static Context createRootContext(Class<?> clazz) {
        return new Context(clazz);
    }

    public Nano nano() {
        if (this.nano == null) {
            this.nano = (Nano)this.get(Nano.class, new Object[]{CONTEXT_NANO_KEY});
        }
        return this.nano;
    }

    public Context parent() {
        return (Context)((Object)this.as(Context.class, new Object[]{CONTEXT_PARENT_KEY}));
    }

    public String traceId() {
        return (String)this.get(String.class, new Object[]{CONTEXT_TRACE_ID_KEY});
    }

    public String traceId(int index) {
        return index < 1 ? this.traceId() : Stream.iterate(Optional.of(this), opt -> opt.flatMap(ctx -> Optional.ofNullable(ctx.parent()))).limit((long)index + 1L).reduce((first, second) -> second).flatMap(ctx -> ctx.map(Context::traceId)).orElse(this.traceId());
    }

    public List<String> traceIds() {
        return Stream.iterate(Optional.of(this), Optional::isPresent, opt -> opt.flatMap(ctx -> Optional.ofNullable(ctx.parent()))).map(opt -> opt.flatMap(ctx -> Optional.ofNullable(ctx.traceId()))).flatMap(Optional::stream).toList();
    }

    public NanoLogger logger() {
        NanoLogger logger = (NanoLogger)this.get(NanoLogger.class, new Object[]{CONTEXT_LOGGER_KEY});
        return logger != null ? logger : this.initLogger();
    }

    public Context newContext(Class<?> clazz) {
        return new Context(this, clazz, false);
    }

    public Context newEmptyContext(Class<?> clazz) {
        return new Context(this, clazz, true);
    }

    public LogLevel logLevel() {
        return this.logger().level();
    }

    public void putAll(Map<?, ?> map) {
        super.putAll(map);
        this.getOpt(NanoLogger.class, new Object[]{CONTEXT_LOGGER_KEY}).ifPresent(logger -> {
            TypeMap typeMap;
            logger.configure(map instanceof TypeMap ? (typeMap = (TypeMap)map) : new TypeMap(map));
        });
    }

    public Context put(Object key, Object value) {
        super.put(key, value != null ? value : "");
        this.getOpt(NanoLogger.class, new Object[]{CONTEXT_LOGGER_KEY}).ifPresent(logger -> logger.configure((TypeMap)new TypeMap().putReturn(key, value)));
        return this;
    }

    public Context putReturn(Object key, Object value) {
        this.put(key, value);
        return this;
    }

    public Context subscribeEvent(int channelId, Consumer<Event> listener) {
        this.nano().subscribeEvent(channelId, listener);
        return this;
    }

    public Context unsubscribeEvent(int channelId, Consumer<Event> listener) {
        this.nano().unsubscribeEvent(channelId, listener);
        return this;
    }

    public Context run(ExRunnable task, long delay, TimeUnit timeUnit) {
        this.nano().run(() -> this, task, delay, timeUnit);
        return this;
    }

    public Context run(ExRunnable task, long delay, long period, TimeUnit unit) {
        return this.run(task, delay, period, unit, () -> false);
    }

    public Context run(ExRunnable task, long delay, long period, TimeUnit unit, BooleanSupplier until) {
        this.nano().run(() -> this, task, delay, period, unit, until);
        return this;
    }

    public Context run(ExRunnable task, LocalTime atTime) {
        this.nano().run(() -> this, task, atTime, () -> false);
        return this;
    }

    public Context run(ExRunnable task, LocalTime atTime, BooleanSupplier until) {
        this.nano().run(() -> this, task, atTime, until);
        return this;
    }

    protected NanoLogger initLogger() {
        NanoLogger logger = new NanoLogger(this.clazz());
        Optional.ofNullable(this.parent()).ifPresentOrElse(p -> logger.level(p.logger().level()).logQueue(p.logger().logQueue()).formatter(p.logger().formatter()), () -> logger.level(this.getOpt(LogLevel.class, new Object[]{CONFIG_LOG_LEVEL}).orElse(LogLevel.INFO)).formatter(this.getOpt(Formatter.class, new Object[]{CONFIG_LOG_FORMATTER}).orElseGet(() -> LogFormatRegister.getLogFormatter("console"))));
        this.put(CONTEXT_LOGGER_KEY, logger);
        return logger;
    }

    public final Context run(ExRunnable ... runnable) {
        this.runReturn(runnable);
        return this;
    }

    public final Context runHandled(Consumer<Unhandled> onFailure, ExRunnable ... runnable) {
        this.runReturnHandled(onFailure, runnable);
        return this;
    }

    public Context run(Service ... services) {
        this.runReturn(services);
        return this;
    }

    public final NanoThread[] runReturn(ExRunnable ... runnable) {
        return (NanoThread[])Arrays.stream(runnable).map(task -> new NanoThread(this).run(this.nano() == null ? null : this.nano().threadPool(), () -> this.nano() == null ? null : this.nano().contextEmpty(this.clazz()), (ExRunnable)task)).toArray(NanoThread[]::new);
    }

    public final NanoThread[] runReturnHandled(Consumer<Unhandled> onFailure, ExRunnable ... runnable) {
        return (NanoThread[])Arrays.stream(runnable).map(task -> new NanoThread(this).onComplete((thread, error) -> {
            if (error != null) {
                onFailure.accept(new Unhandled(this, thread, (Throwable)error));
            }
        }).run(this.nano() == null ? null : this.nano().threadPool(), () -> this.nano() == null ? null : this.nano().contextEmpty(this.clazz()), (ExRunnable)task)).toArray(NanoThread[]::new);
    }

    public NanoThread[] runReturn(Service ... services) {
        try {
            return Service.threadsOf(this, services);
        }
        catch (Exception exception) {
            this.sendEventError(services.length == 1 ? services[0] : services, exception);
            Thread.currentThread().interrupt();
            return new NanoThread[0];
        }
    }

    public final Context runAwait(ExRunnable ... runnable) {
        NanoThread.waitFor(this.runReturn(runnable));
        return this;
    }

    public final Context runAwaitHandled(Consumer<Unhandled> onFailure, ExRunnable ... runnable) {
        NanoThread.waitFor(this.runReturnHandled(onFailure, runnable));
        return this;
    }

    public Context runAwait(Service ... services) {
        this.runAwaitReturn(services);
        return this;
    }

    public final NanoThread[] runAwaitReturn(ExRunnable ... runnable) {
        return NanoThread.waitFor(this.runReturn(runnable));
    }

    public final NanoThread[] runAwaitReturnHandled(Consumer<Unhandled> onFailure, ExRunnable ... runnable) {
        return NanoThread.waitFor(this.runReturnHandled(onFailure, runnable));
    }

    public NanoThread[] runAwaitReturn(Service ... services) {
        return NanoThread.waitFor(this.runReturn(services));
    }

    public Context sendEventError(Object payload, Throwable throwable) {
        Event evt;
        Event event;
        Event event2 = event = payload instanceof Event ? (evt = (Event)payload) : new Event(EVENT_APP_ERROR, this, payload, null);
        if (event.channelId() != EVENT_APP_UNHANDLED) {
            this.nano().sendEventSameThread(event.cache("app_original_event_channel_id", event.channelId()).channelId(EVENT_APP_UNHANDLED).error(throwable), false);
            if (!event.isAcknowledged()) {
                this.logger().error(throwable, () -> "Event [{}] went rogue.", event.nameOrg());
            }
        } else {
            this.logger().error(throwable, () -> "Event [{}] went rogue.", event.nameOrg());
        }
        return this;
    }

    public Context sendEventError(Event event, Service service, Throwable throwable) {
        if (event.channelId() == EVENT_APP_UNHANDLED) {
            event.context().logger().error(throwable, () -> "Unhandled event [{}] service [{}]", event.nameOrg(), service.name());
        }
        if (service.onFailure(event.error(throwable)) == null) {
            event.context().sendEventError(event, throwable);
        }
        return this;
    }

    public Context sendEvent(int channelId, Object payload) {
        this.nano().sendEvent(channelId, this, payload, (Consumer)null, false);
        return this;
    }

    public Context sendEvent(int channelId, Object payload, Consumer<Object> responseListener) {
        this.nano().sendEvent(channelId, this, payload, (Consumer)responseListener, false);
        return this;
    }

    public Context broadcastEvent(int channelId, Object payload) {
        this.broadcastEvent(channelId, payload, null);
        return this;
    }

    public Context broadcastEvent(int channelId, Object payload, Consumer<Object> responseListener) {
        this.nano().sendEvent(channelId, this, payload, (Consumer)responseListener, true);
        return this;
    }

    public Event sendEventReturn(int channelId, Object payload) {
        return this.sendEventReturn(channelId, payload, null);
    }

    public Event sendEventReturn(int channelId, Object payload, Consumer<Object> responseListener) {
        return this.nano().sendEventReturn(channelId, this, payload, responseListener, false);
    }

    public Event broadcastEventReturn(int channelId, Object payload) {
        return this.broadcastEventReturn(channelId, payload, null);
    }

    public Event broadcastEventReturn(int channelId, Object payload, Consumer<Object> responseListener) {
        return this.nano().sendEventReturn(channelId, this, payload, responseListener, true);
    }

    public int registerChannelId(String channelName) {
        return EventChannelRegister.registerChannelId(channelName);
    }

    public String eventNameOf(int channelId) {
        return EventChannelRegister.eventNameOf(channelId);
    }

    public Optional<Integer> channelIdOf(String channelName) {
        return EventChannelRegister.eventIdOf(channelName);
    }

    public <S extends Service> S service(Class<S> serviceClass) {
        return this.nano().service(serviceClass);
    }

    public <S extends Service> S service(Class<S> serviceClass, long timeoutMs) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < timeoutMs) {
            S service = this.service(serviceClass);
            if (service != null) {
                return service;
            }
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return null;
    }

    public <S extends Service> List<S> services(Class<S> serviceClass) {
        return this.nano().services(serviceClass);
    }

    public List<Service> services() {
        return this.nano().services();
    }

    protected Context(Class<?> clazz) {
        this(null, clazz, false);
    }

    protected Context(Context parent, Class<?> clazz) {
        this(parent, clazz, false);
    }

    protected Context(Context parent, Class<?> clazz, boolean empty) {
        super((Map)((Object)(empty ? null : parent)));
        Class<?> resolvedClass = clazz != null ? clazz : (parent == null ? Context.class : parent.clazz());
        this.put(CONTEXT_NANO_KEY, parent != null ? parent.as(Nano.class, new Object[]{CONTEXT_NANO_KEY}) : null);
        this.put(CONTEXT_CLASS_KEY, resolvedClass);
        this.put(CONTEXT_TRACE_ID_KEY, resolvedClass.getSimpleName() + "/" + UUID.randomUUID().toString().replace("-", ""));
        if (parent != null) {
            this.put(CONTEXT_PARENT_KEY, (Object)parent);
        }
    }

    private Class<?> clazz() {
        return this.getOpt(Class.class, new Object[]{CONTEXT_CLASS_KEY}).orElse(Context.class);
    }

    public void tryExecute(ExRunnable operation) {
        this.tryExecute(operation, null);
    }

    public void tryExecute(ExRunnable operation, Consumer<Throwable> consumer) {
        NanoUtils.tryExecute(() -> this, operation, consumer);
    }

    public String toString() {
        return "Context{size=" + this.size() + ", loglevel=" + String.valueOf(this.getOpt(NanoLogger.class, new Object[]{CONTEXT_LOGGER_KEY}).map(NanoLogger::level).orElse(null)) + ", logQueue=" + this.getOpt(NanoLogger.class, new Object[]{CONTEXT_LOGGER_KEY}).map(NanoLogger::logQueue).isPresent() + "}";
    }

    static {
        TypeConversionRegister.registerTypeConvert(String.class, Formatter.class, LogFormatRegister::getLogFormatter);
        TypeConversionRegister.registerTypeConvert(String.class, LogLevel.class, LogLevel::nanoLogLevelOf);
        TypeConversionRegister.registerTypeConvert(LogLevel.class, String.class, Enum::name);
        TypeConversionRegister.registerTypeConvert(ContentType.class, String.class, Enum::name);
        TypeConversionRegister.registerTypeConvert(String.class, ContentType.class, ContentType::fromValue);
        TypeConversionRegister.registerTypeConvert(HttpMethod.class, String.class, Enum::name);
        TypeConversionRegister.registerTypeConvert(String.class, HttpMethod.class, HttpMethod::valueOf);
        TypeConversionRegister.registerTypeConvert(String.class, HttpClient.Version.class, string -> {
            if ("1".equals(string) || HttpClient.Version.HTTP_1_1.toString().equals(string)) {
                return HttpClient.Version.HTTP_1_1;
            }
            if ("2".equals(string) || HttpClient.Version.HTTP_2.toString().equals(string)) {
                return HttpClient.Version.HTTP_2;
            }
            return null;
        });
    }
}

