/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.helper.logger.model;

import java.util.Arrays;
import java.util.logging.Level;
import org.nanonative.nano.helper.NanoUtils;

public enum LogLevel {
    OFF(Level.OFF),
    FATAL(Level.SEVERE),
    ERROR(Level.SEVERE),
    WARN(Level.WARNING),
    INFO(Level.INFO),
    DEBUG(Level.FINE),
    TRACE(Level.FINER),
    ALL(Level.ALL);

    private final Level javaLogLevel;

    private LogLevel(Level javaLogLevel) {
        this.javaLogLevel = javaLogLevel;
    }

    public Level toJavaLogLevel() {
        return this.javaLogLevel;
    }

    public static LogLevel nanoLogLevelOf(Level level) {
        return Arrays.stream(LogLevel.values()).filter(simpleLogLevel -> simpleLogLevel.javaLogLevel == level).findFirst().orElse(OFF);
    }

    public static LogLevel nanoLogLevelOf(String level) {
        if (NanoUtils.hasText(level)) {
            for (LogLevel logLevel : LogLevel.values()) {
                if (!logLevel.toString().equalsIgnoreCase(level)) continue;
                return logLevel;
            }
            for (LogLevel logLevel : LogLevel.values()) {
                if (!logLevel.javaLogLevel.toString().equalsIgnoreCase(level)) continue;
                return logLevel;
            }
        }
        return ALL;
    }
}

