/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.services.http.model;

import berlin.yuna.typemap.logic.JsonDecoder;
import berlin.yuna.typemap.logic.TypeConverter;
import berlin.yuna.typemap.logic.XmlDecoder;
import berlin.yuna.typemap.model.LinkedTypeMap;
import berlin.yuna.typemap.model.TypeInfo;
import berlin.yuna.typemap.model.TypeList;
import berlin.yuna.typemap.model.TypeMap;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.Inflater;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.services.http.logic.HttpClient;
import org.nanonative.nano.services.http.model.ContentType;
import org.nanonative.nano.services.http.model.HttpMethod;

public class HttpObject
extends HttpRequest {
    protected HttpMethod method;
    protected String path;
    protected byte[] body;
    protected TypeMap headers;
    protected TypeMap queryParams;
    protected TypeMap pathParams;
    protected int statusCode = -1;
    protected Long timeoutMs;
    protected final HttpExchange exchange;
    public static final String HTTP_EXCEPTION_HEADER = "#throwable#";
    public static final DateTimeFormatter HTTP_DATE_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.ENGLISH);
    public static final String[] USER_AGENT_BROWSERS = new String[]{"chrome", "firefox", "safari", "opera", "edge", "ie", "trident", "vivaldi", "browser", "mozilla", "webkit"};
    public static final String[] USER_AGENT_MOBILE = new String[]{"mobile", "ios", "ipad", "ipod", "htc", "nokia", "wii", "psp", "windows phone", "blackberry", "webos", "opera mini", "opera mobi", "kindle", "silk", "puffin", "ucbrowser", "ucweb", "baidubrowser", "baiduboxapp", "samsungbrowser", "miuibrowser", "miuib"};
    public static final String CONTEXT_HTTP_CLIENT_KEY = "app_core_context_http_client";
    public static final List<String> JAVA_MANAGED_HEADERS = List.of("content-length", "connection", "host", "transfer-encoding");

    public HttpObject(HttpExchange exchange) {
        this.exchange = exchange;
        if (exchange != null) {
            this.path(exchange.getRequestURI().getPath());
            this.methodType(exchange.getRequestMethod());
            this.headerMap(exchange.getRequestHeaders());
        }
    }

    public HttpObject() {
        this.exchange = null;
    }

    public HttpMethod methodType() {
        return this.method;
    }

    public HttpObject methodType(String method) {
        return this.methodType(HttpMethod.httpMethodOf(method));
    }

    public HttpObject methodType(HttpMethod method) {
        this.method = method;
        return this;
    }

    public ContentType contentType() {
        return this.contentTypes().getFirst();
    }

    public List<ContentType> contentTypes() {
        List<ContentType> contentTypes = HttpObject.splitHeaderValue(this.headerMap().asList(String.class, new Object[]{"content-type"}), ContentType::fromValue);
        return contentTypes.isEmpty() ? List.of(HttpObject.guessContentType(this, this.body())) : contentTypes;
    }

    public HttpObject contentType(String ... contentType) {
        return this.contentType((Charset)null, contentType);
    }

    public HttpObject contentType(ContentType ... contentType) {
        return this.contentType((Charset)null, contentType);
    }

    public HttpObject contentType(Charset charset, String ... contentType) {
        return this.contentType(charset, (ContentType[])Arrays.stream(contentType).map(ContentType::fromValue).filter(Objects::nonNull).toArray(ContentType[]::new));
    }

    public HttpObject contentType(Charset charset, ContentType ... contentType) {
        this.headerMap().put((Object)"content-type", (Object)(Arrays.stream(contentType).filter(Objects::nonNull).map(ContentType::value).collect(Collectors.joining(", ")) + (String)(charset == null ? "" : "; charset=" + charset.name())));
        return this;
    }

    public ContentType accept() {
        List<ContentType> result = this.accepts();
        return result.isEmpty() ? null : result.getFirst();
    }

    public List<ContentType> accepts() {
        return HttpObject.splitHeaderValue(this.headerMap().asList(String.class, new Object[]{"accept"}), ContentType::fromValue);
    }

    public HttpObject accept(String ... contentType) {
        this.headerMap().put((Object)"accept", (Object)Arrays.stream(contentType).map(ContentType::fromValue).filter(Objects::nonNull).map(ContentType::value).collect(Collectors.joining(", ")));
        return this;
    }

    public HttpObject accept(ContentType ... contentType) {
        this.headerMap().put((Object)"accept", (Object)Arrays.stream(contentType).filter(Objects::nonNull).map(ContentType::value).collect(Collectors.joining(", ")));
        return this;
    }

    public boolean hasAccept(String ... contentTypes) {
        List<ContentType> result = this.accepts();
        return Arrays.stream(contentTypes).map(ContentType::fromValue).allMatch(result::contains);
    }

    public boolean hasAccept(ContentType ... contentTypes) {
        List<ContentType> result = this.accepts();
        return Arrays.stream(contentTypes).allMatch(result::contains);
    }

    public String acceptEncoding() {
        List<String> result = this.acceptEncodings();
        return result.isEmpty() ? null : result.getFirst();
    }

    public List<String> acceptEncodings() {
        return HttpObject.splitHeaderValue(this.headerMap().asList(String.class, new Object[]{"accept-encoding"}), v -> v);
    }

    public boolean hasAcceptEncoding(String ... encodings) {
        List<String> result = HttpObject.splitHeaderValue(this.headerMap().asList(String.class, new Object[]{"accept-encoding"}), v -> v);
        return Arrays.stream(encodings).allMatch(result::contains);
    }

    public String contentEncoding() {
        List<String> result = this.acceptEncodings();
        return result.isEmpty() ? null : result.getFirst();
    }

    public List<String> contentEncodings() {
        return HttpObject.splitHeaderValue(this.headerMap().asList(String.class, new Object[]{"content-encoding"}), v -> v);
    }

    public boolean hasContentEncoding(String ... encodings) {
        List<String> result = HttpObject.splitHeaderValue(this.headerMap().asList(String.class, new Object[]{"content-encoding"}), v -> v);
        return Arrays.stream(encodings).allMatch(result::contains);
    }

    public Locale acceptLanguage() {
        return this.acceptLanguages().getFirst();
    }

    public List<Locale> acceptLanguages() {
        List<Locale> result = HttpObject.splitHeaderValue(this.headerMap().asList(String.class, new Object[]{"accept-language"}), Locale::forLanguageTag);
        return result.isEmpty() ? List.of(Locale.ENGLISH) : result;
    }

    public HttpObject acceptLanguages(Locale ... locales) {
        if (locales == null || locales.length == 0) {
            this.headerMap().remove((Object)"accept-language");
        } else {
            String acceptLanguageValue = IntStream.range(0, locales.length).mapToObj(i -> locales[i].toLanguageTag() + ";q=" + Math.max(0.1, 1.1 - ((double)i + 1.0) / 10.0)).collect(Collectors.joining(", "));
            this.headerMap().put((Object)"accept-language", (Object)acceptLanguageValue);
        }
        return this;
    }

    public String path() {
        return this.path;
    }

    public HttpObject path(String path) {
        String[] parts = path == null ? new String[]{} : NanoUtils.split(path, "?");
        String string = this.path = parts.length > 0 ? HttpObject.removeLast(parts[0], "/") : null;
        if (parts.length > 1) {
            this.queryParams = this.queryParamsOf(parts[1]);
        }
        return this;
    }

    public String bodyAsString() {
        return new String(this.body(), this.encoding());
    }

    public TypeInfo<?> bodyAsJson() {
        return JsonDecoder.jsonTypeOf((String)this.bodyAsString());
    }

    public TypeInfo<?> bodyAsXml() {
        return XmlDecoder.xmlTypeOf((String)this.bodyAsString());
    }

    public byte[] body() {
        if (this.body == null && this.exchange != null) {
            try (InputStream bodyStream = this.exchange.getRequestBody();){
                this.body = bodyStream.readAllBytes();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.body == null) {
            this.body(new byte[0]);
        }
        return this.body;
    }

    public HttpObject bodyT(TypeInfo<?> body) {
        return this.body(body.toJson().getBytes(this.encoding()));
    }

    public HttpObject body(Collection<?> body) {
        TypeList typeList;
        if (body instanceof TypeInfo) {
            TypeInfo info = (TypeInfo)body;
            typeList = info;
        } else {
            typeList = new TypeList(body);
        }
        return this.bodyT((TypeInfo<?>)typeList);
    }

    public HttpObject body(Map<?, ?> body) {
        LinkedTypeMap linkedTypeMap;
        if (body instanceof TypeInfo) {
            TypeInfo info = (TypeInfo)body;
            linkedTypeMap = info;
        } else {
            linkedTypeMap = new LinkedTypeMap(body);
        }
        return this.bodyT((TypeInfo<?>)linkedTypeMap);
    }

    public HttpObject body(String body) {
        return this.body(body.getBytes(this.encoding()));
    }

    public HttpObject body(byte[] body) {
        this.body = body.length > 2 ? ((body[0] & 0xFF) == 31 && (body[1] & 0xFF) == 139 ? NanoUtils.decodeGzip(body) : (this.isZipCompressed(body) ? NanoUtils.decodeZip(body) : (this.isDeflateCompressed(body) ? NanoUtils.decodeDeflate(body) : body))) : body;
        return this;
    }

    public TypeMap queryParams() {
        if (this.queryParams == null && this.exchange != null) {
            this.queryParams = Optional.ofNullable(this.fromExchange(httpExchange -> this.queryParamsOf(httpExchange.getRequestURI().getQuery()))).orElseGet(TypeMap::new);
        }
        if (this.queryParams == null) {
            this.queryParams = new TypeMap();
        }
        return this.queryParams;
    }

    public boolean containsQueryParam(String key) {
        return this.queryParams().containsKey((Object)key);
    }

    public String queryParam(String key) {
        return this.queryParams().asString(new Object[]{key});
    }

    public boolean pathMatch(String expression) {
        if (this.path == null || expression == null) {
            return false;
        }
        String[] partsToMatch = NanoUtils.split(HttpObject.removeLast(expression, "/"), "/");
        String[] parts = NanoUtils.split(this.path, "/");
        this.pathParams().clear();
        for (int i = 0; i < partsToMatch.length; ++i) {
            if ("*".equals(partsToMatch[i])) continue;
            if ("**".equals(partsToMatch[i])) {
                return true;
            }
            if (parts.length - 1 < i) {
                return false;
            }
            if (partsToMatch[i].equals(parts[i])) continue;
            if (partsToMatch[i].startsWith("{")) {
                String key = partsToMatch[i].substring(1, partsToMatch[i].length() - 1);
                this.pathParams.put((Object)key, (Object)parts[i]);
                continue;
            }
            return false;
        }
        return true;
    }

    public TypeMap pathParams() {
        if (this.pathParams == null) {
            this.pathParams = new TypeMap();
        }
        return this.pathParams;
    }

    public String pathParam(String key) {
        return this.pathParams().asString(new Object[]{key});
    }

    public String header(String key) {
        return key == null || this.headers == null ? null : this.headers.asString(new Object[]{key.toLowerCase()});
    }

    public boolean containsHeader(String key) {
        return key != null && this.headers != null && this.headers.containsKey((Object)key.toLowerCase());
    }

    public String userAgent() {
        return this.header("user-agent");
    }

    public HttpObject userAgent(String userAgent) {
        this.headerMap().put((Object)"user-agent", (Object)userAgent);
        return this;
    }

    public String authToken() {
        return this.authToken(0);
    }

    public String authToken(int index) {
        String[] result = this.authTokens();
        return index < result.length ? result[index] : null;
    }

    public String[] authTokens() {
        return Optional.ofNullable(this.header("authorization")).map(value -> {
            if (value.startsWith("Bearer ")) {
                return new String[]{value.substring("Bearer ".length())};
            }
            if (value.startsWith("Basic ")) {
                String[] stringArray;
                String decode = new String(Base64.getDecoder().decode(value.substring("Basic ".length())));
                if (decode.contains(":")) {
                    stringArray = NanoUtils.split(decode, ":");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = decode;
                }
                return stringArray;
            }
            return new String[]{value};
        }).orElse(new String[0]);
    }

    public HttpExchange exchange() {
        return this.exchange;
    }

    public HttpObject statusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public TypeMap headerMap() {
        if (this.headers == null) {
            this.headers = new TypeMap();
        }
        return this.headers;
    }

    public Map<String, List<String>> computedHeaders(boolean isRequest) {
        TypeMap result = this.headerMap();
        if (isRequest) {
            result.putIfAbsent((Object)"accept-encoding", (Object)"gzip, deflate");
            result.computeIfAbsent((Object)"accept", fallback -> ContentType.WILDCARD.value());
        }
        result.putIfAbsent((Object)"cache-control", (Object)"no-cache");
        result.computeIfAbsent((Object)"content-type", value -> this.contentTypes().stream().map(ContentType::value).toList());
        result.computeIfAbsent((Object)"content-length", value -> this.body().length);
        result.computeIfAbsent((Object)"date", value -> HTTP_DATE_FORMATTER.format(ZonedDateTime.now().withZoneSameInstant(ZoneOffset.UTC)));
        result.computeIfAbsent((Object)"user-agent", fallback -> NanoUtils.generateNanoName("%s/%s (%s %s)"));
        return result.asMap(String.class, value -> TypeConverter.collectionOf((Object)value, String.class), new Object[0]);
    }

    public HttpObject sizeRequest(boolean sizeRequest) {
        if (sizeRequest) {
            this.headerMap().put((Object)"range", (Object)"bytes=0-0");
        }
        if (!sizeRequest) {
            this.headerMap().remove((Object)"range");
        }
        return this;
    }

    public boolean sizeRequest() {
        return "bytes=0-0".equals(this.headerMap().get((Object)"range"));
    }

    public long size() {
        return Math.max((long)this.body().length, this.headers == null ? -1L : this.headers.getOpt(String.class, new Object[]{"content-range"}).map(s -> s.replace("bytes 0-0/", "")).map(s -> (Long)TypeConverter.convertObj((Object)s, Long.class)).orElse(-1L));
    }

    public HttpObject headerMap(Headers headers) {
        this.headers = HttpObject.convertHeaders(headers);
        return this;
    }

    public HttpObject headerMap(Map<String, ?> headers) {
        this.headers = HttpObject.convertHeaders(headers);
        return this;
    }

    public HttpObject header(String key, Object value) {
        if (key != null && value != null) {
            this.headerMap().put((Object)key.toLowerCase(), value);
        }
        return this;
    }

    protected TypeMap queryParamsOf(String query) {
        if (this.queryParams == null) {
            this.queryParams = Optional.ofNullable(query).map(q -> {
                TypeMap result = new TypeMap();
                Arrays.stream(NanoUtils.split(q, "&")).map(param -> NanoUtils.split(param, "=")).forEach(keyValue -> {
                    String key = URLDecoder.decode(keyValue[0], StandardCharsets.UTF_8);
                    String value = ((String[])keyValue).length > 1 ? URLDecoder.decode(keyValue[1], StandardCharsets.UTF_8) : "";
                    result.put((Object)key, (Object)value);
                });
                return result;
            }).orElseGet(TypeMap::new);
        }
        return this.queryParams;
    }

    @Override
    public Optional<HttpRequest.BodyPublisher> bodyPublisher() {
        return Optional.of(HttpRequest.BodyPublishers.ofByteArray(this.body()));
    }

    @Override
    public String method() {
        return this.method == null ? HttpMethod.GET.name() : this.method.name();
    }

    @Override
    public Optional<Duration> timeout() {
        return this.timeoutMs == null ? Optional.empty() : Optional.of(Duration.ofMillis(this.timeoutMs));
    }

    public HttpObject timeout(long timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    @Override
    public boolean expectContinue() {
        return false;
    }

    @Override
    public URI uri() {
        return URI.create(this.path() == null ? "" : this.path());
    }

    @Override
    public Optional<HttpClient.Version> version() {
        return Optional.empty();
    }

    @Override
    public HttpHeaders headers() {
        Map<String, List<String>> map = this.computedHeaders(true);
        JAVA_MANAGED_HEADERS.forEach(map::remove);
        return HttpHeaders.of(map, (k, v) -> true);
    }

    public HttpObject response() {
        return new HttpObject();
    }

    public HttpObject corsResponse() {
        return this.response(true);
    }

    public HttpObject response(boolean cors) {
        return cors ? this.corsResponse(null) : new HttpObject();
    }

    public HttpObject corsResponse(String origin) {
        return this.corsResponse(origin, null);
    }

    public HttpObject corsResponse(String origin, String methods) {
        return this.corsResponse(origin, methods, null);
    }

    public HttpObject corsResponse(String origin, String methods, String headers) {
        return this.corsResponse(origin, methods, headers, -1);
    }

    public HttpObject corsResponse(String origin, String methods, String headers, int maxAge) {
        return this.corsResponse(origin, methods, headers, maxAge, false);
    }

    public HttpObject corsResponse(String origin, String methods, String headers, int maxAge, boolean credentials) {
        String resultOrigin = this.origin(origin, credentials);
        return new HttpObject().header("access-control-allow-origin", resultOrigin).header("access-control-allow-methods", NanoUtils.hasText(methods) ? methods : this.headerMap().getOpt(String.class, new Object[]{"access-control-request-method"}).orElse(this.method())).header("access-control-allow-headers", NanoUtils.hasText(headers) ? headers : this.headerMap().getOpt(String.class, new Object[]{"access-control-request-headers"}).orElse("Content-Type, Accept, Authorization, X-Requested-With")).header("access-control-allow-credentials", String.valueOf(credentials)).header("access-control-max-age", String.valueOf(maxAge > 0 ? maxAge : 86400)).statusCode(resultOrigin.equals("null") ? 403 : (this.isMethodOptions() ? 204 : 200)).header("vary", "Origin");
    }

    public String origin() {
        return this.origin(null, false);
    }

    public String origin(String origin, boolean credentials) {
        String requestOrigin = this.headerMap().getOpt(String.class, new Object[]{"origin"}).or(() -> this.headerMap().getOpt(String.class, new Object[]{"host"})).orElseGet(() -> credentials ? "null" : "*");
        return !(!NanoUtils.hasText(origin) || credentials && origin.equals("*")) ? (origin.equals("*") ? origin : Arrays.stream(origin.split(",")).map(String::trim).filter(requestOrigin::equalsIgnoreCase).findFirst().orElse("null")) : requestOrigin;
    }

    public HttpObject origin(String origin) {
        if (NanoUtils.hasText(origin)) {
            this.headerMap().put((Object)"origin", (Object)origin);
        } else {
            this.headerMap().remove((Object)"origin");
        }
        return this;
    }

    public Event respond(Event event) {
        return event.response(this);
    }

    public HttpObject send(Context context) {
        return this.send(context, null);
    }

    public HttpObject send(Context context, Consumer<HttpObject> callback) {
        if (context == null) {
            return null;
        }
        return ((HttpClient)context.computeIfAbsent(CONTEXT_HTTP_CLIENT_KEY, value -> new HttpClient(context))).send(this, callback);
    }

    public boolean hasFailed() {
        return !this.is2xxSuccessful() || this.headers != null && (this.headers.containsValue((Object)ContentType.APPLICATION_PROBLEM_JSON.value()) || this.headers.containsValue((Object)ContentType.APPLICATION_PROBLEM_XML.value()) || this.headers.containsValue((Object)HTTP_EXCEPTION_HEADER));
    }

    public Throwable failure() {
        return this.headers == null ? null : (Throwable)this.headers.as(Throwable.class, new Object[]{HTTP_EXCEPTION_HEADER});
    }

    public HttpObject successOrElse(Consumer<HttpObject> onSuccess, Consumer<HttpObject> onFailure) {
        if (this.hasFailed()) {
            onFailure.accept(this);
        } else {
            onSuccess.accept(this);
        }
        return this;
    }

    public HttpObject failure(int statusCode, Throwable throwable) {
        this.header(HTTP_EXCEPTION_HEADER, throwable);
        this.header("content-type", ContentType.APPLICATION_PROBLEM_JSON.value());
        this.statusCode(statusCode);
        this.body((Map<?, ?>)((TypeMap)((TypeMap)((TypeMap)((TypeMap)((TypeMap)((TypeMap)new TypeMap().putReturn((Object)"id", (Object)NanoUtils.generateNanoName("%s_%s_%s_%s").toLowerCase().replace(".", "").replace(" ", "_"))).putReturn((Object)"type", (Object)"https://github.com/nanonative/nano")).putReturn((Object)"title", (Object)Optional.ofNullable(throwable.getMessage()).orElse(throwable.getClass().getSimpleName()))).putReturn((Object)"status", (Object)statusCode)).putReturn((Object)"instance", (Object)this.path())).putReturn((Object)"detail", TypeConverter.convertObj((Object)throwable, String.class))).putReturn((Object)"timestamp", (Object)Instant.now().toEpochMilli()));
        return this;
    }

    public boolean isFrontendCall() {
        return Optional.ofNullable(this.headers).map(header -> header.asString(new Object[]{"user-agent"})).map(String::toLowerCase).filter(agent -> Stream.of(USER_AGENT_BROWSERS).anyMatch(agent::contains)).isPresent();
    }

    public boolean isMobileCall() {
        return Optional.ofNullable(this.headers).map(header -> header.asString(new Object[]{"user-agent"})).map(String::toLowerCase).filter(agent -> Stream.of(USER_AGENT_MOBILE).anyMatch(agent::contains)).isPresent();
    }

    public String host() {
        return Optional.ofNullable(this.fromExchange(httpExchange -> httpExchange.getRemoteAddress().getHostName())).or(() -> Optional.ofNullable(this.headers).map(header -> header.asString(new Object[]{"host"})).map(value -> NanoUtils.split(value, ":")[0])).orElse(null);
    }

    public int port() {
        return Optional.ofNullable(this.fromExchange(httpExchange -> httpExchange.getRemoteAddress().getPort())).or(() -> Optional.ofNullable(this.headers).map(header -> header.asString(new Object[]{"host"})).map(value -> NanoUtils.split(value, ":")).filter(a -> ((String[])a).length > 1).map(a -> a[1]).map(s -> (Integer)TypeConverter.convertObj((Object)s, Integer.class))).orElse(-1);
    }

    public InetAddress address() {
        return this.fromExchange(httpExchange -> httpExchange.getRemoteAddress().getAddress());
    }

    public String protocol() {
        return this.fromExchange(HttpExchange::getProtocol);
    }

    public Charset encoding() {
        return Arrays.stream(Optional.ofNullable(this.header("content-type")).map(s -> NanoUtils.split(s, ";")).orElse(new String[0])).map(String::trim).filter(part -> part.toLowerCase().startsWith("charset=")).map(charset -> charset.substring(8).trim()).map(charset -> (Charset)TypeConverter.convertObj((Object)charset, Charset.class)).filter(Objects::nonNull).findFirst().orElse(Charset.defaultCharset());
    }

    public boolean hasContentType(String ... contentTypes) {
        List<ContentType> result = this.contentTypes();
        return Arrays.stream(contentTypes).map(ContentType::fromValue).allMatch(result::contains);
    }

    public boolean hasContentType(ContentType ... contentTypes) {
        List<ContentType> result = this.contentTypes();
        return Arrays.stream(contentTypes).allMatch(result::contains);
    }

    public boolean hasContentType(ContentType contentType) {
        return this.contentTypes().contains((Object)contentType);
    }

    public boolean isMethodGet() {
        return HttpMethod.GET.equals((Object)this.method);
    }

    public boolean isMethodPost() {
        return HttpMethod.POST.equals((Object)this.method);
    }

    public boolean isMethodPut() {
        return HttpMethod.PUT.equals((Object)this.method);
    }

    public boolean isMethodHead() {
        return HttpMethod.HEAD.equals((Object)this.method);
    }

    public boolean isMethodPatch() {
        return HttpMethod.PATCH.equals((Object)this.method);
    }

    public boolean isMethodDelete() {
        return HttpMethod.DELETE.equals((Object)this.method);
    }

    public boolean isMethodOptions() {
        return HttpMethod.OPTIONS.equals((Object)this.method);
    }

    public boolean isMethodTrace() {
        return HttpMethod.TRACE.equals((Object)this.method);
    }

    public boolean hasContentTypeJson() {
        return this.hasContentType(ContentType.APPLICATION_JSON);
    }

    public boolean hasContentTypeXml() {
        return this.hasContentType(ContentType.APPLICATION_XML);
    }

    public boolean hasContentTypeXmlSoap() {
        return this.hasContentType(ContentType.APPLICATION_SOAP_XML);
    }

    public boolean hasContentTypeOctetStream() {
        return this.hasContentType(ContentType.APPLICATION_OCTET_STREAM);
    }

    public boolean hasContentTypePdf() {
        return this.hasContentType(ContentType.APPLICATION_PDF);
    }

    public boolean hasContentTypeFormUrlEncoded() {
        return this.hasContentType(ContentType.APPLICATION_FORM_URLENCODED);
    }

    public boolean hasContentTypeMultiPartFormData() {
        return this.hasContentType(ContentType.MULTIPART_FORM_DATA);
    }

    public boolean hasContentTypePlainText() {
        return this.hasContentType(ContentType.TEXT_PLAIN);
    }

    public boolean hasContentTypeHtml() {
        return this.hasContentType(ContentType.TEXT_HTML);
    }

    public boolean hasContentTypeJpeg() {
        return this.hasContentType(ContentType.IMAGE_JPEG);
    }

    public boolean hasContentTypePng() {
        return this.hasContentType(ContentType.IMAGE_PNG);
    }

    public boolean hasContentTypeGif() {
        return this.hasContentType(ContentType.IMAGE_GIF);
    }

    public boolean hasContentTypeMpeg() {
        return this.hasContentType(ContentType.AUDIO_MPEG);
    }

    public boolean hasContentTypeMp4() {
        return this.hasContentType(ContentType.VIDEO_MP4);
    }

    public boolean hasAcceptJson() {
        return this.hasContentType(ContentType.APPLICATION_JSON);
    }

    public boolean hasAcceptXml() {
        return this.hasContentType(ContentType.APPLICATION_XML);
    }

    public boolean hasAcceptXmlSoap() {
        return this.hasContentType(ContentType.APPLICATION_SOAP_XML);
    }

    public boolean hasAcceptOctetStream() {
        return this.hasContentType(ContentType.APPLICATION_OCTET_STREAM);
    }

    public boolean hasAcceptPdf() {
        return this.hasContentType(ContentType.APPLICATION_PDF);
    }

    public boolean hasAcceptFormUrlEncoded() {
        return this.hasContentType(ContentType.APPLICATION_FORM_URLENCODED);
    }

    public boolean hasAcceptMultiPartFormData() {
        return this.hasContentType(ContentType.MULTIPART_FORM_DATA);
    }

    public boolean hasAcceptPlainText() {
        return this.hasContentType(ContentType.TEXT_PLAIN);
    }

    public boolean hasAcceptHtml() {
        return this.hasContentType(ContentType.TEXT_HTML);
    }

    public boolean hasAcceptJpeg() {
        return this.hasContentType(ContentType.IMAGE_JPEG);
    }

    public boolean hasAcceptPng() {
        return this.hasContentType(ContentType.IMAGE_PNG);
    }

    public boolean hasAcceptGif() {
        return this.hasContentType(ContentType.IMAGE_GIF);
    }

    public boolean hasAcceptMpeg() {
        return this.hasContentType(ContentType.AUDIO_MPEG);
    }

    public boolean hasAcceptMp4() {
        return this.hasContentType(ContentType.VIDEO_MP4);
    }

    public boolean is1xxInformational() {
        return this.statusCode >= 100 && this.statusCode < 200;
    }

    public boolean is2xxSuccessful() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public boolean is3xxRedirection() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    public boolean is4xxClientError() {
        return this.statusCode >= 400 && this.statusCode < 500;
    }

    public boolean is5xxServerError() {
        return this.statusCode >= 500 && this.statusCode < 600;
    }

    public <T> T fromExchange(Function<HttpExchange, T> mapper) {
        return this.exchange != null ? (T)mapper.apply(this.exchange) : null;
    }

    public String toString() {
        return new StringJoiner(", ", HttpObject.class.getSimpleName() + "[", "]").add("statusCode=" + this.statusCode).add("path=" + this.path).add("method=" + this.method()).add("headers=" + String.valueOf(this.headers)).add("body=" + this.bodyAsString()).toString();
    }

    public static ContentType guessContentType(HttpObject response, byte[] body) {
        if (body.length > 0) {
            if (body[0] == 123 && body[body.length - 1] == 125 || body[0] == 91 && body[body.length - 1] == 93) {
                return ContentType.APPLICATION_JSON;
            }
            if (body[0] == 60 && body[body.length - 1] == 62) {
                if (new String(body, 0, Math.min(body.length, 14), response.encoding()).contains("<!DOCTYPE html")) {
                    return ContentType.TEXT_HTML;
                }
                return ContentType.APPLICATION_XML;
            }
        }
        return ContentType.TEXT_PLAIN;
    }

    public static <R> List<R> splitHeaderValue(Collection<String> value, Function<String, R> mapper) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value.size() != 1) {
            return value.stream().map(mapper).toList();
        }
        return Arrays.stream(NanoUtils.split(value.iterator().next(), ",")).map(s -> NanoUtils.split(s, ";q=")).sorted(Comparator.comparing(parts -> ((String[])parts).length > 1 ? Double.parseDouble(parts[1].trim()) : 1.0, Comparator.reverseOrder())).map(parts -> mapper.apply(parts[0].trim())).filter(Objects::nonNull).toList();
    }

    public static boolean isMethod(HttpObject request, HttpMethod method) {
        return request.method.name().equals(method.name());
    }

    public static TypeMap convertHeaders(Map<String, ?> headers) {
        return headers.entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), Map.Entry::getValue, (v1, v2) -> v1, TypeMap::new));
    }

    public static String removeLast(String input, String removable) {
        return input.length() > removable.length() && input.endsWith(removable) ? input.substring(0, input.length() - removable.length()) : input;
    }

    public boolean isDeflateCompressed(byte[] body) {
        Inflater inflater = new Inflater();
        try {
            inflater.setInput(body);
            byte[] result = new byte[100];
            int resultLength = inflater.inflate(result);
            inflater.end();
            return resultLength > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isZipCompressed(byte[] body) {
        int ZIP_MAGIC = 1347093252;
        return body.length > 3 && (body[0] & 0xFF) == 80 && (body[1] & 0xFF) == 75 && (body[2] & 0xFF) == 3 && (body[3] & 0xFF) == 4;
    }
}

