/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.services.metric.logic;

import berlin.yuna.typemap.model.TypeMap;
import java.io.File;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.nanonative.nano.core.Nano;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.core.model.Service;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.config.ConfigRegister;
import org.nanonative.nano.helper.event.EventChannelRegister;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.helper.logger.model.LogLevel;
import org.nanonative.nano.services.http.HttpService;
import org.nanonative.nano.services.http.model.ContentType;
import org.nanonative.nano.services.http.model.HttpObject;
import org.nanonative.nano.services.metric.model.MetricCache;
import org.nanonative.nano.services.metric.model.MetricUpdate;

public class MetricService
extends Service {
    private final MetricCache metrics = new MetricCache();
    protected String prometheusPath;
    protected String dynamoPath;
    protected String influx;
    protected String wavefront;
    public static final String CONFIG_METRIC_SERVICE_BASE_PATH = ConfigRegister.registerConfig("app_service_metrics_base_url", "Base path for the metric service");
    public static final String CONFIG_METRIC_SERVICE_PROMETHEUS_PATH = ConfigRegister.registerConfig("app_service_prometheus_metrics_url", "Prometheus path for the metric service");
    public static final String CONFIG_METRIC_SERVICE_INFLUX_PATH = ConfigRegister.registerConfig("app_service_influx_metrics_url", "Influx path for the metric service");
    public static final String CONFIG_METRIC_SERVICE_WAVEFRONT_PATH = ConfigRegister.registerConfig("app_service_wavefront_metrics_url", "Wavefront path for the metric service");
    public static final String CONFIG_METRIC_SERVICE_DYNAMO_PATH = ConfigRegister.registerConfig("app_service_dynamo_metrics_url", "Dynamo path for the metric service");
    public static final int EVENT_METRIC_UPDATE = EventChannelRegister.registerChannelId("EVENT_METRIC_UPDATE");

    public MetricService() {
        super(null, false);
    }

    @Override
    public void start(Supplier<Context> contextSupplier) {
        AtomicReference basePath = new AtomicReference(Optional.empty());
        this.isReady.set(false, true, run -> {
            this.updateSystemMetrics(contextSupplier);
            basePath.set(Optional.ofNullable(((Context)((Object)((Object)contextSupplier.get()))).asString(new Object[]{CONFIG_METRIC_SERVICE_BASE_PATH})).or(() -> Optional.of("/metrics")));
            this.prometheusPath = ((Context)((Object)((Object)contextSupplier.get()))).getOpt(String.class, new Object[]{CONFIG_METRIC_SERVICE_PROMETHEUS_PATH}).orElseGet(() -> ((Optional)basePath.get()).map(base -> base + "/prometheus").orElse(null));
            this.dynamoPath = ((Context)((Object)((Object)contextSupplier.get()))).getOpt(String.class, new Object[]{CONFIG_METRIC_SERVICE_DYNAMO_PATH}).orElseGet(() -> ((Optional)basePath.get()).map(base -> base + "/dynamo").orElse(null));
            this.influx = ((Context)((Object)((Object)contextSupplier.get()))).getOpt(String.class, new Object[]{CONFIG_METRIC_SERVICE_INFLUX_PATH}).orElseGet(() -> ((Optional)basePath.get()).map(base -> base + "/influx").orElse(null));
            this.wavefront = ((Context)((Object)((Object)contextSupplier.get()))).getOpt(String.class, new Object[]{CONFIG_METRIC_SERVICE_WAVEFRONT_PATH}).orElseGet(() -> ((Optional)basePath.get()).map(base -> base + "/wavefront").orElse(null));
        });
    }

    @Override
    public void stop(Supplier<Context> contextSupplier) {
        this.isReady.set(true, false, run -> {
            this.metrics.gauges().clear();
            this.metrics.timers().clear();
            this.metrics.counters().clear();
        });
    }

    @Override
    public Object onFailure(Event error) {
        return null;
    }

    @Override
    public void onEvent(Event event) {
        super.onEvent(event);
        event.ifPresentAck(Context.EVENT_APP_HEARTBEAT, Nano.class, this::updateMetrics).ifPresentAck(EVENT_METRIC_UPDATE, MetricUpdate.class, this::updateMetric).ifPresent(Context.EVENT_CONFIG_CHANGE, TypeMap.class, map -> map.getOpt(LogLevel.class, new Object[]{Context.CONFIG_LOG_LEVEL}).ifPresent(level -> this.metrics.gaugeSet("logger", 1.0, Map.of("level", level.name()))));
        this.addMetricsEndpoint(event);
    }

    protected void addMetricsEndpoint(Event event) {
        event.ifPresent(HttpService.EVENT_HTTP_REQUEST, HttpObject.class, request -> Optional.ofNullable(this.prometheusPath).filter(request::pathMatch).filter(path -> request.isMethodGet()).ifPresent(path -> request.response().statusCode(200).body(this.metrics.prometheus()).headerMap(Map.of("content-type", ContentType.TEXT_PLAIN)).respond(event))).ifPresent(HttpService.EVENT_HTTP_REQUEST, HttpObject.class, request -> Optional.ofNullable(this.dynamoPath).filter(request::pathMatch).filter(path -> request.isMethodGet()).ifPresent(path -> request.response().statusCode(200).body(this.metrics.dynatrace()).headerMap(Map.of("content-type", ContentType.TEXT_PLAIN)).respond(event))).ifPresent(HttpService.EVENT_HTTP_REQUEST, HttpObject.class, request -> Optional.ofNullable(this.influx).filter(request::pathMatch).filter(path -> request.isMethodGet()).ifPresent(path -> request.response().statusCode(200).body(this.metrics.influx()).headerMap(Map.of("content-type", ContentType.TEXT_PLAIN)).respond(event))).ifPresent(HttpService.EVENT_HTTP_REQUEST, HttpObject.class, request -> Optional.ofNullable(this.wavefront).filter(request::pathMatch).filter(path -> request.isMethodGet()).ifPresent(path -> request.response().statusCode(200).body(this.metrics.wavefront()).headerMap(Map.of("content-type", ContentType.TEXT_PLAIN)).respond(event)));
    }

    public void updateMetric(MetricUpdate metric) {
        switch (metric.type()) {
            case GAUGE: {
                this.metrics.gaugeSet(metric.name(), metric.value().doubleValue(), metric.tags());
                break;
            }
            case COUNTER: {
                this.metrics.counterIncrement(metric.name(), metric.tags());
                break;
            }
            case TIMER_START: {
                this.metrics.timerStart(metric.name(), metric.tags());
                break;
            }
            case TIMER_END: {
                this.metrics.timerStop(metric.name(), metric.tags());
            }
        }
    }

    public MetricCache metrics() {
        return this.metrics;
    }

    public MetricService updateMetrics(Nano nano) {
        this.updateNanoMetrics(nano);
        this.updateCpuMetrics(nano::context);
        this.updateDiscMetrics(nano::context);
        this.updateMemoryMetrics(nano::context);
        this.updatePoolMetrics(nano::context);
        this.updateThreadMetrics(nano::context);
        this.updateBufferMetrics(nano::context);
        this.updateClassLoaderMetrics(nano::context);
        this.updateCompilerMetrics(nano);
        nano.context().tryExecute(() -> {
            this.metrics.gaugeSet("service.metrics.gauges", this.metrics.gauges().size());
            this.metrics.gaugeSet("service.metrics.timers", this.metrics.timers().size());
            this.metrics.gaugeSet("service.metrics.counters", this.metrics.counters().size());
            this.metrics.gaugeSet("service.metrics.bytes", this.estimateMetricCacheSize());
        });
        return this;
    }

    public void updateCompilerMetrics(Nano nano) {
        nano.context().tryExecute(() -> {
            CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
            if (compilationMXBean.isCompilationTimeMonitoringSupported()) {
                this.metrics.gaugeSet("jvm.compilation.time.ms", compilationMXBean.getTotalCompilationTime());
            }
        });
    }

    public void updateClassLoaderMetrics(Supplier<Context> context) {
        NanoUtils.tryExecute(context, () -> {
            ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
            this.metrics.gaugeSet("jvm.classes.loaded", classLoadingMXBean.getLoadedClassCount());
            this.metrics.gaugeSet("jvm.classes.unloaded", classLoadingMXBean.getUnloadedClassCount());
        });
    }

    public void updateBufferMetrics(Supplier<Context> context) {
        NanoUtils.tryExecute(context, () -> {
            String suffix = ".bytes";
            for (BufferPoolMXBean pool : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
                HashMap<String, String> tags = new HashMap<String, String>();
                tags.put("id", pool.getName());
                this.metrics.gaugeSet("jvm.buffer.count." + pool.getName() + ".bytes", pool.getCount(), tags);
                this.metrics.gaugeSet("jvm.buffer.memory.used." + pool.getName() + ".bytes", pool.getMemoryUsed(), tags);
                this.metrics.gaugeSet("jvm.buffer.total.capacity." + pool.getName() + ".bytes", pool.getTotalCapacity(), tags);
            }
        });
    }

    public void updateThreadMetrics(Supplier<Context> context) {
        NanoUtils.tryExecute(context, () -> {
            this.metrics.gaugeSet("jvm.threads.live", Thread.activeCount());
            this.metrics.gaugeSet("jvm.threads.nano", NanoThread.activeNanoThreads());
            this.metrics.gaugeSet("jvm.threads.carrier", NanoThread.activeCarrierThreads());
        });
        NanoUtils.tryExecute(context, () -> {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            this.metrics.gaugeSet("jvm.threads.daemon", threadMXBean.getDaemonThreadCount());
            this.metrics.gaugeSet("jvm.threads.live", threadMXBean.getThreadCount());
            this.metrics.gaugeSet("jvm.threads.peak", threadMXBean.getPeakThreadCount());
            Arrays.stream(threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds())).filter(Objects::nonNull).collect(Collectors.groupingBy(ThreadInfo::getThreadState, Collectors.counting())).forEach((state, count) -> this.metrics.gaugeSet("jvm.threads.states", count.longValue(), Map.of("state", state.toString().toLowerCase())));
        });
    }

    public void updatePoolMetrics(Supplier<Context> context) {
        NanoUtils.tryExecute(context, () -> {
            List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean pool : pools) {
                String area = pool.getType() == MemoryType.HEAP ? "heap" : "nonheap";
                MemoryUsage usage = pool.getUsage();
                this.metrics.gaugeSet("jvm.memory.max.bytes", usage.getMax(), Map.of("area", area, "id", pool.getName()));
                this.metrics.gaugeSet("jvm.memory.used.bytes", usage.getUsed(), Map.of("area", area, "id", pool.getName()));
                this.metrics.gaugeSet("jvm.memory.committed.bytes", usage.getCommitted(), Map.of("area", area, "id", pool.getName()));
            }
        });
    }

    public void updateMemoryMetrics(Supplier<Context> context) {
        NanoUtils.tryExecute(context, () -> {
            Runtime runtime = Runtime.getRuntime();
            this.metrics.gaugeSet("system.cpu.cores", runtime.availableProcessors());
            this.metrics.gaugeSet("jvm.memory.max.bytes", runtime.maxMemory());
            this.metrics.gaugeSet("jvm.memory.used.bytes", (double)runtime.totalMemory() - (double)runtime.freeMemory());
        });
    }

    public void updateDiscMetrics(Supplier<Context> context) {
        NanoUtils.tryExecute(context, () -> {
            File disk = new File("/");
            this.metrics.gaugeSet("disk.free.bytes", disk.getFreeSpace());
            this.metrics.gaugeSet("disk.total.bytes", disk.getTotalSpace());
        });
    }

    public void updateCpuMetrics(Supplier<Context> context) {
        NanoUtils.tryExecute(context, () -> {
            OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
            if (osMXBean instanceof com.sun.management.OperatingSystemMXBean) {
                com.sun.management.OperatingSystemMXBean sunOsMXBean = (com.sun.management.OperatingSystemMXBean)osMXBean;
                this.metrics.gaugeSet("process.cpu.usage", sunOsMXBean.getProcessCpuLoad());
                this.metrics.gaugeSet("system.cpu.usage", sunOsMXBean.getCpuLoad());
            }
            this.metrics.gaugeSet("system.load.average.1m", osMXBean.getSystemLoadAverage());
        });
    }

    public void updateNanoMetrics(Nano nano) {
        NanoUtils.tryExecute(nano::context, () -> {
            nano.services().stream().collect(Collectors.groupingBy(service -> service.getClass().getSimpleName(), Collectors.counting())).forEach((className, count) -> this.metrics.gaugeSet("application.services", count.longValue(), Map.of("class", className)));
            this.metrics.gaugeSet("application.schedulers", nano.schedulers().size());
            this.metrics.gaugeSet("application.listeners", nano.listeners().size());
        });
    }

    public void updateSystemMetrics(Supplier<Context> context) {
        String numberRegex = "\\D";
        this.metrics.gaugeSet("application.pid", ProcessHandle.current().pid());
        this.updateJavaVersion(context);
        this.updateArch(context);
        this.updateOs(context);
        NanoUtils.tryExecute(context, () -> this.metrics.gaugeSet("system.version", Double.parseDouble(System.getProperty("os.version").replaceAll("\\D", ""))));
    }

    public void updateOs(Supplier<Context> context) {
        NanoUtils.tryExecute(context, () -> {
            String osName = System.getProperty("os.name");
            osName = osName == null ? "" : osName.toLowerCase();
            List<String> osPrefixes = List.of("linux", "mac", "windows", "aix", "irix", "hp-ux", "os/400", "freebsd", "openbsd", "netbsd", "os/2", "solaris", "sunos", "mips", "z/os");
            List<String> unix = List.of("linux", "mac", "aix", "irix", "hp-ux", "freebsd", "openbsd", "netbsd", "solaris", "sunos");
            String finalOsName = osName;
            this.metrics.gaugeSet("system.type", (double)IntStream.range(0, osPrefixes.size()).filter(i -> finalOsName.startsWith((String)osPrefixes.get(i))).findFirst().orElse(-1) + 1.0);
            this.metrics.gaugeSet("system.unix", unix.stream().anyMatch(finalOsName::startsWith) ? 1.0 : 0.0);
        });
    }

    public void updateArch(Supplier<Context> context) {
        NanoUtils.tryExecute(context, () -> {
            String metricName = "system.arch.bit";
            String arch = System.getProperty("os.arch");
            String string = arch = arch == null ? "" : arch.toLowerCase();
            if (arch.contains("64")) {
                this.metrics.gaugeSet("system.arch.bit", 64.0);
            } else if (Stream.of("x86", "686", "386", "368").anyMatch(arch::contains)) {
                this.metrics.gaugeSet("system.arch.bit", 32.0);
            } else {
                String number = arch.replaceAll("\\D", "");
                this.metrics.gaugeSet("system.arch.bit", number.isEmpty() ? 0.0 : Double.parseDouble(number));
            }
        });
    }

    public void updateJavaVersion(Supplier<Context> context) {
        NanoUtils.tryExecute(context, () -> {
            String version = System.getProperty("java.version");
            version = version.startsWith("1.") ? version.substring(2) : version;
            version = version.contains(".") ? version.substring(0, version.indexOf(".")) : version;
            this.metrics.gaugeSet("java.version", Double.parseDouble(version.replaceAll("\\D", "")));
        });
    }

    public long estimateMetricCacheSize() {
        long totalSize = 0L;
        return totalSize += this.estimateMapSize(new HashMap(this.metrics.counters()), 28L) + this.estimateMapSize(new HashMap(this.metrics.gauges()), 24L) + this.estimateMapSize(new HashMap(this.metrics.timers()), 16L);
    }

    private long estimateMapSize(Map<String, MetricCache.Metric<?>> map, long numberSize) {
        long size = 36L;
        for (Map.Entry<String, MetricCache.Metric<?>> entry : map.entrySet()) {
            size += 32L + this.estimateStringSize(entry.getKey()) + this.estimateMetricSize(entry.getValue(), numberSize);
        }
        return size;
    }

    private long estimateMetricSize(MetricCache.Metric<?> metric, long numberSize) {
        long size = 48L;
        size += this.estimateStringSize(metric.metricName());
        size += numberSize;
        for (Map.Entry<String, String> tag : metric.tags().entrySet()) {
            size += this.estimateStringSize(tag.getKey()) + this.estimateStringSize(tag.getValue());
        }
        return size;
    }

    private long estimateStringSize(String string) {
        return 24L + (long)string.length() * 2L;
    }

    public String prometheusPath() {
        return this.prometheusPath;
    }

    public String dynamoPath() {
        return this.dynamoPath;
    }

    public String influx() {
        return this.influx;
    }

    public String wavefront() {
        return this.wavefront;
    }
}

