/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core.model;

import berlin.yuna.typemap.model.TypeMap;
import berlin.yuna.typemap.model.TypeMapI;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.services.metric.logic.MetricService;
import org.nanonative.nano.services.metric.model.MetricType;
import org.nanonative.nano.services.metric.model.MetricUpdate;

public abstract class Service {
    protected final long createdAtMs;
    protected final AtomicBoolean isReady = new AtomicBoolean(false);
    protected Context context;

    protected Service() {
        this.createdAtMs = System.currentTimeMillis();
    }

    public abstract void start();

    public abstract void stop();

    public abstract Object onFailure(Event var1);

    public abstract void onEvent(Event var1);

    public void configure(TypeMapI<?> config) {
        this.configure(config, config);
    }

    public abstract void configure(TypeMapI<?> var1, TypeMapI<?> var2);

    public String name() {
        return this.getClass().getSimpleName();
    }

    public Context context() {
        return this.context;
    }

    public boolean isReady() {
        return this.isReady.get();
    }

    public AtomicBoolean isReadyState() {
        return this.isReady;
    }

    public Service context(Context context) {
        this.context = context;
        return this;
    }

    public long createdAtMs() {
        return this.createdAtMs;
    }

    public Service receiveEvent(Event event) {
        if (event.channelId() == Context.EVENT_CONFIG_CHANGE) {
            event.payloadOpt().filter(TypeMapI.class::isInstance).map(TypeMapI.class::cast).or(() -> event.payloadOpt(Map.class).map(TypeMap::new).map(TypeMapI.class::cast)).ifPresentOrElse(configs -> {
                TypeMap merged = new TypeMap((Map)((Object)this.context));
                this.context.forEach((arg_0, arg_1) -> merged.putIfAbsent(arg_0, arg_1));
                this.configure((TypeMapI<?>)configs, (TypeMapI<?>)merged);
                this.context.putAll((Map)configs);
            }, () -> this.onEvent(event));
        } else {
            this.onEvent(event);
        }
        return this;
    }

    public NanoThread nanoThread(Context context) {
        return new NanoThread().run(() -> context.nano() != null ? context : null, () -> {
            long startTime = System.currentTimeMillis();
            if (!this.isReady.get()) {
                this.context = context.newContext(this.getClass());
                this.configure((TypeMapI<?>)context);
                this.start();
                this.context.broadcastEvent(Context.EVENT_APP_SERVICE_REGISTER, () -> this);
                this.context.sendEvent(MetricService.EVENT_METRIC_UPDATE, () -> new MetricUpdate(MetricType.GAUGE, "application.services.ready.time", System.currentTimeMillis() - startTime, Map.of("class", this.getClass().getSimpleName())), result -> {});
                this.isReady.set(true);
            }
        }).onComplete((nanoThread, error) -> {
            if (error != null) {
                this.context.sendEventError(context.newEvent(Context.EVENT_APP_SERVICE_REGISTER).payload(() -> this), this, (Throwable)error);
            }
        });
    }

    public static NanoThread[] threadsOf(Context context, Service ... services) {
        return (NanoThread[])Arrays.stream(services).map(service -> service.nanoThread(context)).toArray(NanoThread[]::new);
    }
}

