/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.services.metric.model;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MetricCache {
    private final ConcurrentHashMap<String, Metric<AtomicLong>> counters = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Metric<Double>> gauges = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Metric<Long>> timers = new ConcurrentHashMap();

    public Map<String, Metric<AtomicLong>> counters() {
        return this.counters;
    }

    public Map<String, Metric<Double>> gauges() {
        return this.gauges;
    }

    public Map<String, Metric<Long>> timers() {
        return this.timers;
    }

    public Map<String, Metric<? extends Number>> sorted() {
        TreeMap<String, Metric<? extends Number>> result = new TreeMap<String, Metric<? extends Number>>();
        result.putAll(this.counters);
        result.putAll(this.gauges);
        result.putAll(this.timers);
        return result;
    }

    public MetricCache counterIncrement(String name) {
        return this.counterIncrement(name, null);
    }

    public MetricCache counterIncrement(String name, Map<String, String> tags) {
        if (name != null) {
            String id = this.sanitizeMetricName(name);
            TreeMap<String, String> sortedTags = new TreeMap<String, String>(tags != null ? tags : Collections.emptyMap());
            ((AtomicLong)this.counters.computeIfAbsent((String)(tags == null ? id : this.generateUniqueKey((String)id, sortedTags)), (Function<String, Metric>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$counterIncrement$0(java.util.TreeMap java.lang.String java.lang.String ), (Ljava/lang/String;)Lorg/nanonative/nano/services/metric/model/MetricCache$Metric;)(sortedTags, (String)id)).value).incrementAndGet();
        }
        return this;
    }

    public long counter(String name) {
        return this.counter(name, null);
    }

    public long counter(String name, Map<String, String> tags) {
        String id = this.sanitizeMetricName(name);
        return Optional.ofNullable(this.counters.get(tags == null ? id : this.generateUniqueKey(id, new TreeMap<String, String>(tags)))).map(Metric::value).map(AtomicLong::get).orElse(-1L);
    }

    public MetricCache gaugeSet(String name, double value) {
        return this.gaugeSet(name, value, null);
    }

    public MetricCache gaugeSet(String name, double value, Map<String, String> tags) {
        if (name != null && value > -1.0) {
            String id = this.sanitizeMetricName(name);
            TreeMap<String, String> sortedTags = new TreeMap<String, String>(tags != null ? tags : Collections.emptyMap());
            this.gauges.put(tags == null ? id : this.generateUniqueKey(id, sortedTags), new Metric<Double>(value, sortedTags, id));
        }
        return this;
    }

    public double gauge(String name) {
        return this.gauge(name, null);
    }

    public double gauge(String name, Map<String, String> tags) {
        String id = this.sanitizeMetricName(name);
        return Optional.ofNullable(this.gauges.get(tags == null ? id : this.generateUniqueKey(id, new TreeMap<String, String>(tags)))).map(Metric::value).orElse(-1.0);
    }

    public MetricCache timerStart(String name) {
        return this.timerStart(name, null);
    }

    public MetricCache timerStart(String name, Map<String, String> tags) {
        if (name != null) {
            String id = this.sanitizeMetricName(name);
            TreeMap<String, String> sortedTags = new TreeMap<String, String>(tags != null ? tags : Collections.emptyMap());
            this.timers.put(tags == null ? id : this.generateUniqueKey(id, sortedTags), new Metric<Long>(System.currentTimeMillis(), sortedTags, id));
        }
        return this;
    }

    public MetricCache timerStop(String name) {
        return this.timerStop(name, null);
    }

    public MetricCache timerStop(String name, Map<String, String> tags) {
        if (name != null) {
            String id = this.sanitizeMetricName(name);
            TreeMap<String, String> sortedTags = new TreeMap<String, String>(tags != null ? tags : Collections.emptyMap());
            this.timers.computeIfPresent(tags == null ? id : this.generateUniqueKey(id, sortedTags), (key, metric) -> new Metric<Long>(System.currentTimeMillis() - (Long)metric.value, sortedTags, id));
        }
        return this;
    }

    public long timer(String name) {
        return this.timer(name, null);
    }

    public long timer(String name, Map<String, String> tags) {
        String id = this.sanitizeMetricName(name);
        return Optional.ofNullable(this.timers.get(tags == null ? id : this.generateUniqueKey(id, new TreeMap<String, String>(tags)))).map(Metric::value).orElse(-1L);
    }

    public String prometheus() {
        StringBuilder result = new StringBuilder();
        this.sorted().forEach((id, metric) -> result.append(this.formatPrometheusMetric((Metric<?>)metric)));
        return result.toString();
    }

    public String influx() {
        StringBuilder sb = new StringBuilder();
        this.sorted().forEach((id, metric) -> {
            Object object;
            StringBuilder stringBuilder = sb.append(metric.metricName()).append(this.formatInfluxTags(metric.tags())).append(" value=");
            Object patt0$temp = metric.value();
            if (patt0$temp instanceof AtomicLong) {
                AtomicLong val = (AtomicLong)patt0$temp;
                object = val.get();
            } else {
                object = metric.value();
            }
            stringBuilder.append(object).append("\n");
        });
        return sb.toString();
    }

    public String dynatrace() {
        StringBuilder sb = new StringBuilder();
        this.sorted().forEach((id, metric) -> sb.append(this.formatDynatraceMetric((Metric<?>)metric)));
        return sb.toString();
    }

    public String wavefront() {
        StringBuilder sb = new StringBuilder();
        this.sorted().forEach((id, metric) -> sb.append(this.formatWavefrontMetric((Metric<?>)metric)));
        return sb.toString();
    }

    public String generateUniqueKey(String name, Map<String, String> tags) {
        String tagString = tags.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).reduce((t1, t2) -> t1 + "&" + t2).orElse("");
        return name + "{" + tagString + "}";
    }

    public String sanitizeMetricName(String name) {
        return name == null ? "UNKNOWN.METRIC" : name.replaceAll("[^a-zA-Z0-9.]", ".").replace("..", ".").replaceAll("^\\.|\\.$", "");
    }

    private String formatPrometheusMetric(Metric<?> metric) {
        String tagsString = metric.tags.entrySet().stream().map(entry -> (String)entry.getKey() + "=\"" + (String)entry.getValue() + "\"").reduce((t1, t2) -> t1 + "," + t2).map(tags -> "{" + tags + "}").orElse("");
        return metric.metricName.replace(".", "_") + tagsString + " " + String.valueOf(metric.value) + "\n";
    }

    private String formatInfluxTags(Map<String, String> tags) {
        StringBuilder tagsBuilder = new StringBuilder();
        tags.forEach((key, value) -> tagsBuilder.append(",").append((String)key).append("=").append((String)value));
        return tagsBuilder.toString();
    }

    private String formatDynatraceMetric(Metric<?> metric) {
        String dimensions = metric.tags.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(","));
        return metric.metricName + "," + dimensions + " " + String.valueOf(metric.value) + "\n";
    }

    private String formatWavefrontMetric(Metric<?> metric) {
        String tags = metric.tags.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(" "));
        return metric.metricName + " " + String.valueOf(metric.value) + " source=nano " + tags + "\n";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{counters=" + this.counters.size() + ", gauges=" + this.gauges.size() + ", timers=" + this.timers.size() + "}";
    }

    private static /* synthetic */ Metric lambda$counterIncrement$0(TreeMap sortedTags, String id, String key) {
        return new Metric<AtomicLong>(new AtomicLong(), sortedTags, id);
    }

    public record Metric<T extends Number>(T value, TreeMap<String, String> tags, String metricName) {
    }
}

