/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.helper;

import java.util.concurrent.Semaphore;
import java.util.function.Consumer;

public class LockedBoolean {
    private boolean state;
    private final Semaphore lock = new Semaphore(1);

    public LockedBoolean() {
        this(false);
    }

    public LockedBoolean(boolean state) {
        this.state = state;
    }

    public void set(boolean state) {
        this.execute(null, state, null);
    }

    public void set(boolean state, Consumer<Boolean> run) {
        this.execute(null, state, run);
    }

    public void set(boolean when, boolean then) {
        this.set(when, then, null);
    }

    public void set(boolean when, boolean then, Consumer<Boolean> run) {
        this.execute(when, then, run);
    }

    public void run(Consumer<Boolean> run) {
        this.execute(null, null, run);
    }

    public void run(boolean when, Consumer<Boolean> then) {
        this.execute(when, null, then);
    }

    public boolean get() {
        try {
            this.lock.acquire();
            boolean bl = this.state;
            return bl;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            boolean bl = this.state;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Boolean expected, Boolean newValue, Consumer<Boolean> run) {
        try {
            this.lock.acquire();
            if (expected == null || this.state == expected) {
                if (run != null) {
                    run.accept(this.state);
                }
                if (newValue != null) {
                    this.state = newValue;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.release();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{state=" + this.get() + "}";
    }
}

