/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.helper.event;

import java.util.Map;
import java.util.Optional;
import org.nanonative.nano.core.NanoBase;
import org.nanonative.nano.helper.NanoUtils;

public class EventChannelRegister {
    public static int registerChannelId(String channelName) {
        return Optional.ofNullable(channelName).filter(NanoUtils::hasText).map(name -> EventChannelRegister.eventIdOf(channelName).orElseGet(() -> {
            int channelId = NanoBase.EVENT_ID_COUNTER.incrementAndGet();
            NanoBase.EVENT_TYPES.put(channelId, channelName);
            return channelId;
        })).orElse(-1);
    }

    public static String eventNameOf(int channelId) {
        return NanoBase.EVENT_TYPES.get(channelId);
    }

    public static Optional<Integer> eventIdOf(String channelName) {
        return NanoUtils.hasText(channelName) ? NanoBase.EVENT_TYPES.entrySet().stream().filter(type -> ((String)type.getValue()).equals(channelName)).map(Map.Entry::getKey).findFirst() : Optional.empty();
    }

    public static boolean isChannelIdAvailable(int channelId) {
        return NanoBase.EVENT_TYPES.containsKey(channelId);
    }

    private EventChannelRegister() {
    }
}

