/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.helper.event.model;

import berlin.yuna.typemap.logic.TypeConverter;
import berlin.yuna.typemap.model.LinkedTypeMap;
import berlin.yuna.typemap.model.Type;
import berlin.yuna.typemap.model.TypeMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.nanonative.nano.core.Nano;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.helper.event.EventChannelRegister;

public class Event
extends TypeMap {
    protected int channelId;
    protected final Context context;
    protected transient Consumer<Object> responseListener;
    protected transient Supplier<Object> payload;
    protected transient Object payloadRaw;
    protected transient Object response;
    protected Throwable error;
    public static final String EVENT_ORIGINAL_CHANNEL_ID = "app_original_event_channel_id";

    public static Event eventOf(Context context, int channelId) {
        return new Event(context).channelId(channelId);
    }

    public static Event asyncEventOf(Context context, int channelId) {
        return new Event(context).async(true).channelId(channelId);
    }

    public Event(Context context) {
        this.context = context;
        this.put("createdAt", System.currentTimeMillis());
    }

    public String channel() {
        return EventChannelRegister.eventNameOf(this.channelId);
    }

    public String nameOrg() {
        return EventChannelRegister.eventNameOf(this.channelIdOrg());
    }

    public Nano nano() {
        return this.context.nano();
    }

    public int channelId() {
        return this.channelId;
    }

    public int channelIdOrg() {
        return (Integer)this.asIntOpt(new Object[]{EVENT_ORIGINAL_CHANNEL_ID}).orElse((Object)this.channelId);
    }

    public Event channelId(int channelId) {
        this.channelId = channelId;
        return this;
    }

    public Event async(boolean async) {
        this.responseListener = async ? ignored -> {} : null;
        return this;
    }

    public Event async(Consumer<Object> responseListener) {
        this.responseListener = responseListener;
        return this;
    }

    public Event payload(Supplier<Object> payload) {
        this.payload = payload;
        return this;
    }

    public Event ifPresent(int channelId, Consumer<Event> consumer) {
        if (this.channelId == channelId) {
            consumer.accept(this);
        }
        return this;
    }

    public Event ifPresentAck(int channelId, Consumer<Event> consumer) {
        if (this.channelId == channelId) {
            consumer.accept(this);
            this.acknowledge();
        }
        return this;
    }

    public <T> Event ifPresent(int channelId, Class<T> clazz, Consumer<T> consumer) {
        T payloadObj;
        if (this.channelId == channelId && (payloadObj = this.payload(clazz)) != null) {
            consumer.accept(payloadObj);
        }
        return this;
    }

    public <T> Event ifPresentAck(int channelId, Class<T> clazz, Function<T, Object> consumer) {
        T payloadObj;
        if (this.channelId == channelId && (payloadObj = this.payload(clazz)) != null) {
            this.response(consumer.apply(payloadObj));
        }
        return this;
    }

    public Object payload() {
        if (this.payloadRaw == null) {
            this.payloadRaw = this.payload == null ? null : this.payload.get();
        }
        return this.payloadRaw;
    }

    public boolean isBroadcast() {
        return (Boolean)this.asBooleanOpt(new Object[]{"isBroadcast"}).orElse((Object)false);
    }

    public Event broadcast(boolean broadcast) {
        return this.putR("isBroadcast", broadcast);
    }

    public boolean isAcknowledged() {
        return this.response != null;
    }

    public Optional<Object> payloadOpt() {
        return Optional.ofNullable(this.payload());
    }

    public <T> T payload(Class<T> type) {
        return (T)TypeConverter.convertObj((Object)this.payload(), type);
    }

    public <T> Optional<T> payloadOpt(Class<T> type) {
        return Optional.ofNullable(TypeConverter.convertObj((Object)this.payload(), type));
    }

    public Context context() {
        return this.context;
    }

    public boolean isAsync() {
        return this.responseListener != null;
    }

    public Consumer<Object> async() {
        return this.responseListener;
    }

    public Event acknowledge() {
        return this.acknowledge(null);
    }

    public Event acknowledge(Runnable response) {
        if (response != null) {
            response.run();
        }
        return this.response(true);
    }

    public Event response(Object response) {
        if (this.responseListener != null) {
            this.responseListener.accept(response);
        }
        this.response = response;
        return this;
    }

    public <T> T response(Class<T> type) {
        return (T)TypeConverter.convertObj((Object)this.response, type);
    }

    public <T> Optional<T> responseOpt(Class<T> type) {
        return Optional.ofNullable(this.response(type));
    }

    public Object response() {
        return this.response;
    }

    public Event peek(Consumer<Event> peek) {
        if (peek != null) {
            peek.accept(this);
        }
        return this;
    }

    public Event putR(Object key, Object value) {
        this.put(key, value);
        return this;
    }

    public Type<Event> filter(Predicate<Event> predicate) {
        return new Type((Object)(predicate.test(this) ? this : null));
    }

    public Throwable error() {
        return this.error;
    }

    public Event error(Throwable error) {
        this.error = error;
        return this;
    }

    public Event send() {
        this.nano().sendEvent(this);
        return this;
    }

    public String toString() {
        return ((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)new LinkedTypeMap().putR((Object)"channel", (Object)this.channel())).putR((Object)"ack", (Object)(this.response != null ? 1 : 0))).putR((Object)"listener", (Object)(this.responseListener != null ? 1 : 0))).putR((Object)"payload", (Object)this.payload(String.class))).putR((Object)"size", (Object)(this.context.size() + this.size() + (this.payload == null ? 0 : 1) + (this.responseListener == null ? 0 : 1) + (this.response == null ? 0 : 1) + (this.error == null ? 0 : 1)))).toJson();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Event)) {
            return false;
        }
        Event event = (Event)((Object)o);
        if (!super.equals(o)) {
            return false;
        }
        return this.channelId == event.channelId && Objects.equals((Object)this.context, (Object)event.context) && Objects.equals(this.responseListener, event.responseListener) && Objects.equals(this.payload, event.payload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.channelId, this.context, this.responseListener, this.payload});
    }
}

