/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core;

import berlin.yuna.typemap.logic.ArgsDecoder;
import berlin.yuna.typemap.logic.TypeConverter;
import berlin.yuna.typemap.model.TypeMap;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Formatter;
import java.util.stream.Collectors;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.helper.LockedBoolean;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.helper.logger.LogFormatRegister;
import org.nanonative.nano.helper.logger.logic.NanoLogger;
import org.nanonative.nano.helper.logger.model.LogLevel;

public abstract class NanoBase<T extends NanoBase<T>> {
    protected final Context context;
    protected final long createdAtMs;
    protected final NanoLogger logger;
    protected final Map<Integer, Set<Consumer<Event>>> listeners = new ConcurrentHashMap<Integer, Set<Consumer<Event>>>();
    protected final LockedBoolean isReady = new LockedBoolean(true);
    protected final AtomicInteger eventCount = new AtomicInteger(0);
    public static final Map<Integer, String> EVENT_TYPES = new ConcurrentHashMap<Integer, String>();
    public static final Map<String, String> CONFIG_KEYS = new ConcurrentHashMap<String, String>();
    public static final AtomicInteger EVENT_ID_COUNTER = new AtomicInteger(0);

    protected NanoBase(Map<Object, Object> configs, String ... args) {
        this.createdAtMs = System.currentTimeMillis();
        this.context = this.readConfigs(args);
        if (configs != null) {
            configs.forEach((key, value) -> this.context.computeIfAbsent(TypeConverter.convertObj((Object)key, String.class), add -> Optional.ofNullable((String)TypeConverter.convertObj((Object)value, String.class)).orElse("")));
        }
        this.logger = new NanoLogger(this).level((LogLevel)((Object)this.context.asOpt(LogLevel.class, new Object[]{Context.CONFIG_LOG_LEVEL}).orElse((Object)LogLevel.DEBUG))).formatter((Formatter)this.context.asOpt(Formatter.class, new Object[]{Context.CONFIG_LOG_FORMATTER}).orElseGet(() -> LogFormatRegister.getLogFormatter("console")));
        this.context.put("app_core_context_logger", this.logger);
        this.displayHelpMenu();
        this.subscribeEvent(Context.EVENT_CONFIG_CHANGE, event -> event.payloadOpt(TypeMap.class).map(this::putAll).ifPresent(nano -> event.acknowledge()));
    }

    abstract Context context(Class<?> var1);

    abstract T sendEvent(int var1, Context var2, Object var3, Consumer<Object> var4, boolean var5);

    abstract Event sendEventReturn(int var1, Context var2, Object var3, Consumer<Object> var4, boolean var5);

    public NanoBase<T> putAll(TypeMap map) {
        this.context.putAll((Map<?, ?>)map);
        this.logger.configure(map);
        return this;
    }

    public abstract T stop(Class<?> var1);

    public abstract T stop(Context var1);

    public NanoLogger logger() {
        return this.logger;
    }

    public Map<Integer, Set<Consumer<Event>>> listeners() {
        return this.listeners;
    }

    public T subscribeEvent(int channelId, Consumer<Event> listener) {
        this.listeners.computeIfAbsent(channelId, value -> new LinkedHashSet()).add(listener);
        return (T)this;
    }

    public T unsubscribeEvent(int channelId, Consumer<Event> listener) {
        this.listeners.computeIfAbsent(channelId, value -> new LinkedHashSet()).remove(listener);
        return (T)this;
    }

    public long pid() {
        return ProcessHandle.current().pid();
    }

    public double usedMemoryMB() {
        Runtime runtime = Runtime.getRuntime();
        return BigDecimal.valueOf((double)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public double heapMemoryUsage() {
        MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        return BigDecimal.valueOf((double)heapMemoryUsage.getUsed() / (double)heapMemoryUsage.getMax()).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public long createdAtMs() {
        return this.createdAtMs;
    }

    public boolean isReady() {
        return this.isReady.get();
    }

    public int eventCount() {
        return this.eventCount.get();
    }

    protected void displayHelpMenu() {
        if (this.context.asBooleanOpt(new Object[]{Context.APP_HELP}).filter(helpCalled -> helpCalled).isPresent(new Object[0])) {
            int keyLength = CONFIG_KEYS.keySet().stream().mapToInt(String::length).max().orElse(0);
            this.logger.info(() -> "Available configs keys: " + System.lineSeparator() + CONFIG_KEYS.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(conf -> String.format("%-" + keyLength + "s  %s", conf.getKey(), conf.getValue())).collect(Collectors.joining(System.lineSeparator())), new Object[0]);
            if (((Boolean)this.context.asBooleanOpt(new Object[]{Context.CONFIG_ENV_PROD}).orElse((Object)false)).booleanValue()) {
                System.exit(0);
            }
        }
    }

    protected Context readConfigs(String ... args) {
        Context result = NanoUtils.readConfigFiles(null, "");
        System.getenv().forEach((key, value) -> NanoUtils.addConfig(result, key, value));
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> NanoUtils.addConfig(result, key, value)));
        if (args != null) {
            ArgsDecoder.argsOf((String)String.join((CharSequence)" ", args)).forEach((key, value) -> NanoUtils.addConfig(result, key, value));
        }
        return NanoUtils.resolvePlaceHolders(result);
    }

    protected T setLogLevel(LogLevel level) {
        this.logger.level(level);
        this.context.put(Context.CONFIG_LOG_LEVEL, (Object)level);
        this.logger.trace(() -> "New {} [{}]", new Object[]{LogLevel.class.getSimpleName(), level});
        return (T)this;
    }

    public static String standardiseKey(Object key) {
        return key == null ? null : ((String)TypeConverter.convertObj((Object)key, String.class)).replace('.', '_').replace('-', '_').replace('+', '_').replace(':', '_').trim().toLowerCase();
    }
}

