/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.nanonative.nano.core.NanoThreads;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.Service;
import org.nanonative.nano.helper.ExRunnable;

public abstract class NanoServices<T extends NanoServices<T>>
extends NanoThreads<T> {
    protected final List<Service> services = new CopyOnWriteArrayList<Service>();

    protected NanoServices(Map<Object, Object> config, String ... args) {
        super(config, args);
        this.subscribeEvent(Context.EVENT_APP_SERVICE_REGISTER, event -> event.payloadOpt(Service.class).map(this::registerService).ifPresent(nano -> event.acknowledge()));
        this.subscribeEvent(Context.EVENT_APP_SERVICE_UNREGISTER, event -> event.payloadOpt(Service.class).map(service -> this.unregisterService(event.context(), (Service)service)).ifPresent(nano -> event.acknowledge()));
    }

    public <S extends Service> S service(Class<S> serviceClass) {
        List<S> results = this.services(serviceClass);
        if (results != null && !results.isEmpty()) {
            return (S)((Service)results.getFirst());
        }
        return null;
    }

    public <S extends Service> List<S> services(Class<S> serviceClass) {
        if (serviceClass != null) {
            return this.services.stream().filter(serviceClass::isInstance).map(serviceClass::cast).toList();
        }
        return Collections.emptyList();
    }

    public List<Service> services() {
        return Collections.unmodifiableList(this.services);
    }

    protected void shutdownServices(Context context) {
        if (((Boolean)context.asBooleanOpt(new Object[]{Context.CONFIG_PARALLEL_SHUTDOWN}).orElse((Object)false)).booleanValue()) {
            try {
                context.runAwait((ExRunnable[])this.services.stream().map(service -> () -> this.unregisterService(context, (Service)service)).toArray(ExRunnable[]::new));
            }
            catch (Exception err) {
                this.logger.fatal(err, () -> "Service [{}] shutdown error. Looks like the Death Star blew up again.", Service.class.getSimpleName());
                Thread.currentThread().interrupt();
            }
        } else {
            new ArrayList<Service>(this.services).reversed().forEach(service -> this.unregisterService(context, (Service)service));
        }
    }

    protected T registerService(Service service) {
        if (service != null) {
            this.services.add(service);
        }
        return (T)this;
    }

    protected T unregisterService(Context context, Service service) {
        if (service != null) {
            this.services.remove(service);
            try {
                service.stop(() -> context);
            }
            catch (Exception e) {
                this.logger.warn(e, () -> "Stop [{}] error. Somebody call the Ghostbusters!", service.name());
            }
        }
        return (T)this;
    }
}

