/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.nanonative.nano.core.NanoBase;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.core.model.Scheduler;
import org.nanonative.nano.helper.ExRunnable;
import org.nanonative.nano.helper.NanoUtils;

public abstract class NanoThreads<T extends NanoThreads<T>>
extends NanoBase<T> {
    protected final Set<ScheduledExecutorService> schedulers;
    protected final ExecutorService threadPool = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("nano-thread-", 0L).factory());

    protected NanoThreads(Map<Object, Object> config, String ... args) {
        super(config, args);
        this.schedulers = ConcurrentHashMap.newKeySet();
        this.subscribeEvent(Context.EVENT_APP_SCHEDULER_REGISTER, event -> event.payloadOpt(ScheduledExecutorService.class).map(this.schedulers::add).ifPresent(nano -> event.acknowledge()));
        this.subscribeEvent(Context.EVENT_APP_SCHEDULER_UNREGISTER, event -> event.payloadOpt(ScheduledExecutorService.class).map(scheduler -> {
            scheduler.shutdown();
            this.schedulers.remove(scheduler);
            return this;
        }).ifPresent(nano -> event.acknowledge()));
    }

    public ExecutorService threadPool() {
        return !this.threadPool.isTerminated() && !this.threadPool.isShutdown() ? this.threadPool : null;
    }

    public Set<ScheduledExecutorService> schedulers() {
        return Collections.unmodifiableSet(this.schedulers);
    }

    public T run(Supplier<Context> context, ExRunnable task, long delay, TimeUnit timeUnit) {
        Scheduler scheduler = this.asyncFromPool(context);
        scheduler.schedule(() -> this.executeScheduler(context, task, scheduler, false), delay, timeUnit);
        return (T)this;
    }

    public T run(Supplier<Context> context, ExRunnable task, long delay, long period, TimeUnit unit, BooleanSupplier until) {
        Scheduler scheduler = this.asyncFromPool(context);
        scheduler.scheduleAtFixedRate(() -> {
            if (until.getAsBoolean()) {
                scheduler.shutdown();
            } else {
                this.executeScheduler(context, task, scheduler, true);
            }
        }, delay, period, unit);
        return (T)this;
    }

    public T run(Supplier<Context> context, ExRunnable task, LocalTime atTime, BooleanSupplier until) {
        LocalDateTime nextRun;
        LocalDateTime now = LocalDateTime.now();
        if (now.isAfter(nextRun = now.withHour(atTime.getHour()).withMinute(atTime.getMinute()).withSecond(atTime.getSecond()))) {
            nextRun = nextRun.plusDays(1L);
        }
        return this.run(context, task, Duration.between(now, nextRun).getSeconds(), TimeUnit.DAYS.toSeconds(1L), TimeUnit.SECONDS, until);
    }

    protected Scheduler asyncFromPool(final Supplier<Context> context) {
        final String schedulerId = NanoUtils.callerInfoStr(this.getClass()) + "_" + String.valueOf(UUID.randomUUID());
        Scheduler scheduler = new Scheduler(schedulerId){

            @Override
            protected void beforeExecute(Thread t, Runnable r) {
                t.setName("Scheduler_" + schedulerId);
                try {
                    if (!NanoThreads.this.threadPool.isTerminated() && !NanoThreads.this.threadPool.isShutdown()) {
                        NanoThreads.this.threadPool.submit(r);
                    }
                }
                catch (Throwable error) {
                    NanoUtils.handleJavaError(context, error);
                }
            }
        };
        this.sendEvent(Context.EVENT_APP_SCHEDULER_REGISTER, this.context(Scheduler.class), scheduler, result -> {}, true);
        return scheduler;
    }

    protected void shutdownThreads() {
        long timeoutMs = (Long)this.context.asLongOpt(new Object[]{Context.CONFIG_THREAD_POOL_TIMEOUT_MS}).filter(l -> l > 0L).orElse((Object)500L);
        this.logger.debug(() -> "Shutdown schedulers [{}]", this.schedulers.size());
        this.shutdownExecutors(timeoutMs, (ExecutorService[])this.schedulers.toArray(ScheduledExecutorService[]::new));
        this.logger.debug(() -> "Shutdown {} [{}]", this.threadPool.getClass().getSimpleName(), NanoThread.activeNanoThreads());
        this.shutdownExecutors(timeoutMs, this.threadPool);
    }

    protected void shutdownExecutors(long timeoutMs, ExecutorService ... executorServices) {
        Arrays.stream(executorServices).forEach(ExecutorService::shutdown);
        ((Stream)Arrays.stream(executorServices).parallel()).forEach(executorService -> {
            executorService.shutdown();
            try {
                this.kill((ExecutorService)executorService, timeoutMs);
                this.removeScheduler((ExecutorService)executorService);
            }
            catch (InterruptedException ie) {
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        });
    }

    protected void removeScheduler(ExecutorService executorService) {
        if (executorService instanceof ScheduledExecutorService) {
            ScheduledExecutorService scheduler = (ScheduledExecutorService)executorService;
            this.schedulers.remove(scheduler);
        }
    }

    protected void kill(ExecutorService executorService, long timeoutMs) throws InterruptedException {
        if (!executorService.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
            this.logger.debug(() -> "Kill [{}]", NanoUtils.getThreadName(executorService));
            executorService.shutdownNow();
            if (!executorService.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
                this.logger.warn(() -> "[{}] did not terminate. Is this a glitch in the Matrix?", NanoUtils.getThreadName(executorService));
            }
        }
    }

    protected void executeScheduler(Supplier<Context> context, ExRunnable task, Scheduler scheduler, boolean periodically) {
        try {
            task.run();
            if (!periodically) {
                this.sendEvent(Context.EVENT_APP_SCHEDULER_UNREGISTER, this.context(this.getClass()), scheduler, result -> {}, true);
            }
        }
        catch (Throwable e) {
            NanoUtils.handleJavaError(context, e);
            this.sendEvent(Context.EVENT_APP_SCHEDULER_UNREGISTER, this.context(this.getClass()), scheduler, result -> {}, true);
            this.context(this.getClass()).sendEventError(scheduler, e);
        }
    }
}

