/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core.model;

import berlin.yuna.typemap.model.TypeMap;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.helper.LockedBoolean;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.helper.logger.logic.NanoLogger;
import org.nanonative.nano.services.metric.logic.MetricService;
import org.nanonative.nano.services.metric.model.MetricType;
import org.nanonative.nano.services.metric.model.MetricUpdate;

public abstract class Service {
    protected final String name;
    protected final long createdAtMs;
    protected final LockedBoolean isReady;
    protected final NanoLogger logger = new NanoLogger(this);

    protected Service(String name, boolean isReady) {
        this.createdAtMs = System.currentTimeMillis();
        this.isReady = new LockedBoolean(isReady);
        this.name = name != null ? name : this.getClass().getSimpleName();
    }

    public abstract void start(Supplier<Context> var1);

    public abstract void stop(Supplier<Context> var1);

    public abstract Object onFailure(Event var1);

    public void onEvent(Event event) {
        event.ifPresent(Context.EVENT_CONFIG_CHANGE, TypeMap.class, this.logger::configure);
    }

    public NanoLogger logger() {
        return this.logger;
    }

    public String name() {
        return this.name;
    }

    public boolean isReady() {
        return this.isReady.get();
    }

    public long createdAtMs() {
        return this.createdAtMs;
    }

    public NanoThread nanoThread(Context context) {
        return new NanoThread().run(context.nano() != null ? context.nano().threadPool() : null, () -> context.nano() != null ? context : null, () -> {
            long startTime = System.currentTimeMillis();
            this.logger().level(context.logLevel());
            this.logger().logQueue(context.nano().logger().logQueue());
            this.start(() -> context);
            context.nano().sendEvent(Context.EVENT_APP_SERVICE_REGISTER, context, (Object)this, (Consumer)null, true);
            context.sendEvent(MetricService.EVENT_METRIC_UPDATE, new MetricUpdate(MetricType.GAUGE, "application.services.ready.time", System.currentTimeMillis() - startTime, Map.of("class", this.getClass().getSimpleName())), result -> {});
        }).onComplete((nanoThread, error) -> {
            if (error != null) {
                context.sendEventError(new Event(Context.EVENT_APP_SERVICE_REGISTER, context, this, null), this, (Throwable)error);
            }
        });
    }

    public static NanoThread[] threadsOf(Context context, Service ... services) {
        return (NanoThread[])Arrays.stream(services).map(service -> service.nanoThread(context)).toArray(NanoThread[]::new);
    }
}

