/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipInputStream;
import org.nanonative.nano.core.Nano;
import org.nanonative.nano.core.NanoBase;
import org.nanonative.nano.core.NanoServices;
import org.nanonative.nano.core.NanoThreads;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.core.model.Scheduler;
import org.nanonative.nano.core.model.Service;
import org.nanonative.nano.helper.ExRunnable;

public class NanoUtils {
    public static final String LINE_SEPARATOR = System.lineSeparator();
    protected static Random random;
    public static final String[][] NANO_NAMES;

    public static boolean hasText(String str) {
        return str != null && !str.isEmpty() && NanoUtils.containsText(str);
    }

    public static String formatDuration(long milliseconds) {
        long years = TimeUnit.MILLISECONDS.toDays(milliseconds) / 365L;
        long remainder = milliseconds - TimeUnit.DAYS.toMillis(years * 365L);
        long months = TimeUnit.MILLISECONDS.toDays(remainder) / 30L;
        long days = TimeUnit.MILLISECONDS.toDays(remainder -= TimeUnit.DAYS.toMillis(months * 30L));
        long hours = TimeUnit.MILLISECONDS.toHours(remainder -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(remainder -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(remainder -= TimeUnit.MINUTES.toMillis(minutes));
        remainder -= TimeUnit.SECONDS.toMillis(seconds);
        StringBuilder sb = new StringBuilder();
        if (years > 0L) {
            sb.append(years).append("y ");
        }
        if (months > 0L) {
            sb.append(months).append("mo ");
        }
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (seconds > 0L) {
            sb.append(seconds).append("s ");
        }
        if (remainder > 0L) {
            sb.append(remainder).append("ms");
        }
        return sb.toString().trim();
    }

    public static boolean waitForCondition(BooleanSupplier condition) {
        return NanoUtils.waitForCondition(condition, 2000L);
    }

    public static boolean waitForCondition(BooleanSupplier condition, long timeout) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < timeout) {
            if (condition.getAsBoolean()) {
                return true;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(64L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return false;
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String[] split(String input, String delimiter) {
        int index;
        if (!input.contains(delimiter)) {
            return new String[]{input};
        }
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        while ((index = input.indexOf(delimiter, start)) != -1) {
            result.add(input.substring(start, index));
            start = index + delimiter.length();
        }
        result.add(input.substring(start));
        return result.toArray(new String[0]);
    }

    public static String callerInfoStr(Class<?> source) {
        StackTraceElement element = NanoUtils.callerInfo(source);
        return element == null ? "Unknown" : String.format("%s:%d_at_%s", element.getClassName(), element.getLineNumber(), element.getMethodName());
    }

    public static StackTraceElement callerInfo(Class<?> source) {
        StackTraceElement[] stackTrace;
        List<String> sourceNames = List.of(source.getName(), Service.class.getName(), NanoBase.class.getName(), NanoUtils.class.getName(), NanoThread.class.getName(), NanoThreads.class.getName(), NanoServices.class.getName());
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            if (sourceNames.contains(element.getClassName()) || element.getClassName().startsWith("java.lang.Thread")) continue;
            return element;
        }
        return stackTrace.length > 2 ? stackTrace[2] : null;
    }

    public static String getThreadName(ExecutorService executorService) {
        if (executorService instanceof Scheduler) {
            Scheduler scheduler = (Scheduler)executorService;
            return scheduler.id();
        }
        if (executorService instanceof ScheduledExecutorService) {
            return "Scheduler";
        }
        return executorService.getClass().getSimpleName();
    }

    public static Context readConfigFiles(Context context, String profile) {
        Context result = context != null ? context : Context.createRootContext(Nano.class);
        List scannedProfiles = (List)result.asList(ArrayList::new, String.class, new Object[]{"_scanned_profiles"});
        if (scannedProfiles.contains(profile)) {
            return result;
        }
        if (!"".equals(profile)) {
            scannedProfiles.add(profile);
        }
        result.put("_scanned_profiles", scannedProfiles);
        for (String directory : new String[]{"", ".", "config/", ".config/", "resources/", ".resources/", "resources/config/", ".resources/config/"}) {
            NanoUtils.readConfigFile(result, directory + "application" + (String)(profile.isEmpty() ? profile : "-" + profile) + ".properties");
        }
        return NanoUtils.readProfiles(result);
    }

    public static Context readProfiles(Context result) {
        for (String pConfig : new String[]{Context.CONFIG_PROFILES, "app_profile", "spring_profiles_active", "spring_profile_active", "profiles_active", "micronaut_profiles", "micronaut_environments"}) {
            result.asStringOpt(new Object[]{pConfig}).ifPresent(profiles -> Arrays.stream(NanoUtils.split(profiles, ",")).map(String::trim).forEach(name -> NanoUtils.readConfigFiles(result, name)));
        }
        return result;
    }

    public static Context readConfigFile(Context context, String path) {
        try (InputStream input = path.startsWith(".") ? new FileInputStream(path.substring(1)) : NanoUtils.class.getClassLoader().getResourceAsStream(path);){
            if (input != null) {
                Properties properties = new Properties();
                properties.load(input);
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> NanoUtils.addConfig(context, key, value)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return context;
    }

    public static Context addConfig(Context context, Object key, Object value) {
        String valueStr;
        if (value == null || "null".equals(value) || "".equals(value)) {
            context.remove(NanoBase.standardiseKey(key));
        } else if (value instanceof String && NanoUtils.hasText(valueStr = (String)value)) {
            context.put(NanoBase.standardiseKey(key), valueStr.trim());
        } else {
            context.put(NanoBase.standardiseKey(key), value);
        }
        return context;
    }

    public static Context resolvePlaceHolders(Context context) {
        context.forEach((key, value) -> {
            String valueStr;
            if (value instanceof String && (valueStr = (String)value).startsWith("${") && valueStr.endsWith("}")) {
                String[] placeholder = NanoUtils.split(valueStr.substring(2, valueStr.length() - 1), ":");
                NanoUtils.addConfig(context, key, context.asOpt(Object.class, new Object[]{NanoBase.standardiseKey(placeholder[0])}).orElseGet(() -> placeholder.length > 1 ? placeholder[1].trim() : null));
            }
        });
        return context;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] encodeGzip(byte[] data) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);){
                gzipOutputStream.write(data);
                gzipOutputStream.finish();
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException ignored) {
            return data;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] decodeZip(byte[] data) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            byte[] byArray;
            try (ZipInputStream gzipInputStream = new ZipInputStream(inputStream);){
                byArray = gzipInputStream.readAllBytes();
            }
            return byArray;
        }
        catch (Exception ignored) {
            return data;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] decodeGzip(byte[] data) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            byte[] byArray;
            try (GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);){
                byArray = gzipInputStream.readAllBytes();
            }
            return byArray;
        }
        catch (Exception ignored) {
            return data;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] encodeDeflate(byte[] data) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(outputStream);){
                deflaterOutputStream.write(data);
                deflaterOutputStream.finish();
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
        catch (Exception ignored) {
            return data;
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] decodeDeflate(byte[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String generateNanoName(String format) {
        if (random == null) {
            random = new Random();
        }
        return String.format(format, NANO_NAMES[0][random.nextInt(NANO_NAMES[0].length)], random.nextInt(0, 99) + "." + random.nextInt(0, 9), NANO_NAMES[1][random.nextInt(NANO_NAMES[1].length)], NANO_NAMES[2][random.nextInt(NANO_NAMES[2].length)]);
    }

    public static void handleJavaError(Supplier<Context> context, Throwable error) {
        if (error instanceof Error) {
            Optional.ofNullable(context).map(Supplier::get).ifPresentOrElse(ctx -> ctx.logger().fatal(error, () -> "It seems like the dark side of the JVM has struck again. Your scenario [{}]. May the garbage collector be with you!", error.getMessage()), () -> System.err.println(error.getMessage()));
            System.exit(1);
        }
    }

    public static void tryExecute(Supplier<Context> context, ExRunnable operation) {
        NanoUtils.tryExecute(context, operation, null);
    }

    public static void tryExecute(Supplier<Context> context, ExRunnable operation, Consumer<Throwable> consumer) {
        block2: {
            try {
                operation.run();
            }
            catch (Throwable exception) {
                NanoUtils.handleJavaError(context, exception);
                if (consumer == null) break block2;
                consumer.accept(exception);
            }
        }
    }

    private NanoUtils() {
    }

    static {
        NANO_NAMES = new String[][]{{"NanoNinja", "NanoNoodle", "GraalGuru", "JavaJester", "MicroMaverick", "ByteBender", "NanoNaut", "GraalGoblin", "JavaJuggernaut", "CodeComedian", "NanoNomad", "GraalGazelle", "JavaJinx", "MicroMagician", "ByteBandit", "NanoNimbus", "GraalGambler", "JavaJester", "MicroMaestro", "ByteBarracuda", "NanoNebula"}, {"Swift Swiper", "Master", "Joker", "Rebel", "Twister", "Navigator", "Mischievous", "Unstoppable", "Laughs", "Wanderer", "Graceful", "Bringer", "Wizard", "Stealer", "Cloud Surfer", "Betting", "Prankster", "Conductor", "Feisty Fish", "Galactic Guardian"}, {"of Requests", "of Native Magic", "in the Microservice Deck", "in the Server Space", "of Bytes", "of the Nano Cosmos", "Microservice Minion", "Force of the JVM", "in Lambda Expressions", "in the Backend Wilderness", "GraalVM Gazelle", "Bringer of Backend Blessings", "of the Microservice Realm", "of Server Secrets", "of the Nanoverse", "on Backend Brilliance", "in the Programming Playground", "of the Microservice Orchestra", "in the Server Sea", "of Microservices", "of Nano Power", "in Nano Land", "near Nano Destiny"}};
    }
}

