/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.helper.event.model;

import berlin.yuna.typemap.logic.TypeConverter;
import berlin.yuna.typemap.model.Type;
import berlin.yuna.typemap.model.TypeMap;
import java.util.Optional;
import java.util.function.Consumer;
import org.nanonative.nano.core.Nano;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.helper.event.EventChannelRegister;
import org.nanonative.nano.helper.logger.logic.NanoLogger;

public class Event {
    protected int channelId;
    protected final long createdAtMs;
    protected final Context context;
    protected final Consumer<Object> responseListener;
    protected final Object payload;
    protected TypeMap cache;
    protected Object response;
    protected Throwable error;
    public static final String EVENT_ORIGINAL_CHANNEL_ID = "app_original_event_channel_id";

    public Event(int channelId, Context context, Object payload, Consumer<Object> responseListener) {
        this.context = context;
        this.channelId = channelId;
        this.responseListener = responseListener;
        this.payload = payload;
        this.createdAtMs = System.currentTimeMillis();
    }

    public String name() {
        return EventChannelRegister.eventNameOf(this.channelId);
    }

    public String nameOrg() {
        return EventChannelRegister.eventNameOf(this.channelIdOrg());
    }

    public Nano nano() {
        return this.context.nano();
    }

    public int channelId() {
        return this.channelId;
    }

    public int channelIdOrg() {
        return Optional.ofNullable(this.cache).map(c -> c.asIntOpt(new Object[]{EVENT_ORIGINAL_CHANNEL_ID})).map(Type::value).orElse(this.channelId);
    }

    public Event channelId(int channelId) {
        this.channelId = channelId;
        return this;
    }

    public long createdAtMs() {
        return this.createdAtMs;
    }

    public Event ifPresent(int channelId, Consumer<Event> consumer) {
        if (this.channelId == channelId) {
            consumer.accept(this);
        }
        return this;
    }

    public Event ifPresentAck(int channelId, Consumer<Event> consumer) {
        if (this.channelId == channelId) {
            consumer.accept(this);
            this.acknowledge();
        }
        return this;
    }

    public <T> Event ifPresent(int channelId, Class<T> clazz, Consumer<T> consumer) {
        T payloadObj;
        if (this.channelId == channelId && (payloadObj = this.payload(clazz)) != null) {
            consumer.accept(payloadObj);
        }
        return this;
    }

    public <T> Event ifPresentAck(int channelId, Class<T> clazz, Consumer<T> consumer) {
        T payloadObj;
        if (this.channelId == channelId && (payloadObj = this.payload(clazz)) != null) {
            consumer.accept(payloadObj);
            this.acknowledge();
        }
        return this;
    }

    public NanoLogger logger() {
        return this.context.logger();
    }

    public Object payload() {
        return this.payload;
    }

    public boolean isAcknowledged() {
        return this.response != null;
    }

    public Optional<Object> payloadOpt() {
        return Optional.ofNullable(this.payload);
    }

    public <T> T payload(Class<T> type) {
        return (T)TypeConverter.convertObj((Object)this.payload, type);
    }

    public <T> Optional<T> payloadOpt(Class<T> type) {
        return Optional.ofNullable(TypeConverter.convertObj((Object)this.payload, type));
    }

    public Context context() {
        return this.context;
    }

    public Consumer<Object> responseListener() {
        return this.responseListener;
    }

    public Event acknowledge() {
        return this.acknowledge(null);
    }

    public Event acknowledge(Runnable response) {
        if (response != null) {
            response.run();
        }
        return this.response(true);
    }

    public Event response(Object response) {
        if (this.responseListener != null) {
            this.responseListener.accept(response);
        }
        this.response = response;
        return this;
    }

    public <T> T response(Class<T> type) {
        return (T)TypeConverter.convertObj((Object)this.response, type);
    }

    public <T> Optional<T> responseOpt(Class<T> type) {
        return Optional.ofNullable(this.response(type));
    }

    public Object response() {
        return this.response;
    }

    public Event peek(Consumer<Event> peek) {
        if (peek != null) {
            peek.accept(this);
        }
        return this;
    }

    public Event put(Object key, Object value) {
        this.context.put(key, value);
        return this;
    }

    public Event cache(Object key, Object value) {
        this.cache().put(key, value);
        return this;
    }

    public TypeMap cache() {
        if (this.cache == null) {
            this.cache = new TypeMap();
        }
        return this.cache;
    }

    public Throwable error() {
        return this.error;
    }

    public Event error(Throwable error) {
        this.error = error;
        return this;
    }

    public String toString() {
        return "Event{name=" + this.name() + ", ack=" + (this.response != null) + ", listener=" + (this.response != null) + ", context=" + this.context.size() + ", createdAtMs=" + this.createdAtMs + "}";
    }
}

