/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.services.http.logic;

import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.nanonative.nano.core.NanoThreads;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.services.http.HttpService;
import org.nanonative.nano.services.http.model.HttpObject;

public class HttpClient {
    protected final Context context;
    protected final java.net.http.HttpClient client;
    protected final int retries;
    protected final int readTimeoutMs;

    public HttpClient() {
        this(null, null);
    }

    public HttpClient(Context context) {
        this(context, null);
    }

    public HttpClient(Context context, java.net.http.HttpClient client) {
        this.context = context;
        this.client = client != null ? client : java.net.http.HttpClient.newBuilder().connectTimeout(Duration.ofMillis(Optional.ofNullable(context).map(ctx -> ctx.asLong(new Object[]{HttpService.CONFIG_HTTP_CLIENT_CON_TIMEOUT_MS})).orElse(5000L))).followRedirects(Optional.ofNullable(context).map(ctx -> ctx.asBoolean(new Object[]{HttpService.CONFIG_HTTP_CLIENT_FOLLOW_REDIRECTS})).orElse(true) != false ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER).version(Optional.ofNullable(context).map(ctx -> (HttpClient.Version)((Object)((Object)ctx.as(HttpClient.Version.class, new Object[]{HttpService.CONFIG_HTTP_CLIENT_VERSION})))).orElse(HttpClient.Version.HTTP_2)).executor(Optional.ofNullable(context).map(Context::nano).map(NanoThreads::threadPool).orElse(NanoThread.VIRTUAL_THREAD_POOL)).build();
        this.retries = Optional.ofNullable(context).map(ctx -> ctx.asInt(new Object[]{HttpService.CONFIG_HTTP_CLIENT_MAX_RETRIES})).orElse(3);
        this.readTimeoutMs = Optional.ofNullable(context).map(ctx -> ctx.asInt(new Object[]{HttpService.CONFIG_HTTP_CLIENT_READ_TIMEOUT_MS})).orElse(10000);
    }

    public Context context() {
        return this.context;
    }

    public int retries() {
        return this.retries;
    }

    public boolean followRedirects() {
        return HttpClient.Redirect.ALWAYS.equals((Object)this.client.followRedirects());
    }

    public int readTimeoutMs() {
        return this.readTimeoutMs;
    }

    public long connectionTimeoutMs() {
        return this.client.connectTimeout().map(Duration::toMillis).orElse(-1L);
    }

    public HttpClient.Version version() {
        return this.client.version();
    }

    public java.net.http.HttpClient client() {
        return this.client;
    }

    public HttpObject send(HttpRequest request) {
        return this.send(request, null);
    }

    public HttpObject send(HttpRequest request, Consumer<HttpObject> callback) {
        if (request instanceof HttpObject) {
            HttpObject httpObject = (HttpObject)request;
            httpObject.timeout(this.readTimeoutMs);
        }
        return request != null ? this.send(0, request, new HttpObject(), callback) : new HttpObject().failure(400, new IllegalArgumentException("Invalid request [null]"));
    }

    protected HttpObject send(int attempt, HttpRequest request, HttpObject response, Consumer<HttpObject> callback) {
        try {
            if (callback == null) {
                return this.responseOf(this.client.send(request, HttpResponse.BodyHandlers.ofByteArray()), response);
            }
            ((CompletableFuture)this.client.sendAsync(request, HttpResponse.BodyHandlers.ofByteArray()).thenAccept(httpResponse -> this.responseOf((HttpResponse<byte[]>)httpResponse, response))).thenRun(() -> callback.accept(response));
        }
        catch (IOException e) {
            return this.circuitBreaker(attempt, request, response, callback, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            return response.path(request.uri().toString()).statusCode(400).failure(-1, e);
        }
        return response;
    }

    protected HttpObject responseOf(HttpResponse<byte[]> httpResponse, HttpObject response) {
        HttpObject result = response.statusCode(httpResponse.statusCode()).methodType(httpResponse.request().method()).path(httpResponse.uri().getPath()).headerMap(httpResponse.headers().map());
        return result.body(httpResponse.body());
    }

    protected HttpObject circuitBreaker(int attempt, HttpRequest request, HttpObject response, Consumer<HttpObject> callback, Throwable throwable) {
        if (attempt < this.retries) {
            try {
                Thread.sleep((long)Math.pow(2.0, attempt) * 256L);
                return this.send(attempt + 1, request, response, callback);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return response.path(request.uri().toString()).failure(-99, ie);
            }
        }
        return response.path(request.uri().toString()).failure(-1, throwable);
    }

    public String toString() {
        return "HttpClient{version=" + String.valueOf((Object)this.version()) + ", retries=" + this.retries + ", followRedirects=" + this.followRedirects() + ", readTimeoutMs=" + this.readTimeoutMs + ", connectionTimeoutMs=" + this.connectionTimeoutMs() + "}";
    }
}

