/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.nanonative.nano.core.NanoBase;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.core.model.Scheduler;
import org.nanonative.nano.helper.ExRunnable;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.event.model.Event;

public abstract class NanoThreads<T extends NanoThreads<T>>
extends NanoBase<T> {
    protected final Set<ScheduledExecutorService> schedulers = ConcurrentHashMap.newKeySet();

    protected NanoThreads(Map<Object, Object> config, String ... args) {
        super(config, args);
        this.subscribeEvent(Context.EVENT_APP_SCHEDULER_REGISTER, event -> event.payloadOpt(ScheduledExecutorService.class).map(this.schedulers::add).ifPresent(nano -> event.acknowledge()));
        this.subscribeEvent(Context.EVENT_APP_SCHEDULER_UNREGISTER, event -> event.payloadOpt(ScheduledExecutorService.class).map(scheduler -> {
            scheduler.shutdown();
            this.schedulers.remove(scheduler);
            return this;
        }).ifPresent(nano -> event.acknowledge()));
    }

    public static void runAsync(Runnable task) {
        NanoThread.GLOBAL_THREAD_POOL.submit(task);
    }

    public Set<ScheduledExecutorService> schedulers() {
        return Collections.unmodifiableSet(this.schedulers);
    }

    public T run(Supplier<Context> context, ExRunnable task, long delay, TimeUnit timeUnit) {
        Scheduler scheduler = this.asyncFromPool(context);
        scheduler.schedule(() -> this.executeScheduler(context, task, scheduler, false), delay, timeUnit);
        return (T)this;
    }

    public T run(Supplier<Context> context, ExRunnable task, long delay, long period, TimeUnit unit, BooleanSupplier until) {
        Scheduler scheduler = this.asyncFromPool(context);
        scheduler.scheduleAtFixedRate(() -> {
            if (until.getAsBoolean()) {
                scheduler.shutdown();
            } else {
                this.executeScheduler(context, task, scheduler, true);
            }
        }, delay, period, unit);
        return (T)this;
    }

    public T run(Supplier<Context> context, ExRunnable task, LocalTime atTime, DayOfWeek dow, BooleanSupplier until) {
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime nextRun = now.withHour(atTime.getHour()).withMinute(atTime.getMinute()).withSecond(atTime.getSecond());
        if (dow != null) {
            if ((nextRun = nextRun.with(TemporalAdjusters.nextOrSame(dow))).isBefore(now)) {
                nextRun = nextRun.with(TemporalAdjusters.next(dow));
            }
        } else if (nextRun.isBefore(now)) {
            nextRun = nextRun.plusDays(1L);
        }
        return this.run(context, task, Duration.between(now, nextRun).getSeconds(), dow != null ? TimeUnit.DAYS.toSeconds(7L) : TimeUnit.DAYS.toSeconds(1L), TimeUnit.SECONDS, until);
    }

    protected Scheduler asyncFromPool(final Supplier<Context> context) {
        final String schedulerId = NanoUtils.callerInfoStr(this.getClass()) + "_" + String.valueOf(UUID.randomUUID());
        Scheduler scheduler = new Scheduler(this, schedulerId){

            @Override
            protected void beforeExecute(Thread t, Runnable r) {
                t.setName("Scheduler_" + schedulerId);
                try {
                    NanoThread.GLOBAL_THREAD_POOL.submit(r);
                }
                catch (Throwable error) {
                    NanoUtils.handleJavaError(context, error);
                }
            }
        };
        Event.eventOf(this.context(Scheduler.class), Context.EVENT_APP_SCHEDULER_REGISTER).payload(() -> scheduler).broadcast(true).async(true).send();
        return scheduler;
    }

    protected void shutdownThreads() {
        long timeoutMs = (Long)this.context.asLongOpt(new Object[]{Context.CONFIG_THREAD_POOL_TIMEOUT_MS}).filter(l -> l > 0L).orElse((Object)500L);
        this.context.debug(() -> "Shutdown schedulers [{}]", this.schedulers.size());
        this.shutdownExecutors(timeoutMs, (ExecutorService[])this.schedulers.toArray(ScheduledExecutorService[]::new));
    }

    protected void shutdownExecutors(long timeoutMs, ExecutorService ... executorServices) {
        Arrays.stream(executorServices).forEach(ExecutorService::shutdown);
        ((Stream)Arrays.stream(executorServices).parallel()).forEach(executorService -> {
            executorService.shutdown();
            try {
                this.kill((ExecutorService)executorService, timeoutMs);
                this.removeScheduler((ExecutorService)executorService);
            }
            catch (InterruptedException ie) {
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        });
    }

    protected void removeScheduler(ExecutorService executorService) {
        if (executorService instanceof ScheduledExecutorService) {
            ScheduledExecutorService scheduler = (ScheduledExecutorService)executorService;
            this.schedulers.remove(scheduler);
        }
    }

    protected void kill(ExecutorService executorService, long timeoutMs) throws InterruptedException {
        if (!executorService.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
            this.context.debug(() -> "Kill [{}]", NanoUtils.getThreadName(executorService));
            executorService.shutdownNow();
            if (!executorService.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
                this.context.warn(() -> "[{}] did not terminate. Is this a glitch in the Matrix?", NanoUtils.getThreadName(executorService));
            }
        }
    }

    protected void executeScheduler(Supplier<Context> context, ExRunnable task, Scheduler scheduler, boolean periodically) {
        try {
            task.run();
            if (!periodically) {
                Event.eventOf(this.context(this.getClass()), Context.EVENT_APP_SCHEDULER_UNREGISTER).payload(() -> scheduler).async(true).send();
            }
        }
        catch (Throwable e) {
            NanoUtils.handleJavaError(context, e);
            Event.eventOf(this.context(this.getClass()), Context.EVENT_APP_SCHEDULER_UNREGISTER).payload(() -> scheduler).broadcast(true).async(true).send();
            this.context(this.getClass()).sendEventError(scheduler, e);
        }
    }
}

