/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core.model;

import berlin.yuna.typemap.config.TypeConversionRegister;
import berlin.yuna.typemap.model.ConcurrentTypeMap;
import berlin.yuna.typemap.model.LinkedTypeMap;
import java.net.http.HttpClient;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Stream;
import org.nanonative.nano.core.Nano;
import org.nanonative.nano.core.NanoServices;
import org.nanonative.nano.core.NanoThreads;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.core.model.Service;
import org.nanonative.nano.core.model.Unhandled;
import org.nanonative.nano.helper.ExRunnable;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.config.ConfigRegister;
import org.nanonative.nano.helper.event.EventChannelRegister;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.services.http.model.ContentType;
import org.nanonative.nano.services.http.model.HttpMethod;
import org.nanonative.nano.services.logging.LogFormatRegister;
import org.nanonative.nano.services.logging.LogService;
import org.nanonative.nano.services.logging.model.LogLevel;

public class Context
extends ConcurrentTypeMap {
    public static final String CONTEXT_TRACE_ID_KEY = "app_core_context_trace_id";
    public static final String CONTEXT_PARENT_KEY = "app_core_context_parent";
    public static final String CONTEXT_CLASS_KEY = "app_core_context_class";
    public static final String CONTEXT_NANO_KEY = "app_core_context_nano";
    public static final String CONTEXT_LOG_QUEUE_KEY = "app_core_context_log_queue";
    public static final String APP_HELP = ConfigRegister.registerConfig("help", "Lists available config keys");
    public static final String APP_PARAMS = ConfigRegister.registerConfig("app_params_print", "Pints all config values");
    public static final String CONFIG_PROFILES = ConfigRegister.registerConfig("app_profiles", "Active config profiles for the application");
    public static final String CONFIG_THREAD_POOL_TIMEOUT_MS = ConfigRegister.registerConfig("app_thread_pool_shutdown_timeout_ms", "Timeout for thread pool shutdown in milliseconds (see " + NanoThreads.class.getSimpleName() + ")");
    public static final String CONFIG_PARALLEL_SHUTDOWN = ConfigRegister.registerConfig("app_service_shutdown_parallel", "Enable or disable parallel service shutdown (see " + NanoServices.class.getSimpleName() + "). Enabled = Can increase the shutdown performance on`true`");
    public static final String CONFIG_OOM_SHUTDOWN_THRESHOLD = ConfigRegister.registerConfig("app_oom_shutdown_threshold", "Sets the threshold for heap in percentage to send an `EVENT_APP_OOM`. default = `98`, disabled = `-1`. If the event is unhandled, tha pp will try to shutdown with last resources");
    public static final String CONFIG_ENV_PROD = ConfigRegister.registerConfig("app_env_prod", "Enable or disable behaviour e.g. exit codes. This is useful in prod environments specially on error cases. default = `false`");
    public static final int EVENT_APP_START = EventChannelRegister.registerChannelId("APP_START");
    public static final int EVENT_APP_SHUTDOWN = EventChannelRegister.registerChannelId("APP_SHUTDOWN");
    public static final int EVENT_APP_SERVICE_REGISTER = EventChannelRegister.registerChannelId("APP_SERVICE_REGISTER");
    public static final int EVENT_APP_SERVICE_UNREGISTER = EventChannelRegister.registerChannelId("APP_SERVICE_UNREGISTER");
    public static final int EVENT_APP_SCHEDULER_REGISTER = EventChannelRegister.registerChannelId("APP_SCHEDULER_REGISTER");
    public static final int EVENT_APP_SCHEDULER_UNREGISTER = EventChannelRegister.registerChannelId("APP_SCHEDULER_UNREGISTER");
    public static final int EVENT_APP_UNHANDLED = EventChannelRegister.registerChannelId("EVENT_APP_UNHANDLED");
    public static final int EVENT_APP_ERROR = EventChannelRegister.registerChannelId("EVENT_APP_ERROR");
    public static final int EVENT_APP_OOM = EventChannelRegister.registerChannelId("EVENT_APP_OOM");
    public static final int EVENT_APP_HEARTBEAT = EventChannelRegister.registerChannelId("EVENT_HEARTBEAT");
    public static final int EVENT_CONFIG_CHANGE = EventChannelRegister.registerChannelId("EVENT_CONFIG_CHANGE");
    protected transient Nano nano;

    public static Context createRootContext(Class<?> clazz) {
        return new Context(clazz);
    }

    public Nano nano() {
        if (this.nano == null) {
            this.nano = (Nano)this.get(Nano.class, new Object[]{CONTEXT_NANO_KEY});
        }
        return this.nano;
    }

    public Context parent() {
        return (Context)((Object)this.as(Context.class, new Object[]{CONTEXT_PARENT_KEY}));
    }

    public String traceId() {
        return (String)this.get(String.class, new Object[]{CONTEXT_TRACE_ID_KEY});
    }

    public String traceId(int index) {
        return index < 1 ? this.traceId() : Stream.iterate(Optional.of(this), opt -> opt.flatMap(ctx -> Optional.ofNullable(ctx.parent()))).limit((long)index + 1L).reduce((first, second) -> second).flatMap(ctx -> ctx.map(Context::traceId)).orElse(this.traceId());
    }

    public List<String> traceIds() {
        return Stream.iterate(Optional.of(this), Optional::isPresent, opt -> opt.flatMap(ctx -> Optional.ofNullable(ctx.parent()))).map(opt -> opt.flatMap(ctx -> Optional.ofNullable(ctx.traceId()))).flatMap(Optional::stream).toList();
    }

    public Context fatal(Supplier<String> message, Object ... params) {
        return this.log(LogLevel.FATAL, null, message, params);
    }

    public Context fatal(Throwable thrown, Supplier<String> message, Object ... params) {
        return this.log(LogLevel.FATAL, thrown, message, params);
    }

    public Context error(Supplier<String> message, Object ... params) {
        return this.log(LogLevel.ERROR, null, message, params);
    }

    public Context error(Throwable thrown, Supplier<String> message, Object ... params) {
        return this.log(LogLevel.ERROR, thrown, message, params);
    }

    public Context warn(Supplier<String> message, Object ... params) {
        return this.log(LogLevel.WARN, null, message, params);
    }

    public Context warn(Throwable thrown, Supplier<String> message, Object ... params) {
        return this.log(LogLevel.WARN, thrown, message, params);
    }

    public Context info(Supplier<String> message, Object ... params) {
        return this.log(LogLevel.INFO, null, message, params);
    }

    public Context info(Throwable thrown, Supplier<String> message, Object ... params) {
        return this.log(LogLevel.INFO, thrown, message, params);
    }

    public Context debug(Supplier<String> message, Object ... params) {
        return this.log(LogLevel.DEBUG, null, message, params);
    }

    public Context debug(Throwable thrown, Supplier<String> message, Object ... params) {
        return this.log(LogLevel.DEBUG, thrown, message, params);
    }

    public Context trace(Supplier<String> message, Object ... params) {
        return this.log(LogLevel.TRACE, null, message, params);
    }

    public Context trace(Throwable thrown, Supplier<String> message, Object ... params) {
        return this.log(LogLevel.TRACE, thrown, message, params);
    }

    public Context log(LogLevel level, Supplier<String> message, Object ... params) {
        return this.log(level, null, message, params);
    }

    public Context log(LogLevel level, Throwable thrown, Supplier<String> message, Object ... params) {
        this.newEvent(LogService.EVENT_LOGGING).async(true).broadcast(false).payload(() -> {
            LogRecord logRecord = new LogRecord(level.toJavaLogLevel(), (String)message.get());
            logRecord.setParameters(params);
            logRecord.setThrown(thrown);
            logRecord.setLoggerName(this.clazz().getCanonicalName());
            return logRecord;
        }).putR("level", (Object)level).putR("name", this.clazz().getCanonicalName()).send();
        return this;
    }

    public Context newContext(Class<?> clazz) {
        return new Context(this, clazz, false);
    }

    public Context newEmptyContext(Class<?> clazz) {
        return new Context(this, clazz, true);
    }

    public Context put(Object key, Object value) {
        super.put(key, value != null ? value : "");
        return this;
    }

    public Context putR(Object key, Object value) {
        this.put(key, value);
        return this;
    }

    public Context subscribeEvent(int channelId, Consumer<Event> listener) {
        this.nano().subscribeEvent(channelId, listener);
        return this;
    }

    public Context unsubscribeEvent(int channelId, Consumer<Event> listener) {
        this.nano().unsubscribeEvent(channelId, listener);
        return this;
    }

    public Context run(ExRunnable task, long delay, TimeUnit timeUnit) {
        this.nano().run(() -> this, task, delay, timeUnit);
        return this;
    }

    public Context run(ExRunnable task, long delay, long period, TimeUnit unit) {
        return this.run(task, delay, period, unit, () -> false);
    }

    public Context run(ExRunnable task, long delay, long period, TimeUnit unit, BooleanSupplier until) {
        this.nano().run(() -> this, task, delay, period, unit, until);
        return this;
    }

    public Context run(ExRunnable task, LocalTime atTime) {
        return this.run(task, atTime, () -> false);
    }

    public Context run(ExRunnable task, LocalTime atTime, BooleanSupplier until) {
        return this.run(task, atTime, null, until);
    }

    public Context run(ExRunnable task, LocalTime atTime, DayOfWeek dow, BooleanSupplier until) {
        this.nano().run(() -> this, task, atTime, dow, until);
        return this;
    }

    public final Context run(ExRunnable ... runnable) {
        this.runR(runnable);
        return this;
    }

    public final Context runHandled(Consumer<Unhandled> onFailure, ExRunnable ... runnable) {
        this.runReturnHandled(onFailure, runnable);
        return this;
    }

    public Context run(Service ... services) {
        this.runR(services);
        return this;
    }

    public final NanoThread[] runR(ExRunnable ... runnable) {
        return (NanoThread[])Arrays.stream(runnable).map(task -> new NanoThread().run(() -> this, (ExRunnable)task)).toArray(NanoThread[]::new);
    }

    public final NanoThread[] runReturnHandled(Consumer<Unhandled> onFailure, ExRunnable ... runnable) {
        return (NanoThread[])Arrays.stream(runnable).map(task -> new NanoThread().onComplete((thread, error) -> {
            if (error != null) {
                onFailure.accept(new Unhandled(this, thread, (Throwable)error));
            }
        }).run(() -> this, (ExRunnable)task)).toArray(NanoThread[]::new);
    }

    public NanoThread[] runR(Service ... services) {
        try {
            return Service.threadsOf(this, services);
        }
        catch (Exception exception) {
            this.sendEventError(services.length == 1 ? services[0] : services, exception);
            Thread.currentThread().interrupt();
            return new NanoThread[0];
        }
    }

    public final Context runAwait(ExRunnable ... runnable) {
        NanoThread.waitFor(this.runR(runnable));
        return this;
    }

    public final Context runAwaitHandled(Consumer<Unhandled> onFailure, ExRunnable ... runnable) {
        NanoThread.waitFor(this.runReturnHandled(onFailure, runnable));
        return this;
    }

    public Context runAwait(Service ... services) {
        this.runAwaitR(services);
        return this;
    }

    public final NanoThread[] runAwaitR(ExRunnable ... runnable) {
        return NanoThread.waitFor(this.runR(runnable));
    }

    public final NanoThread[] runAwaitRHandled(Consumer<Unhandled> onFailure, ExRunnable ... runnable) {
        return NanoThread.waitFor(this.runReturnHandled(onFailure, runnable));
    }

    public NanoThread[] runAwaitR(Service ... services) {
        return NanoThread.waitFor(this.runR(services));
    }

    public Context sendEventError(Object payload, Throwable throwable) {
        Event evt;
        Event event;
        Event event2 = event = payload instanceof Event ? (evt = (Event)((Object)payload)) : Event.eventOf(this, EVENT_APP_ERROR).payload(() -> payload);
        if (event.channelId() != EVENT_APP_UNHANDLED) {
            event.remove("send");
            this.nano().sendEventSameThread(event.putR("app_original_event_channel_id", event.channelId()).channelId(EVENT_APP_UNHANDLED).error(throwable));
            if (!event.isAcknowledged()) {
                this.error(throwable, () -> "Event [{}] went rogue.", event.nameOrg());
            }
        } else {
            this.error(throwable, () -> "Event [{}] went rogue.", event.nameOrg());
        }
        return this;
    }

    public Context sendEventError(Event event, Service service, Throwable throwable) {
        if (event.channelId() == EVENT_APP_UNHANDLED) {
            event.context().error(throwable, () -> "Unhandled event [{}] service [{}]", event.nameOrg(), service.name());
        }
        if (service.onFailure(event.error(throwable)) == null) {
            event.context().sendEventError((Object)event, throwable);
        }
        return this;
    }

    public Context sendEvent(int channelId, Supplier<Object> payload) {
        return this.sendEvent(channelId, payload, null);
    }

    public Context sendEvent(int channelId, Supplier<Object> payload, Consumer<Object> responseListener) {
        this.sendEventR(channelId, payload, responseListener);
        return this;
    }

    public Context broadcastEvent(int channelId, Supplier<Object> payload) {
        return this.broadcastEvent(channelId, payload, null);
    }

    public Context broadcastEvent(int channelId, Supplier<Object> payload, Consumer<Object> responseListener) {
        this.broadcastEventR(channelId, payload, responseListener);
        return this;
    }

    public Event sendEventR(int channelId, Supplier<Object> payload) {
        return this.sendEventR(channelId, payload, null);
    }

    public Event sendEventR(int channelId, Supplier<Object> payload, Consumer<Object> responseListener) {
        return this.newEvent(channelId).payload(payload).async(responseListener).send();
    }

    public Event broadcastEventR(int channelId, Supplier<Object> payload) {
        return this.broadcastEventR(channelId, payload, null);
    }

    public Event broadcastEventR(int channelId, Supplier<Object> payload, Consumer<Object> responseListener) {
        return this.newEvent(channelId).payload(payload).async(responseListener).send();
    }

    public Event newEvent(int channelId) {
        return Event.eventOf(this, channelId);
    }

    public int registerChannelId(String channelName) {
        return EventChannelRegister.registerChannelId(channelName);
    }

    public <S extends Service> S service(Class<S> serviceClass) {
        return this.nano().service(serviceClass);
    }

    public <S extends Service> List<S> services(Class<S> serviceClass) {
        return this.nano().services(serviceClass);
    }

    public List<Service> services() {
        return this.nano().services();
    }

    protected Context(Class<?> clazz) {
        this(null, clazz, false);
    }

    protected Context(Context parent, Class<?> clazz) {
        this(parent, clazz, false);
    }

    protected Context(Context parent, Class<?> clazz, boolean empty) {
        super((Map)((Object)(empty ? null : parent)));
        Class<?> resolvedClass = clazz != null ? clazz : (parent == null ? Context.class : parent.clazz());
        this.put(CONTEXT_NANO_KEY, parent != null ? parent.as(Nano.class, new Object[]{CONTEXT_NANO_KEY}) : null);
        this.put(CONTEXT_CLASS_KEY, resolvedClass);
        this.put(CONTEXT_TRACE_ID_KEY, resolvedClass.getSimpleName() + "/" + UUID.randomUUID().toString().replace("-", ""));
        if (parent != null) {
            this.put(CONTEXT_PARENT_KEY, (Object)parent);
        }
        LogService.MAX_LOG_NAME_LENGTH.updateAndGet(length -> Math.max(length, resolvedClass.getSimpleName().length()));
    }

    private Class<?> clazz() {
        return (Class)this.asOpt(Class.class, new Object[]{CONTEXT_CLASS_KEY}).orElse(Context.class);
    }

    public void tryExecute(ExRunnable operation) {
        this.tryExecute(operation, null);
    }

    public void tryExecute(ExRunnable operation, Consumer<Throwable> consumer) {
        NanoUtils.tryExecute(() -> this, operation, consumer);
    }

    public String toString() {
        return ((LinkedTypeMap)((LinkedTypeMap)new LinkedTypeMap().putR((Object)"size", (Object)this.size())).putR((Object)"class", Optional.ofNullable(this.clazz()).map(Class::getSimpleName).orElse(null))).toJson();
    }

    static {
        TypeConversionRegister.registerTypeConvert(String.class, Formatter.class, LogFormatRegister::getLogFormatter);
        TypeConversionRegister.registerTypeConvert(String.class, LogLevel.class, LogLevel::nanoLogLevelOf);
        TypeConversionRegister.registerTypeConvert(LogLevel.class, String.class, Enum::name);
        TypeConversionRegister.registerTypeConvert(Level.class, String.class, Level::toString);
        TypeConversionRegister.registerTypeConvert(String.class, Level.class, level -> LogLevel.nanoLogLevelOf(level).toJavaLogLevel());
        TypeConversionRegister.registerTypeConvert(ContentType.class, String.class, Enum::name);
        TypeConversionRegister.registerTypeConvert(String.class, ContentType.class, ContentType::fromValue);
        TypeConversionRegister.registerTypeConvert(HttpMethod.class, String.class, Enum::name);
        TypeConversionRegister.registerTypeConvert(LogRecord.class, String.class, logRecord -> ((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)new LinkedTypeMap().putR((Object)"message", (Object)logRecord.getMessage())).putR((Object)"level", (Object)LogLevel.nanoLogLevelOf(logRecord.getLevel()).name())).putR((Object)"logger", Optional.ofNullable(logRecord.getLoggerName()).map(s -> s.contains(".") ? s.substring(s.indexOf(".")) : s))).putR((Object)"thrown", (Object)Optional.ofNullable(logRecord.getThrown()).map(Object::getClass).map(Class::getSimpleName).orElse("false"))).toJson());
        TypeConversionRegister.registerTypeConvert(String.class, HttpMethod.class, HttpMethod::valueOf);
        TypeConversionRegister.registerTypeConvert(String.class, HttpClient.Version.class, string -> {
            if ("1".equals(string) || HttpClient.Version.HTTP_1_1.toString().equals(string)) {
                return HttpClient.Version.HTTP_1_1;
            }
            if ("2".equals(string) || HttpClient.Version.HTTP_2.toString().equals(string)) {
                return HttpClient.Version.HTTP_2;
            }
            return null;
        });
    }
}

