/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.services.http;

import berlin.yuna.typemap.logic.TypeConverter;
import berlin.yuna.typemap.model.LinkedTypeMap;
import berlin.yuna.typemap.model.Type;
import berlin.yuna.typemap.model.TypeInfo;
import berlin.yuna.typemap.model.TypeMapI;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.core.model.Service;
import org.nanonative.nano.core.model.Unhandled;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.config.ConfigRegister;
import org.nanonative.nano.helper.event.EventChannelRegister;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.services.http.HttpClient;
import org.nanonative.nano.services.http.model.ContentType;
import org.nanonative.nano.services.http.model.HttpObject;

public class HttpServer
extends Service {
    protected com.sun.net.httpserver.HttpServer server;
    public static final String CONFIG_SERVICE_HTTP_PORT = ConfigRegister.registerConfig("app_service_http_port", "Default port for the HTTP service (see " + HttpServer.class.getSimpleName() + ")");
    public static final String CONFIG_SERVICE_HTTP_CLIENT = ConfigRegister.registerConfig("app_service_http_client", "Boolean if " + HttpClient.class.getSimpleName() + " should start as well");
    public static final int EVENT_HTTP_REQUEST = EventChannelRegister.registerChannelId("HTTP_REQUEST");
    public static final int EVENT_HTTP_REQUEST_UNHANDLED = EventChannelRegister.registerChannelId("HTTP_REQUEST_UNHANDLED");
    protected static final Lock STARTUP_LOCK = new ReentrantLock();

    public InetSocketAddress address() {
        return this.server == null ? null : this.server.getAddress();
    }

    public int port() {
        return this.server == null ? -1 : this.server.getAddress().getPort();
    }

    public com.sun.net.httpserver.HttpServer server() {
        return this.server;
    }

    @Override
    public void stop() {
        this.server.stop(0);
        this.context.info(() -> "[{}] port [{}] stopped", this.name(), this.server == null ? null : Integer.valueOf(this.server.getAddress().getPort()));
        this.server = null;
    }

    @Override
    public void start() {
        STARTUP_LOCK.lock();
        int port = (Integer)this.context.asIntOpt(new Object[]{CONFIG_SERVICE_HTTP_PORT}).filter(p -> p > 0).orElseGet(() -> HttpServer.nextFreePort(8080));
        this.context.put(CONFIG_SERVICE_HTTP_PORT, port);
        HttpServer.handleHttps(this.context);
        try {
            this.server = com.sun.net.httpserver.HttpServer.create(new InetSocketAddress(port), 0);
            this.server.setExecutor(NanoThread.GLOBAL_THREAD_POOL);
            this.server.createContext("/", exchange -> {
                HttpObject request = new HttpObject(exchange);
                try {
                    AtomicBoolean internalError = new AtomicBoolean(false);
                    this.context.sendEventR(EVENT_HTTP_REQUEST, () -> request).peek(HttpServer.setError(internalError)).responseOpt(HttpObject.class).ifPresentOrElse(response -> this.sendResponse(exchange, request, (HttpObject)response), () -> this.context.sendEventR(EVENT_HTTP_REQUEST_UNHANDLED, () -> request).responseOpt(HttpObject.class).ifPresentOrElse(response -> this.sendResponse(exchange, request, (HttpObject)response), () -> this.sendResponse(exchange, request, new HttpObject().statusCode(internalError.get() ? 500 : 404).bodyT((TypeInfo<?>)((LinkedTypeMap)new LinkedTypeMap().putR((Object)"message", (Object)(internalError.get() ? "Internal Server Error" : "Not Found"))).putR((Object)"timestamp", (Object)System.currentTimeMillis())).contentType(ContentType.APPLICATION_PROBLEM_JSON))));
                }
                catch (Exception e) {
                    this.context.sendEventR(Context.EVENT_APP_UNHANDLED, () -> new Unhandled(this.context, request, e)).responseOpt(HttpObject.class).ifPresentOrElse(response -> this.sendResponse(exchange, request, (HttpObject)response), () -> new HttpObject().statusCode(500).body("Internal Server Error".getBytes()).contentType(ContentType.APPLICATION_PROBLEM_JSON));
                }
            });
            this.server.start();
            this.context.info(() -> "[{}] starting on port [{}]", this.name(), port);
            this.context.asBooleanOpt(new Object[]{CONFIG_SERVICE_HTTP_CLIENT}).ifPresent(start -> this.context.runAwait(new HttpClient()));
        }
        catch (IOException e) {
            this.context.error(e, () -> "[{}] failed to start with port [{}]", this.name(), port);
        }
        finally {
            STARTUP_LOCK.unlock();
        }
    }

    @Override
    public void onEvent(Event event) {
    }

    @Override
    public void configure(TypeMapI<?> configs, TypeMapI<?> merged) {
    }

    private static void handleHttps(Context context) {
        Type crt = context.asStringOpt(new Object[]{String.class, "app.https.crt.path"});
        Type key = context.asStringOpt(new Object[]{String.class, "app.https.key.path"});
        if (!crt.isPresent(new Object[0]) || key.isPresent(new Object[0])) {
            // empty if block
        }
    }

    @Override
    public Object onFailure(Event error) {
        return null;
    }

    protected void sendResponse(HttpExchange exchange, HttpObject request, HttpObject response) {
        try {
            byte[] body = response.body();
            int statusCode = response.statusCode() > -1 && response.statusCode() < 600 ? response.statusCode() : 200;
            Optional<String> encoding = request.acceptEncodings().stream().filter(s -> s.equals("gzip") || s.equals("deflate")).findFirst();
            response.headerMap().asMap(String.class, value -> TypeConverter.collectionOf((Object)value, String.class), new Object[0]).forEach((key, value) -> exchange.getResponseHeaders().put((String)key, (List<String>)value));
            response.computedHeaders(false).forEach((key, value) -> exchange.getResponseHeaders().put((String)key, (List<String>)value));
            if (encoding.isPresent()) {
                body = this.encodeBody(body, encoding.get());
            }
            exchange.getResponseHeaders().put("content-encoding", List.of(encoding.orElse("identity")));
            exchange.sendResponseHeaders(statusCode, body.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(body);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected byte[] encodeBody(byte[] body, String contentEncoding) {
        if ("gzip".equalsIgnoreCase(contentEncoding)) {
            return NanoUtils.encodeGzip(body);
        }
        if ("deflate".equalsIgnoreCase(contentEncoding)) {
            return NanoUtils.encodeDeflate(body);
        }
        return body;
    }

    public static int nextFreePort(int startPort) {
        for (int i = 0; i < 1024; ++i) {
            int port = i + Math.max(startPort, 1);
            if (HttpServer.isPortInUse(port)) continue;
            return port;
        }
        throw new IllegalStateException("Could not find any free port");
    }

    public static boolean isPortInUse(int portNumber) {
        try {
            new Socket("localhost", portNumber).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Consumer<Event> setError(AtomicBoolean internalError) {
        return event -> {
            if (event.error() != null) {
                internalError.set(true);
            }
        };
    }
}

