/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.services.logging;

import berlin.yuna.typemap.logic.TypeConverter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.services.logging.LogService;
import org.nanonative.nano.services.logging.model.LogLevel;

public class LogFormatterConsole
extends Formatter {
    protected final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected final int paddingLogLevel = Arrays.stream(LogLevel.values()).map(Enum::toString).mapToInt(String::length).max().orElse(5);

    @Override
    public String format(LogRecord logRecord) {
        StringBuilder formattedLog = new StringBuilder();
        formattedLog.append("[").append(this.dateFormat.format(new Date(logRecord.getMillis()))).append("] [").append(String.format("%-" + this.paddingLogLevel + "s", new Object[]{LogLevel.nanoLogLevelOf(logRecord.getLevel())})).append("] [").append(LogFormatterConsole.formatLoggerName(logRecord)).append("] - ").append(LogFormatterConsole.applyCustomFormat(this.formatMessage(logRecord), logRecord.getParameters())).append(NanoUtils.LINE_SEPARATOR);
        if (logRecord.getThrown() != null) {
            formattedLog.append((String)TypeConverter.convertObj((Object)logRecord.getThrown(), String.class)).append(NanoUtils.LINE_SEPARATOR);
        }
        return formattedLog.toString();
    }

    protected static String formatLoggerName(LogRecord logRecord) {
        int dot = logRecord.getLoggerName().lastIndexOf(".");
        return String.format("%-" + LogService.MAX_LOG_NAME_LENGTH.get() + "s", dot != -1 ? logRecord.getLoggerName().substring(dot + 1) : logRecord.getLoggerName());
    }

    protected static String applyCustomFormat(String message, Object ... params) {
        if (message != null && params != null && params.length > 0) {
            String result = message.replace("{}", "%s");
            return String.format(result, params);
        }
        return message;
    }
}

