/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core;

import berlin.yuna.typemap.logic.ArgsDecoder;
import berlin.yuna.typemap.logic.TypeConverter;
import berlin.yuna.typemap.model.TypeMapI;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Collectors;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.services.logging.LogService;

public abstract class NanoBase<T extends NanoBase<T>> {
    protected final Context context;
    protected final long createdAtMs;
    protected final LogService logService;
    protected final Map<Integer, Set<Consumer<Event>>> listeners = new ConcurrentHashMap<Integer, Set<Consumer<Event>>>();
    protected final AtomicBoolean isReady = new AtomicBoolean(true);
    protected final AtomicInteger eventCount = new AtomicInteger(0);
    public static final Map<Integer, String> EVENT_TYPES = new ConcurrentHashMap<Integer, String>();
    public static final Map<String, String> CONFIG_KEYS = new ConcurrentHashMap<String, String>();
    public static final AtomicInteger EVENT_ID_COUNTER = new AtomicInteger(0);

    protected NanoBase(Map<Object, Object> configs, String ... args) {
        this.createdAtMs = System.currentTimeMillis();
        this.context = this.readConfigs(args);
        if (configs != null) {
            configs.forEach((key, value) -> this.context.computeIfAbsent(TypeConverter.convertObj((Object)key, String.class), add -> Optional.ofNullable(value).orElse("")));
        }
        this.logService = new LogService();
        this.logService.context(this.context);
        this.logService.configure((TypeMapI<?>)this.context, (TypeMapI<?>)this.context);
        this.logService.start();
        this.logService.isReadyState().set(true);
        this.displayHelpMenu();
        this.subscribeEvent(Context.EVENT_CONFIG_CHANGE, event -> event.payloadOpt(Map.class).map(this::putAll).ifPresent(nano -> event.acknowledge()));
    }

    abstract Context context(Class<?> var1);

    abstract T sendEvent(Event var1);

    abstract Event sendEventR(Event var1);

    public NanoBase<T> putAll(Map<?, ?> map) {
        this.context.putAll(map);
        return this;
    }

    public abstract T stop(Class<?> var1);

    public abstract T stop(Context var1);

    public Map<Integer, Set<Consumer<Event>>> listeners() {
        return this.listeners;
    }

    public T subscribeEvent(int channelId, Consumer<Event> listener) {
        this.listeners.computeIfAbsent(channelId, value -> new LinkedHashSet()).add(listener);
        return (T)this;
    }

    public T unsubscribeEvent(int channelId, Consumer<Event> listener) {
        this.listeners.computeIfAbsent(channelId, value -> new LinkedHashSet()).remove(listener);
        return (T)this;
    }

    public long pid() {
        return ProcessHandle.current().pid();
    }

    public double usedMemoryMB() {
        Runtime runtime = Runtime.getRuntime();
        return BigDecimal.valueOf((double)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public double heapMemoryUsage() {
        MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        return BigDecimal.valueOf((double)heapMemoryUsage.getUsed() / (double)heapMemoryUsage.getMax()).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public long createdAtMs() {
        return this.createdAtMs;
    }

    public boolean isReady() {
        return this.isReady.get();
    }

    public int eventCount() {
        return this.eventCount.get();
    }

    protected void displayHelpMenu() {
        if (this.context.asBooleanOpt(new Object[]{Context.APP_HELP}).filter(helpCalled -> helpCalled).isPresent(new Object[0])) {
            int keyLength = CONFIG_KEYS.keySet().stream().mapToInt(String::length).max().orElse(0);
            this.logService.log(() -> {
                LogRecord logRecord = new LogRecord(Level.INFO, "Available configs keys: " + System.lineSeparator() + CONFIG_KEYS.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(conf -> String.format("%-" + keyLength + "s  %s", conf.getKey(), conf.getValue())).collect(Collectors.joining(System.lineSeparator())));
                logRecord.setLoggerName(this.getClass().getCanonicalName());
                return logRecord;
            });
            if (((Boolean)this.context.asBooleanOpt(new Object[]{Context.CONFIG_ENV_PROD}).orElse((Object)false)).booleanValue()) {
                System.exit(0);
            }
        }
    }

    protected Context readConfigs(String ... args) {
        Context result = NanoUtils.readConfigFiles(null, "");
        System.getenv().forEach((key, value) -> NanoUtils.addConfig(result, key, value));
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> NanoUtils.addConfig(result, key, value)));
        if (args != null) {
            ArgsDecoder.argsOf((String)String.join((CharSequence)" ", args)).forEach((key, value) -> NanoUtils.addConfig(result, key, value));
        }
        return NanoUtils.resolvePlaceHolders(result);
    }

    public static String standardiseKey(Object key) {
        return key == null ? null : ((String)TypeConverter.convertObj((Object)key, String.class)).replace('.', '_').replace('-', '_').replace('+', '_').replace(':', '_').trim().toLowerCase();
    }
}

